---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, polices de caractères, fontes T1
---

# Comment utiliser des fontes Adobe Type 1 avec (La)TeX ?

Pour utiliser une police, TeX a besoin d'un fichier de *métrique* (fichier TFM). 
Plusieurs ensembles de métriques pour les polices Adobe Type 1 courantes 
sont disponibles dans les distributions. Si vous souhaitez en générer de nouveaux, 
consultez la question "[](/5_fichiers/formats/fontes/fichiers_de_metriques_pour_les_fontes_t1)". 
Ceci fait, vous avez également besoin des fontes elles-mêmes.
Les imprimantes PostScript sont livrées avec un ensemble de polices intégrées. 
Cependant, pour étendre votre répertoire, vous devez généralement en acheter 
auprès de l'un des nombreux vendeurs de fontes commerciales 
(voir, par exemple, la question "[](/5_fichiers/formats/fontes/fontes_t1_pour_les_mathematiques)").

Si vous utilisez LaTeX2e, 
l'accès aux polices de votre imprimante est donné par l'extension [PSNFSS](ctanpkg:psnfss). 
L'équipe du projet LaTeX3 déclare que PSNFSS est une partie "obligatoire" d'une distribution LaTeX.
Les rapports de bogues peuvent être d'ailleurs être soumis via le 
[système de bogues LaTeX](/2_programmation/syntaxe/rediger_un_rapport_de_bug). 
PSNFSS vous donne un ensemble d'extensions pour changer les polices par défaut, 
romaines, sans-serif et à chasse fixe : 
- l'extension <ctanpkg:mathptmx> définit *Times Roman* comme police de texte principale.
  Elle introduit également des mécanismes pour composer les mathématiques en utilisant `Times` 
  et diverses polices plus ou moins correspondantes ;
- l'extension [avant](ctanpkg:psnfss) change la famille sans-serif en *AvantGarde* ; 
- l'extension[courier](ctanpkg:psnfss) change la police de la machine à écrire en `Courier`. 

Pour accompagner ces extensions, vous avez besoin des fichiers de métriques des polices 
et des fichiers de description des polices (`.fd`) 
pour chaque famille de polices que vous voulez utiliser. 
Par commodité, les métriques des polices PostScript "common 35" 
que l'on trouve dans la plupart des imprimantes PostScript sont fournies avec PSNFSS, 
sous la forme de "l'ensemble imprimante lase" (*Laserwriter set*).

Pour les anciennes versions de LaTeX, il existe différentes possibilités, 
dont la plus simple à utiliser est probablement les macros PSLaTeX distribuées avec `dvips`.

Pour Plain TeX, vous chargez les polices que vous voulez ; 
si l'encodage des polices n'est pas le même que celui de *Computer Modern*, 
vous devrez redéfinir diverses commandes et accents, 
ou vous pouvez utiliser les mécanismes de réencodage des polices disponibles 
dans de nombreux pilotes ainsi que dans `ps2pk` et `afm2tfm`.

Certains problèmes courants rencontrés sont discutés ailleurs 
(par exemple la question 
"[](/5_fichiers/formats/fontes/installation_de_fontes/installer_une_police_t1)").

:::{sources}
[Using Adobe Type 1 fonts with TeX](faquk:FAQ-usepsfont)
:::