/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.convert;

import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.convert.TabularGraphTypes;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphEntityType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightEntity;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightLink;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightPart;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLinkType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphPartType;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.Evaluator;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;

public class TabularGraphPartFactory {
    protected final TabularGraphTypes _types;

    public TabularGraphPartFactory(TabularGraphTypes _types) {
        this._types = _types;
    }

    public List<TabularGraphLightweightEntity> processEntities(List<Object> row) throws Exception {
        TabularGraphEntityType[] entityTypes = this._types.getEntityTypes();
        ArrayList<TabularGraphLightweightEntity> entities = new ArrayList<TabularGraphLightweightEntity>(entityTypes.length);
        for (TabularGraphEntityType type : entityTypes) {
            if (!this.shouldAdd(type, row)) continue;
            TabularGraphLightweightEntity entity = new TabularGraphLightweightEntity();
            this.updatePart(entity, type, row);
            entities.add(entity);
        }
        return entities;
    }

    public List<TabularGraphLightweightLink> processLinks(List<Object> row, List<TabularGraphLightweightEntity> entities) throws Exception {
        TabularGraphLinkType[] linkTypes = this._types.getLinkTypes();
        ArrayList<TabularGraphLightweightLink> links = new ArrayList<TabularGraphLightweightLink>(linkTypes.length);
        for (TabularGraphLinkType type : linkTypes) {
            TabularGraphLightweightLink link = this.getLinkWithEndpoints(type, entities);
            TabularGraphLightweightEntity source = link.sourceEntity;
            TabularGraphLightweightEntity target = link.targetEntity;
            if (source == null || target == null || source.equals(target)) continue;
            this.updatePart(link, type, row);
            if (!this.shouldAdd(type, link)) continue;
            links.add(link);
        }
        return links;
    }

    protected boolean shouldAdd(TabularGraphEntityType type, List<Object> row) throws Exception {
        return true;
    }

    protected boolean shouldAdd(TabularGraphLinkType type, TabularGraphLightweightLink lightLink) throws Exception {
        return true;
    }

    protected void updatePart(TabularGraphLightweightPart part, TabularGraphPartType type, List<Object> row) {
        part.type = type;
        part.matchPropertyValues = this.getValues(row, type.matchPropertyIndexes);
        part.otherPropertyValues = this.getValues(row, type.otherPropertyIndexes);
        part.row = row;
        this.updateCalculatedValue(part);
    }

    protected TabularGraphLightweightLink getLinkWithEndpoints(TabularGraphLinkType type, List<TabularGraphLightweightEntity> entities) {
        TabularGraphLightweightLink link = new TabularGraphLightweightLink();
        TabularGraphEntity source = type.tabularLink.getSource();
        TabularGraphEntity target = type.tabularLink.getTarget();
        for (TabularGraphLightweightEntity entity : entities) {
            TabularGraphEntity tabularEntity = ((TabularGraphEntityType)entity.type).tabularEntity;
            if (source.equals(tabularEntity)) {
                link.sourceEntity = entity;
                if (link.targetEntity == null) continue;
                break;
            }
            if (!target.equals(tabularEntity)) continue;
            link.targetEntity = entity;
            if (link.sourceEntity == null) continue;
            break;
        }
        return link;
    }

    protected void updateCalculatedValue(TabularGraphLightweightPart part) {
        DisplayDescriptor calculatedProp;
        Evaluator eval;
        TabularGraphPartType type = part.type;
        if (type.calculatedPropertyIndex >= 0 && (eval = (calculatedProp = (DisplayDescriptor)type.matchProperties[type.calculatedPropertyIndex]).getEvaluator()) != null) {
            String calculatedValue;
            DataSources.Map dataSource = new DataSources.Map();
            for (int i = 0; i < type.otherProperties.length; ++i) {
                PropertyDescriptor property = type.otherProperties[i];
                Object value = part.otherPropertyValues[i];
                dataSource.put((Object)property, value);
            }
            Object defaultValue = calculatedProp.getDefaultValue();
            if (defaultValue instanceof String && (calculatedValue = eval.evaluate((String)defaultValue, (DataSource)dataSource)) != null) {
                part.matchPropertyValues[type.calculatedPropertyIndex] = calculatedValue;
            }
        }
    }

    protected Object[] getValues(List<Object> row, int[] indexes) {
        int count = indexes.length;
        Object[] values = new Object[count];
        for (int j = 0; j < count; ++j) {
            Object obj;
            int index = indexes[j];
            if (index < 0 || index >= row.size()) continue;
            values[j] = obj = row.get(index);
        }
        return values;
    }
}

