/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.runviews.list;

import com.paterva.maltego.runregistry.item.RunnableItem;
import com.paterva.maltego.runviews.favs.FavoritesIcon;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.UIManager;

class ToolbarFavoriteAction
extends AbstractAction {
    private static final Integer POSITION = 400;
    private static final String TOOLTIP = "Favorite";
    private final RunnableItem _item;

    public ToolbarFavoriteAction(RunnableItem item) {
        this._item = item;
        this.putValue("position", POSITION);
        this.putValue("tooltip", TOOLTIP);
        this.putValue("icon", new ToolbarFavoriteIcon());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._item.setFavorite(!this._item.isFavorite());
    }

    private class ToolbarFavoriteIcon
    extends FavoritesIcon {
        private ToolbarFavoriteIcon() {
        }

        @Override
        protected void draw(Graphics2D g2D, int h, Component c) {
            String colorProp = String.format("run-favorites-%s-favorite-color", ToolbarFavoriteAction.this._item.isFavorite() ? "is" : "not");
            Color color = UIManager.getLookAndFeelDefaults().getColor(colorProp);
            GraphicsUtils.drawShadedFatPentagram((Graphics2D)g2D, (int)0, (int)0, (int)h, (int)h, (Color)color, (Color)color, (Color)color, (boolean)true, (boolean)this.drawOutline(c));
        }

        private boolean drawOutline(Component c) {
            ButtonModel model = ((JButton)c).getModel();
            return model.isRollover() || model.isArmed();
        }
    }
}

