/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.actions.PlaceLabelsAction;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import com.paterva.maltego.ui.graph.transactions.GraphPositionAndPathHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.X;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.J.SA;
import yguard.A.J.eA;
import yguard.A.J.q;

public class BendClearingMoveMode
extends eA {
    private static final Logger LOG = Logger.getLogger(BendClearingMoveMode.class.getName());
    private Map<EntityID, Point> _centersBefore = Collections.emptyMap();
    private Map<LinkID, List<Point>> _pathsBefore = Collections.emptyMap();

    public BendClearingMoveMode() {
        this.setRemovingInnerBends(true);
    }

    protected void selectionMoveStarted(double x2, double y2) {
        LOG.fine("Move started");
        X nodes = this.getNodesToBeMoved();
        Set<EntityID> entityIDs = this.toEntityIDs(nodes);
        this._centersBefore = GraphPositionAndPathHelper.getViewCenters(this.view.getGraph2D(), entityIDs);
        this._pathsBefore = GraphPositionAndPathHelper.getViewPathsForEntities(this.view.getGraph2D(), entityIDs);
        this.clearBends(nodes);
        super.selectionMoveStarted(x2, y2);
        GraphDataObject gdo = GraphDataUtils.getGraphDataObject((D)this.view.getGraph2D());
        if (gdo != null) {
            gdo.setModified(true);
        }
    }

    protected void selectionMovedAction(double d2, double d1, double d22, double d3) {
        LOG.fine("Move action");
        this.createTransaction();
        this._centersBefore = Collections.emptyMap();
        this._pathsBefore = Collections.emptyMap();
        PlaceLabelsAction action = (PlaceLabelsAction)SystemAction.get(PlaceLabelsAction.class);
        if (action != null) {
            action.perform(this.view.getGraph2D(), null);
        }
    }

    public void reactivateParent() {
        LOG.fine("Reactivate parent");
        super.reactivateParent();
    }

    private void clearBends(X nodes) {
        SA graph = this.view.getGraph2D();
        E nc = nodes.\u0121();
        while (nc.ok()) {
            Z ec = nc.B().I();
            while (ec.ok()) {
                q er = graph.X(ec.D());
                if (er != null) {
                    er.clearBends();
                }
                ec.next();
            }
            nc.next();
        }
    }

    private void createTransaction() {
        try {
            SA viewGraph2D = this.view.getGraph2D();
            GraphID graphID = GraphIDProvider.forGraph((SA)viewGraph2D);
            X nodes = this.getNodesToBeMoved();
            Set<EntityID> entitiesAfter = this.toEntityIDs(nodes);
            GraphStoreView graphStoreView = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            Set modelEntities = graphStoreView.getModelViewMappings().getModelEntities(entitiesAfter);
            String description = "Move selected " + GraphTransactionHelper.getDescriptionForEntityIDs(graphID, (Collection<EntityID>)modelEntities, true);
            GraphTransactionHelper.commitLayoutChanges(new SimilarStrings(description), viewGraph2D, entitiesAfter, this._centersBefore, this._pathsBefore, true);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Set<EntityID> toEntityIDs(X nodes) {
        SA graph2D = this.getGraph2D();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph2D);
        HashSet<EntityID> entities = new HashSet<EntityID>(nodes.size());
        E nc = nodes.\u0121();
        while (nc.ok()) {
            Y node = nc.B();
            entities.add(wrapper.entityID(node));
            nc.next();
        }
        return entities;
    }
}

