/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.pyramidio.tools;

import gov.nist.isg.pyramidio.tools.BufferedImageHelper;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class ImageResizingHelper {
    private ImageResizingHelper() {
    }

    public static BufferedImage resizeImage(BufferedImage img, int width, int height) {
        int currentWidth = img.getWidth();
        int currentHeight = img.getHeight();
        if (currentWidth == width && currentHeight == height) {
            return img;
        }
        if (img.getType() == 11) {
            return ImageResizingHelper.resize16bppImage(img, width, height);
        }
        if (img.getColorModel().getPixelSize() == 32) {
            return ImageResizingHelper.resize32bppImage(img, width, height);
        }
        if (width > currentWidth || height > currentHeight) {
            return ImageResizingHelper.resizeImageGraphics2D(img, width, height);
        }
        BufferedImage result = img;
        double ratio = 0.79;
        do {
            if (currentWidth > width && (currentWidth = (int)((double)currentWidth * ratio)) < width) {
                currentWidth = width;
            }
            if (currentHeight > height && (currentHeight = (int)((double)currentHeight * ratio)) < height) {
                currentHeight = height;
            }
            result = ImageResizingHelper.resizeImageGraphics2D(result, currentWidth, currentHeight);
        } while (currentWidth != width || currentHeight != height);
        return result;
    }

    private static BufferedImage resizeImageGraphics2D(BufferedImage img, int width, int height) {
        BufferedImage result = new BufferedImage(width, height, img.getType());
        Graphics2D g = result.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(img, 0, 0, width, height, 0, 0, img.getWidth(), img.getHeight(), null);
        g.dispose();
        return result;
    }

    private static BufferedImage resize16bppImage(BufferedImage img, int dstWidth, int dstHeight) {
        BufferedImage result = new BufferedImage(dstWidth, dstHeight, img.getType());
        WritableRaster raster = result.getRaster();
        int width = img.getWidth();
        int height = img.getHeight();
        double srcCenterX = (double)width / 2.0;
        double srcCenterY = (double)height / 2.0;
        double xScale = (double)dstWidth / (double)width;
        double yScale = (double)dstHeight / (double)height;
        double dstCenterX = ((double)dstWidth + xScale) / 2.0;
        double dstCenterY = ((double)dstHeight + yScale) / 2.0;
        for (int y = 0; y < dstHeight; ++y) {
            double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
            for (int x = 0; x < dstWidth; ++x) {
                double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                int value = (int)(ImageResizingHelper.getBicubicInterpolatedPixel(img, xs, ys) + 0.5);
                if (value < 0) {
                    value = 0;
                }
                if (value > 65535) {
                    value = 65535;
                }
                raster.setSample(x, y, 0, value);
            }
        }
        return result;
    }

    private static BufferedImage resize32bppImage(BufferedImage img, int dstWidth, int dstHeight) {
        BufferedImage result = BufferedImageHelper.createBufferedImage(dstWidth, dstHeight, img);
        WritableRaster raster = result.getRaster();
        int width = img.getWidth();
        int height = img.getHeight();
        double srcCenterX = (double)width / 2.0;
        double srcCenterY = (double)height / 2.0;
        double xScale = (double)dstWidth / (double)width;
        double yScale = (double)dstHeight / (double)height;
        double dstCenterX = ((double)dstWidth + xScale) / 2.0;
        double dstCenterY = ((double)dstHeight + yScale) / 2.0;
        for (int y = 0; y < dstHeight; ++y) {
            double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
            for (int x = 0; x < dstWidth; ++x) {
                double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                float value = (float)ImageResizingHelper.getBicubicInterpolatedPixel(img, xs, ys);
                raster.setSample(x, y, 0, value);
            }
        }
        return result;
    }

    private static double getBicubicInterpolatedPixel(BufferedImage image, double x0, double y0) {
        int width = image.getWidth();
        int height = image.getHeight();
        int u0 = (int)Math.floor(x0);
        int v0 = (int)Math.floor(y0);
        if (u0 <= 0 || u0 >= width - 2 || v0 <= 0 || v0 >= height - 2) {
            return ImageResizingHelper.getBilinearInterpolatedPixel(image, x0, y0);
        }
        WritableRaster raster = image.getRaster();
        double q = 0.0;
        for (int j = 0; j <= 3; ++j) {
            int v = v0 - 1 + j;
            double p = 0.0;
            for (int i = 0; i <= 3; ++i) {
                int u = u0 - 1 + i;
                p += raster.getSampleDouble(u, v, 0) * ImageResizingHelper.cubic(x0 - (double)u);
            }
            q += p * ImageResizingHelper.cubic(y0 - (double)v);
        }
        return q;
    }

    private static double getBilinearInterpolatedPixel(BufferedImage image, double x, double y) {
        double lowerAverage;
        double upperAverage;
        int width = image.getWidth();
        int height = image.getHeight();
        if (x < -1.0 || x >= (double)width || y < -1.0 || y >= (double)height) {
            return 0.0;
        }
        if (width == 1 && height == 1) {
            return image.getRaster().getSampleDouble(0, 0, 0);
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (x >= (double)width - 1.0) {
            x = (double)width - 1.001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if (y >= (double)height - 1.0) {
            y = (double)height - 1.001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        WritableRaster raster = image.getRaster();
        if (height == 1) {
            double left = raster.getSampleDouble(xbase, ybase, 0);
            double right = raster.getSampleDouble(xbase + 1, ybase, 0);
            if (Double.isNaN(left) && xFraction >= 0.5) {
                return right;
            }
            if (Double.isNaN(right) && xFraction < 0.5) {
                return left;
            }
            return left + xFraction * (right - left);
        }
        if (width == 1) {
            upperAverage = raster.getSampleDouble(xbase, ybase, 0);
            lowerAverage = raster.getSampleDouble(xbase, ybase + 1, 0);
        } else {
            double lowerLeft = raster.getSampleDouble(xbase, ybase, 0);
            double lowerRight = raster.getSampleDouble(xbase + 1, ybase, 0);
            double upperLeft = raster.getSampleDouble(xbase, ybase + 1, 0);
            double upperRight = raster.getSampleDouble(xbase + 1, ybase + 1, 0);
            upperAverage = Double.isNaN(upperLeft) && xFraction >= 0.5 ? upperRight : (Double.isNaN(upperRight) && xFraction < 0.5 ? upperLeft : upperLeft + xFraction * (upperRight - upperLeft));
            lowerAverage = Double.isNaN(lowerLeft) && xFraction >= 0.5 ? lowerRight : (Double.isNaN(lowerRight) && xFraction < 0.5 ? lowerLeft : lowerLeft + xFraction * (lowerRight - lowerLeft));
        }
        if (Double.isNaN(lowerAverage) && yFraction >= 0.5) {
            return upperAverage;
        }
        if (Double.isNaN(upperAverage) && yFraction < 0.5) {
            return lowerAverage;
        }
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    private static double cubic(double x) {
        if (x < 0.0) {
            x = -x;
        }
        double z = 0.0;
        double a = 0.5;
        if (x < 1.0) {
            z = x * x * (x * (-a + 2.0) + (a - 3.0)) + 1.0;
        } else if (x < 2.0) {
            z = -a * x * x * x + 5.0 * a * x * x - 8.0 * a * x + 4.0 * a;
        }
        return z;
    }
}

