/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KeyDerivation {
    private final String algorithm;
    private final String salt;
    private final int iterations;
    private final int length;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public KeyDerivation(@JsonProperty(value="algorithm", required=true) String algorithm, @JsonProperty(value="salt", required=true) String salt, @JsonProperty(value="iterations", required=true) int iterations, @JsonProperty(value="length", required=true) int length) {
        this.algorithm = algorithm;
        this.salt = salt;
        this.iterations = iterations;
        this.length = length;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getSalt() {
        return this.salt;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyDerivation)) {
            return false;
        }
        KeyDerivation config = (KeyDerivation)o;
        return Objects.equals(this.algorithm, config.algorithm) && Objects.equals(this.salt, config.salt) && Objects.equals(this.iterations, config.iterations) && Objects.equals(this.length, config.length);
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, this.salt, this.iterations, this.length);
    }

    public String toString() {
        return "KeyDerivation{algorithm=" + this.algorithm + ", salt=" + this.salt + ", iterations=" + this.iterations + ", length=" + this.length + '}';
    }
}

