/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.imex;

import com.paterva.maltego.importexport.ConfigFolderNode;
import com.paterva.maltego.pws.imex.SelectableServiceType;
import com.paterva.maltego.pws.imex.ServiceConfig;
import com.paterva.maltego.pws.imex.ServiceExistInfo;
import com.paterva.maltego.pws.imex.ServiceTypeNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class ServiceConfigNode
extends ConfigFolderNode {
    ServiceConfigNode(ServiceConfig serviceConfig, ServiceExistInfo existInfo) {
        this(serviceConfig, new InstanceContent(), existInfo);
    }

    private ServiceConfigNode(ServiceConfig serviceConfig, InstanceContent content, ServiceExistInfo existInfo) {
        super((Children)new ServiceChildren(serviceConfig, existInfo), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.addLookups(content, serviceConfig);
        this.setName("Services");
        this.setShortDescription(serviceConfig.getSelectableServiceTypes().size() + " Service Types (" + serviceConfig.getServiceCount() + " Services)");
        this.setSelectedNonRecursive(!serviceConfig.getSelectedServiceTypes().isEmpty());
    }

    private void addLookups(InstanceContent content, ServiceConfig serviceConfig) {
        content.add((Object)serviceConfig);
        content.add((Object)this);
    }

    private static class ServiceChildren
    extends Children.Keys<SelectableServiceType> {
        private final ServiceExistInfo _existInfo;

        public ServiceChildren(ServiceConfig serviceConfig, ServiceExistInfo existInfo) {
            this._existInfo = existInfo;
            this.setKeys(serviceConfig.getSelectableServiceTypes());
        }

        protected Node[] createNodes(SelectableServiceType servicetype) {
            ServiceTypeNode servicetypeNode = new ServiceTypeNode(servicetype, this._existInfo);
            return new Node[]{servicetypeNode};
        }
    }
}

