/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.rules.standalone;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.views.impl.CollectStrategy;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.ModelSnapshotData;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.Pair;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.tools.CollectionUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StandAloneCollectionRule
implements CollectStrategy {
    private final InMemoryCollectionNodes _collectionNodes;

    public StandAloneCollectionRule(InMemoryCollectionNodes collectionNodes) {
        this._collectionNodes = collectionNodes;
    }

    @Override
    public void collect(ModelSnapshotData msd, Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links) throws GraphStoreException {
        HashMap<String, Set<EntityID>> collections = new HashMap<String, Set<EntityID>>();
        Set<EntityID> keySet = entities.keySet();
        for (EntityID entity : keySet) {
            EntityLinks entityLinks = entities.get(entity);
            if (entityLinks.hasViewOrModelLinks() || !CollectionUtils.isCollectable(msd, entity, 0)) continue;
            this.addOrCreate(msd, collections, entity);
        }
        if (!collections.isEmpty()) {
            this.createOrAddToCollection(msd, collections, keySet);
        }
    }

    private void addOrCreate(ModelSnapshotData msd, Map<String, Set<EntityID>> collections, EntityID entity) throws GraphStoreException {
        String entityType = msd.getEntityType(entity);
        Set<EntityID> collectionSet = collections.get(entityType);
        if (collectionSet == null) {
            collectionSet = new HashSet<EntityID>();
            collections.put(entityType, collectionSet);
        }
        collectionSet.add(entity);
    }

    private void createOrAddToCollection(ModelSnapshotData msd, Map<String, Set<EntityID>> collections, Set<EntityID> entities) throws GraphStoreException {
        for (Map.Entry<String, Set<EntityID>> entry : collections.entrySet()) {
            String type = entry.getKey();
            Set<EntityID> collectionSet = entry.getValue();
            if (collectionSet.size() < msd.getMinEntityCountForCollection(type)) continue;
            ViewEntity viewEntityCollection = new ViewEntity(type, new EntityLinks());
            Pair<EntityID, ViewEntity> entPair = this._collectionNodes.getFirstViewEntityThatIsACollection(collectionSet);
            EntityID standAloneCollection = entPair != null && !msd.collectedViewEntitiesContains(entPair.getOne()) ? entPair.getOne() : EntityID.create();
            viewEntityCollection.getCollection().addAll(collectionSet);
            msd.addToCollectedViewEntities(standAloneCollection, viewEntityCollection);
            entities.removeAll(collectionSet);
        }
    }

    @Override
    public Set<EntityID> determineTouchedViewEntities(GraphStructureMods imsm, GraphDataMods imdm) throws GraphStoreException {
        return this._collectionNodes.getViewEntitiesWithNoLinksUnmodifiable();
    }
}

