/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.CollectionMods;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.views.collect.CollectionSettings;
import com.paterva.maltego.graph.store.views.collect.CollectionTutorialAction;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.actions.SystemAction;

public class ModelSnapshotData {
    private static final Logger LOG = Logger.getLogger(ModelSnapshotData.class.getName());
    private final GraphStructureMods _viewMods;
    private final Map<EntityID, ViewEntity> _viewEntities;
    private final Map<LinkID, LinkID> _modelLinkToCollectionLink = new HashMap<LinkID, LinkID>();
    private final Map<LinkID, ViewLink> _collectedViewLinks = new HashMap<LinkID, ViewLink>();
    private final Map<EntityID, EntityID> _modelEntityToCollectionEntity = new HashMap<EntityID, EntityID>();
    private final Map<EntityID, ViewEntity> _collectedViewEntities = new HashMap<EntityID, ViewEntity>();
    private final Map<EntityID, Boolean> _modelEntityPinnedCache;
    private final Map<EntityID, MaltegoEntity> _modelEntitySkeletonCache;
    private final Map<EntityID, String> _modelEntityTypeCache;
    private final int _minEntityCountForCollection;
    private final boolean _recollectingEntireGraph;
    private final Map<EntityID, EntityLinks> _modelEntitiesToCollect;
    private final Map<LinkID, LinkEntityIDs> _modelLinksToCollect;
    private final Map<EntityID, Integer> _modelEntityNeighboursCache = new HashMap<EntityID, Integer>();

    public ModelSnapshotData(GraphStructureMods viewMods, Map<EntityID, ViewEntity> viewEntities, Map<EntityID, Boolean> modelEntitiesToCollectPinnedStatus, Map<EntityID, MaltegoEntity> modelEntitiesToCollectEntitySkeletons, Map<EntityID, String> modelEntityTypeCache, int minEntityCountForCollection, boolean recollectingEntireGraph, Map<EntityID, EntityLinks> modelEntitiesToCollect, Map<LinkID, LinkEntityIDs> modelLinksToCollect) {
        this._viewMods = viewMods;
        this._viewEntities = viewEntities;
        this._modelEntityPinnedCache = modelEntitiesToCollectPinnedStatus;
        this._modelEntitySkeletonCache = modelEntitiesToCollectEntitySkeletons;
        this._modelEntityTypeCache = modelEntityTypeCache;
        this._minEntityCountForCollection = minEntityCountForCollection;
        this._recollectingEntireGraph = recollectingEntireGraph;
        this._modelEntitiesToCollect = Collections.unmodifiableMap(modelEntitiesToCollect);
        this._modelLinksToCollect = Collections.unmodifiableMap(modelLinksToCollect);
    }

    public ModelSnapshotData(Map<EntityID, Boolean> modelEntitiesToCollectPinnedStatus, Map<EntityID, MaltegoEntity> modelEntitiesToCollectEntitySkeletons, Map<EntityID, String> modelEntityTypeCache, int minEntityCountForCollection, Set<EntityID> collectionEntityIDsReused, Set<LinkID> collectionLinkIDsReused, boolean recollectingEntireGraph, Map<EntityID, EntityLinks> modelEntitiesToCollect, Map<LinkID, LinkEntityIDs> modelLinksToCollect) {
        this(null, Collections.unmodifiableMap(Collections.EMPTY_MAP), modelEntitiesToCollectPinnedStatus, modelEntitiesToCollectEntitySkeletons, modelEntityTypeCache, minEntityCountForCollection, recollectingEntireGraph, modelEntitiesToCollect, modelLinksToCollect);
        for (EntityID entityID : collectionEntityIDsReused) {
            this._collectedViewEntities.put(entityID, null);
        }
        for (LinkID linkID : collectionLinkIDsReused) {
            this._collectedViewLinks.put(linkID, null);
        }
    }

    static Map<EntityID, EntityLinks> deepCopySnapshotEntities(Map<EntityID, EntityLinks> map) {
        HashMap<EntityID, EntityLinks> ret = new HashMap<EntityID, EntityLinks>(map.size());
        for (Map.Entry<EntityID, EntityLinks> entry : map.entrySet()) {
            EntityID key = entry.getKey();
            EntityLinks value = entry.getValue();
            ret.put(key, new EntityLinks(value));
        }
        return ret;
    }

    static Map<LinkID, LinkEntityIDs> deepCopySnapshotLinks(Map<LinkID, LinkEntityIDs> map) {
        HashMap<LinkID, LinkEntityIDs> ret = new HashMap<LinkID, LinkEntityIDs>(map.size());
        for (Map.Entry<LinkID, LinkEntityIDs> entry : map.entrySet()) {
            LinkID key = entry.getKey();
            LinkEntityIDs value = entry.getValue();
            ret.put(key, new LinkEntityIDs(value));
        }
        return ret;
    }

    public Map<EntityID, EntityLinks> getModelEntitiesToCollect() {
        return this._modelEntitiesToCollect;
    }

    public Map<LinkID, LinkEntityIDs> getModelLinksToCollect() {
        return this._modelLinksToCollect;
    }

    public Map<EntityID, Integer> getModelEntityNeighboursCache() {
        return this._modelEntityNeighboursCache;
    }

    public Integer getNeighbourCount(EntityID modelEntity) {
        return this._modelEntityNeighboursCache.get(modelEntity);
    }

    public void setNeighbourCount(EntityID modelEntity, int count) {
        this._modelEntityNeighboursCache.put(modelEntity, count);
    }

    public boolean isEntityPinned(EntityID modelEntity) throws GraphStoreException {
        Boolean pinned = this._modelEntityPinnedCache.get(modelEntity);
        if (pinned == null) {
            throw new GraphStoreException("No pinned state for entityID '" + modelEntity + "'");
        }
        return pinned;
    }

    public String getEntityType(EntityID modelEntity) throws GraphStoreException {
        String type = this._modelEntityTypeCache.get(modelEntity);
        if (type == null) {
            throw new GraphStoreException("No type for entityID '" + modelEntity + "'");
        }
        return type;
    }

    public MaltegoEntity getEntitySkeleton(EntityID modelEntity) throws GraphStoreException {
        MaltegoEntity entitySkeleton = this._modelEntitySkeletonCache.get(modelEntity);
        if (entitySkeleton == null) {
            throw new GraphStoreException("No MaltegoEntity for entityID '" + modelEntity + "'");
        }
        return entitySkeleton;
    }

    private void addRemovedLinkToViewMods(LinkID link, LinkEntityIDs ids) {
        if (link == null || ids == null) {
            throw new IllegalArgumentException("LinkID or LinkEntityIDs argument is null");
        }
        if (!this._viewMods.getLinksAdded().remove(link)) {
            this._viewMods.getLinksRemoved().put(link, ids);
        }
    }

    private void addAddedLinkToViewMods(LinkID link) {
        if (link == null) {
            throw new IllegalArgumentException("LinkID argument is null");
        }
        if (this._viewMods.getLinksRemoved().remove(link) == null) {
            this._viewMods.getLinksAdded().add(link);
        }
    }

    private void addRemovedEntityToViewMods(EntityID entity) {
        if (entity == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        if (!this._viewMods.getEntitiesAdded().remove(entity)) {
            this._viewMods.getEntitiesRemoved().add(entity);
        }
    }

    private void addAddedEntityToViewMods(EntityID entity) {
        if (entity == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        if (!this._viewMods.getEntitiesRemoved().remove(entity)) {
            this._viewMods.getEntitiesAdded().add(entity);
        }
    }

    private void markEntityAsUpdated(EntityID entity, int added, int removed, int total) {
        if (entity == null) {
            throw new IllegalArgumentException("EntityID argument is null");
        }
        if (this._viewMods != null) {
            CollectionSettings setttings = CollectionSettings.getDefault();
            if (setttings.isShowTutorial()) {
                ((CollectionTutorialAction)SystemAction.get(CollectionTutorialAction.class)).showTutorial();
                setttings.setShowTutorial(false);
            }
            this._viewMods.getCollectionMods().put(entity, new CollectionMods(added, removed, total));
        }
    }

    boolean isLinkCollected(LinkID modelLink) {
        return this._modelLinkToCollectionLink.containsKey(modelLink);
    }

    LinkID getCollectionLink(LinkID modelLink) {
        return this._modelLinkToCollectionLink.get(modelLink);
    }

    public void addToCollectedViewLinks(LinkID link, ViewLink viewLink) {
        ViewLink collectionViewLink;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Added link {0} -> {1}", new Object[]{link.toString(), viewLink.toString()});
        }
        if ((collectionViewLink = this._collectedViewLinks.get(link)) != null) {
            if (collectionViewLink.equals(viewLink)) {
                LOG.fine("Link already added not adding it again");
                return;
            }
            throw new IllegalArgumentException("Cannot readd a link (collection or plain) with a different view");
        }
        this._collectedViewLinks.put(link, viewLink);
        for (LinkID linkID : viewLink.getCollection()) {
            this._modelLinkToCollectionLink.put(linkID, link);
        }
    }

    void removeCollectedViewLink(LinkID link) {
        ViewLink vl = this._collectedViewLinks.remove(link);
        if (vl != null) {
            for (LinkID linkId : vl.getCollection()) {
                this._modelLinkToCollectionLink.remove(linkId);
            }
        }
    }

    void removeCollectedViewLinks(Collection<LinkID> links) {
        for (LinkID link : links) {
            this.removeCollectedViewLink(link);
        }
    }

    boolean isEntityCollected(EntityID modelEntity) {
        return this._modelEntityToCollectionEntity.containsKey(modelEntity);
    }

    EntityID getCollectionEntity(EntityID modelEntity) {
        return this._modelEntityToCollectionEntity.get(modelEntity);
    }

    public void addToCollectedViewEntities(EntityID entity, ViewEntity viewEntity) {
        ViewEntity collectionViewEntity;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Added entity {0} -> {1}", new Object[]{entity.toString(), viewEntity.toString()});
        }
        if ((collectionViewEntity = this._collectedViewEntities.get(entity)) != null) {
            if (collectionViewEntity.equals(viewEntity)) {
                LOG.fine("Entity already added not adding it again");
                return;
            }
            throw new IllegalArgumentException("Cannot read an entity (collection or plain) with a different view");
        }
        this._collectedViewEntities.put(entity, viewEntity);
        for (EntityID entityID : viewEntity.getCollection()) {
            this._modelEntityToCollectionEntity.put(entityID, entity);
        }
        if (viewEntity.isCollection()) {
            ViewEntity ve = this._viewEntities.get(entity);
            if (ve != null) {
                Set<EntityID> entitiesBefore = ve.getCollection();
                Set<EntityID> entitiesAfter = viewEntity.getCollection();
                HashSet<EntityID> commonEntities = new HashSet<EntityID>(entitiesBefore);
                commonEntities.retainAll(entitiesAfter);
                int beforeCount = entitiesBefore.size();
                int afterCount = entitiesAfter.size();
                int commonCount = commonEntities.size();
                if (beforeCount != afterCount || beforeCount != commonCount) {
                    int added = afterCount - commonCount;
                    int removed = beforeCount - commonCount;
                    int total = afterCount;
                    this.markEntityAsUpdated(entity, added, removed, total);
                }
            } else {
                Set<EntityID> entitiesAfter = viewEntity.getCollection();
                int afterCount = entitiesAfter.size();
                this.markEntityAsUpdated(entity, afterCount, 0, afterCount);
            }
        }
    }

    void removeCollectedViewEntity(EntityID entity) {
        this._viewMods.getCollectionMods().remove(entity);
        ViewEntity ve = this._collectedViewEntities.remove(entity);
        if (ve != null) {
            for (EntityID entityID : ve.getCollection()) {
                this._modelEntityToCollectionEntity.remove(entityID);
            }
        }
    }

    void removeCollectedViewEntities(Collection<EntityID> entities) {
        for (EntityID entity : entities) {
            this.removeCollectedViewEntity(entity);
        }
    }

    Map<LinkID, ViewLink> getCollectedViewLinks() {
        return Collections.unmodifiableMap(this._collectedViewLinks);
    }

    Map<EntityID, ViewEntity> getCollectedViewEntities() {
        return Collections.unmodifiableMap(this._collectedViewEntities);
    }

    public boolean collectedViewEntitiesContains(EntityID viewEntity) {
        return this._collectedViewEntities.containsKey(viewEntity);
    }

    public boolean collectedViewLinksContains(LinkID viewLink) {
        return this._collectedViewLinks.containsKey(viewLink);
    }

    private void removeEntities(Map<EntityID, EntityID> modelEntityToViewEntity, Map<EntityID, ViewEntity> toRemove) {
        Set<EntityID> keySet = modelEntityToViewEntity.keySet();
        for (Map.Entry<EntityID, ViewEntity> entry : toRemove.entrySet()) {
            EntityID key = entry.getKey();
            ViewEntity value = entry.getValue();
            if (value.isCollection()) {
                keySet.removeAll(value.getCollection());
                continue;
            }
            keySet.remove(key);
        }
    }

    private void addEntities(Map<EntityID, EntityID> modelEntityToViewEntity, Map<EntityID, ViewEntity> toAdd) {
        for (Map.Entry<EntityID, ViewEntity> entry : toAdd.entrySet()) {
            EntityID key = entry.getKey();
            ViewEntity value = entry.getValue();
            if (value.isCollection()) {
                for (EntityID entityID : value.getCollection()) {
                    modelEntityToViewEntity.put(entityID, key);
                }
                continue;
            }
            modelEntityToViewEntity.put(key, key);
        }
    }

    private void removeLinks(Map<LinkID, LinkID> modelLinkToViewLink, Map<LinkID, ViewLink> toRemove) {
        Set<LinkID> keySet = modelLinkToViewLink.keySet();
        for (Map.Entry<LinkID, ViewLink> entry : toRemove.entrySet()) {
            LinkID key = entry.getKey();
            ViewLink value = entry.getValue();
            if (value.isCollection()) {
                keySet.removeAll(value.getCollection());
                continue;
            }
            keySet.remove(key);
        }
    }

    private void addLinks(Map<LinkID, LinkID> modelLinkToViewLink, Map<LinkID, ViewLink> toAdd) {
        for (Map.Entry<LinkID, ViewLink> entry : toAdd.entrySet()) {
            LinkID key = entry.getKey();
            ViewLink value = entry.getValue();
            if (value.isCollection()) {
                for (LinkID linkID : value.getCollection()) {
                    modelLinkToViewLink.put(linkID, key);
                }
                continue;
            }
            modelLinkToViewLink.put(key, key);
        }
    }

    public void updateCollections(Map<EntityID, ViewEntity> viewEntities, Map<LinkID, ViewLink> viewLinks, Map<EntityID, ViewEntity> viewEntitiesSnapShot, Map<LinkID, ViewLink> viewLinksSnapShot, Map<EntityID, EntityID> modelEntityToViewEntity, Map<LinkID, LinkID> modelLinkToViewLink, Set<EntityID> viewEntitiesWithoutLinks) {
        viewEntities.keySet().removeAll(viewEntitiesSnapShot.keySet());
        viewLinks.keySet().removeAll(viewLinksSnapShot.keySet());
        viewEntities.putAll(this._collectedViewEntities);
        viewLinks.putAll(this._collectedViewLinks);
        this.removeEntities(modelEntityToViewEntity, viewEntitiesSnapShot);
        this.addEntities(modelEntityToViewEntity, this._collectedViewEntities);
        this.removeLinks(modelLinkToViewLink, viewLinksSnapShot);
        this.addLinks(modelLinkToViewLink, this._collectedViewLinks);
        viewEntitiesWithoutLinks.removeAll(viewEntitiesSnapShot.keySet());
        for (Map.Entry<EntityID, ViewEntity> entry : this._collectedViewEntities.entrySet()) {
            EntityID possibleEntityWithoutLinks = entry.getKey();
            ViewEntity value = entry.getValue();
            if (value.getAllLinks().hasViewOrModelLinks()) continue;
            viewEntitiesWithoutLinks.add(possibleEntityWithoutLinks);
        }
    }

    public void updateViewMods(Map<EntityID, ViewEntity> viewEntitiesSnapShot, Map<LinkID, ViewLink> viewLinksSnapShot) {
        for (EntityID entNew : this._collectedViewEntities.keySet()) {
            if (viewEntitiesSnapShot.containsKey(entNew)) continue;
            this.addAddedEntityToViewMods(entNew);
        }
        for (EntityID entOld : viewEntitiesSnapShot.keySet()) {
            if (this._collectedViewEntities.containsKey(entOld)) continue;
            this.addRemovedEntityToViewMods(entOld);
        }
        for (LinkID lnkNew : this._collectedViewLinks.keySet()) {
            if (viewLinksSnapShot.containsKey(lnkNew)) continue;
            this.addAddedLinkToViewMods(lnkNew);
        }
        for (LinkID lnkOld : viewLinksSnapShot.keySet()) {
            if (this._collectedViewLinks.containsKey(lnkOld)) continue;
            this.addRemovedLinkToViewMods(lnkOld, viewLinksSnapShot.get(lnkOld).getEntities());
        }
    }

    public int getMinEntityCountForCollection(String entityType) {
        return this._minEntityCountForCollection;
    }

    public boolean isRecollectingEntireGraph() {
        return this._recollectingEntireGraph;
    }
}

