/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.view;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultGraphModelViewMappings
implements GraphModelViewMappings {
    private final GraphStructureReader _modelStructureReader;

    public DefaultGraphModelViewMappings(GraphStructureReader modelStructureReader) {
        this._modelStructureReader = modelStructureReader;
    }

    protected GraphStructureReader getModelStructureReader() {
        return this._modelStructureReader;
    }

    @Override
    public Map<EntityID, Set<EntityID>> getModelEntitiesMap(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashMap<EntityID, Set<EntityID>> modelEntities = new HashMap<EntityID, Set<EntityID>>();
        for (EntityID entityID : entityIDs) {
            modelEntities.put(entityID, this.getModelEntities(entityID));
        }
        return modelEntities;
    }

    @Override
    public Set<EntityID> getModelEntities(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashSet<EntityID> modelEntities = new HashSet<EntityID>();
        for (EntityID entityID : entityIDs) {
            modelEntities.addAll(this.getModelEntities(entityID));
        }
        return modelEntities;
    }

    @Override
    public Set<EntityID> getModelEntities(EntityID entityID) throws GraphStoreException {
        return Collections.singleton(entityID);
    }

    @Override
    public Map<LinkID, Set<LinkID>> getModelLinksMap(Collection<LinkID> linkIDs) throws GraphStoreException {
        HashMap<LinkID, Set<LinkID>> modelLinks = new HashMap<LinkID, Set<LinkID>>();
        for (LinkID linkID : linkIDs) {
            modelLinks.put(linkID, this.getModelLinks(linkID));
        }
        return modelLinks;
    }

    @Override
    public Set<LinkID> getModelLinks(Collection<LinkID> linkIDs) throws GraphStoreException {
        HashSet<LinkID> modelLinks = new HashSet<LinkID>();
        for (LinkID linkID : linkIDs) {
            modelLinks.addAll(this.getModelLinks(linkID));
        }
        return modelLinks;
    }

    @Override
    public Set<LinkID> getModelLinks(LinkID linkID) throws GraphStoreException {
        return Collections.singleton(linkID);
    }

    @Override
    public EntityID getViewEntity(EntityID entityID) throws GraphStoreException {
        return entityID;
    }

    @Override
    public LinkID getViewLink(LinkID linkID) throws GraphStoreException {
        return linkID;
    }

    @Override
    public boolean isModelAndViewEntity(EntityID entityID) throws GraphStoreException {
        return this._modelStructureReader.exists(entityID);
    }

    @Override
    public boolean isModelEntity(EntityID entityID) throws GraphStoreException {
        return this._modelStructureReader.exists(entityID);
    }

    @Override
    public boolean isOnlyViewEntity(EntityID entityID) throws GraphStoreException {
        return false;
    }

    @Override
    public boolean isOnlyModelEntity(EntityID entityID) throws GraphStoreException {
        return false;
    }

    @Override
    public boolean isViewEntity(EntityID entityID) throws GraphStoreException {
        return this._modelStructureReader.exists(entityID);
    }

    @Override
    public boolean isModelAndViewLink(LinkID linkID) throws GraphStoreException {
        return this._modelStructureReader.exists(linkID);
    }

    @Override
    public boolean isModelLink(LinkID linkID) throws GraphStoreException {
        return this._modelStructureReader.exists(linkID);
    }

    @Override
    public boolean isViewLink(LinkID linkID) throws GraphStoreException {
        return this._modelStructureReader.exists(linkID);
    }

    @Override
    public boolean isOnlyViewLink(LinkID linkID) throws GraphStoreException {
        return false;
    }

    @Override
    public boolean isOnlyModelLink(LinkID linkID) throws GraphStoreException {
        return false;
    }
}

