/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.objects.JSCopyableObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class JSOrdinaryObject
extends JSNonProxyObject
implements JSCopyableObject {
    protected JSOrdinaryObject(Shape shape) {
        super(shape);
    }

    public static JSOrdinaryObject create(Shape shape) {
        Class layout = shape.getLayoutClass();
        if (layout == DefaultLayout.class) {
            return new DefaultLayout(shape);
        }
        if (layout == InternalFieldLayout.class) {
            return new InternalFieldLayout(shape);
        }
        return new BareLayout(shape);
    }

    @Override
    public String getClassName() {
        return "Object";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getValue(long index) {
        return this.getValue(String.valueOf(index));
    }

    @Override
    public final boolean hasOnlyShapeProperties() {
        return true;
    }

    public static final class InternalFieldLayout
    extends JSOrdinaryObject {
        @DynamicObject.DynamicField
        Object o0;
        @DynamicObject.DynamicField
        Object o1;
        @DynamicObject.DynamicField
        Object o2;
        private static final long[] EMPTY_LONG_ARRAY = new long[0];
        private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
        private long[] internalPointerFields = EMPTY_LONG_ARRAY;
        private Object[] internalObjectFields = EMPTY_OBJECT_ARRAY;

        protected InternalFieldLayout(Shape shape) {
            super(shape);
        }

        @Override
        protected JSObject copyWithoutProperties(Shape shape) {
            return new InternalFieldLayout(shape);
        }

        public long getInternalFieldPointer(int index) {
            return this.internalPointerFields[index];
        }

        public void setInternalFieldPointer(int index, long value) {
            this.internalPointerFields[index] = value;
        }

        public Object getInternalFieldObject(int index) {
            if (index >= this.internalObjectFields.length) {
                return null;
            }
            return this.internalObjectFields[index];
        }

        public void setInternalFieldObject(int index, Object value) {
            if (this.internalObjectFields.length == 0) {
                this.internalObjectFields = new Object[this.getInternalFieldCount()];
            }
            this.internalObjectFields[index] = value;
        }

        public int getInternalFieldCount() {
            return this.internalPointerFields.length;
        }

        public void setInternalFieldCount(int internalFieldCount) {
            assert (this.getInternalFieldCount() == 0);
            this.internalPointerFields = new long[internalFieldCount];
        }
    }

    public static final class DefaultLayout
    extends JSOrdinaryObject {
        @DynamicObject.DynamicField
        Object o0;
        @DynamicObject.DynamicField
        Object o1;
        @DynamicObject.DynamicField
        Object o2;
        @DynamicObject.DynamicField
        Object o3;
        @DynamicObject.DynamicField
        long p0;
        @DynamicObject.DynamicField
        long p1;
        @DynamicObject.DynamicField
        long p2;

        protected DefaultLayout(Shape shape) {
            super(shape);
        }

        @Override
        protected JSObject copyWithoutProperties(Shape shape) {
            return new DefaultLayout(shape);
        }
    }

    public static final class BareLayout
    extends JSOrdinaryObject {
        protected BareLayout(Shape shape) {
            super(shape);
        }

        @Override
        protected JSObject copyWithoutProperties(Shape shape) {
            return new BareLayout(shape);
        }
    }
}

