/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.client.Cookie;
import org.xlightweb.client.HttpClientConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InMemoryCookieStore
implements Closeable {
    private static final Logger LOG = Logger.getLogger(InMemoryCookieStore.class.getName());
    private static final long CLEANING_PERIOD_MILLIS = 30000L;
    private Cleaner cleaner;
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final HashMap<String, List<Cookie>> domainIndex = new HashMap();
    private final HashMap<URI, List<Cookie>> uriIndex = new HashMap();
    private final Object guard = new Object();

    public InMemoryCookieStore() {
        this.cleaner = new Cleaner(this);
        HttpClientConnection.schedule(this.cleaner, 30000L, 30000L);
    }

    @Override
    public void close() throws IOException {
        this.cookies.clear();
        this.domainIndex.clear();
        this.uriIndex.clear();
        if (this.cleaner != null) {
            this.cleaner.close();
        }
        this.cleaner = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(URI uri, Cookie cookie) {
        Object object = this.guard;
        synchronized (object) {
            this.cookies.remove(cookie);
            if (cookie.getMaxAge() != 0L) {
                this.cookies.add(cookie);
                if (cookie.getDomain() != null) {
                    this.addIndex(this.domainIndex, cookie.getDomain(), cookie);
                }
                this.addIndex(this.uriIndex, this.getEffectiveURI(uri), cookie);
            }
        }
    }

    private <T> void addIndex(Map<T, List<Cookie>> indexStore, T index, Cookie cookie) {
        if (index != null) {
            List<Cookie> cookies = indexStore.get(index);
            if (cookies != null) {
                cookies.remove(cookie);
                cookies.add(cookie);
            } else {
                cookies = new ArrayList<Cookie>();
                cookies.add(cookie);
                indexStore.put(index, cookies);
            }
        }
    }

    private URI getEffectiveURI(URI uri) {
        URI effectiveURI = null;
        try {
            effectiveURI = new URI("http", uri.getHost(), null, null, null);
        }
        catch (URISyntaxException ignored) {
            effectiveURI = uri;
        }
        return effectiveURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cookie> get(URI uri) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        boolean secureLink = "https".equalsIgnoreCase(uri.getScheme());
        Object object = this.guard;
        synchronized (object) {
            this.fetchFromDomainIndex(cookies, uri.getHost(), secureLink);
            this.fetchFromUriIndex(cookies, this.getEffectiveURI(uri), secureLink);
        }
        return cookies;
    }

    private void fetchFromDomainIndex(List<Cookie> resultList, String host, boolean secureLink) {
        for (Map.Entry<String, List<Cookie>> entry : this.domainIndex.entrySet()) {
            String domain = entry.getKey();
            List<Cookie> cookieList = entry.getValue();
            for (Cookie cookie : cookieList) {
                if ((cookie.getVersion() != 0 || !this.netscapeDomainMatches(domain, host)) && (cookie.getVersion() != 1 || !Cookie.matches(domain, host)) || this.cookies.indexOf(cookie) == -1 || cookie.hasExpired() || !secureLink && cookie.getSecure() || resultList.contains(cookie)) continue;
                resultList.add(cookie);
            }
        }
    }

    private void fetchFromUriIndex(List<Cookie> resultList, Comparable<URI> comparator, boolean secureLink) {
        for (URI uri : this.uriIndex.keySet()) {
            List<Cookie> indexedCookies;
            if (comparator.compareTo(uri) != 0 || (indexedCookies = this.uriIndex.get(uri)) == null) continue;
            for (Cookie httpCookie : indexedCookies) {
                if (this.cookies.indexOf(httpCookie) == -1) continue;
                if (!httpCookie.hasExpired()) {
                    if (!secureLink && httpCookie.getSecure() || resultList.contains(httpCookie)) continue;
                    resultList.add(httpCookie);
                    continue;
                }
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("cookie " + httpCookie + " is expired");
            }
        }
    }

    private boolean netscapeDomainMatches(String domain, String host) {
        if (domain == null || host == null) {
            return false;
        }
        boolean isLocalDomain = ".local".equalsIgnoreCase(domain);
        int embeddedDotInDomain = domain.indexOf(46);
        if (embeddedDotInDomain == 0) {
            embeddedDotInDomain = domain.indexOf(46, 1);
        }
        if (!(isLocalDomain || embeddedDotInDomain != -1 && embeddedDotInDomain != domain.length() - 1)) {
            return false;
        }
        if (host.indexOf(46) == -1 && isLocalDomain) {
            return true;
        }
        int sizeDiff = host.length() - domain.length();
        if (sizeDiff == 0) {
            return host.equalsIgnoreCase(domain);
        }
        if (sizeDiff > 0) {
            String s = host.substring(sizeDiff);
            return s.equalsIgnoreCase(domain);
        }
        if (sizeDiff == -1) {
            return domain.charAt(0) == '.' && host.equalsIgnoreCase(domain.substring(1));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void clean() {
        try {
            Object object;
            HashMap domainIndexCopy = null;
            HashMap uriIndexCopy = null;
            Object object2 = this.guard;
            synchronized (object2) {
                domainIndexCopy = (HashMap)this.domainIndex.clone();
                uriIndexCopy = (HashMap)this.uriIndex.clone();
            }
            for (Map.Entry entry : domainIndexCopy.entrySet()) {
                for (Cookie cookie : (List)entry.getValue()) {
                    if (!cookie.hasExpired()) continue;
                    LOG.fine("cookie " + cookie + " has been expired. Deleting it");
                    object = this.guard;
                    synchronized (object) {
                        this.domainIndex.get(entry.getKey()).remove(cookie);
                        if (this.domainIndex.get(entry.getKey()).isEmpty()) {
                            this.domainIndex.remove(entry.getKey());
                        }
                    }
                }
            }
            for (Map.Entry entry : uriIndexCopy.entrySet()) {
                for (Cookie cookie : (List)entry.getValue()) {
                    if (!cookie.hasExpired()) continue;
                    LOG.fine("cookie " + cookie + " has been expired. Deleting it");
                    object = this.guard;
                    synchronized (object) {
                        this.uriIndex.get(entry.getKey()).remove(cookie);
                        if (this.uriIndex.get(entry.getKey()).isEmpty()) {
                            this.uriIndex.remove(entry.getKey());
                        }
                    }
                }
                continue;
                return;
            }
        }
        catch (Throwable e) {
            if (!LOG.isLoggable(Level.FINE)) return;
            LOG.fine("error occured by cleaning store " + e.toString());
        }
    }

    private static final class Cleaner
    extends TimerTask
    implements Closeable {
        private WeakReference<InMemoryCookieStore> inMemoryCookieStoreRef;

        public Cleaner(InMemoryCookieStore inMemoryCookieStore) {
            this.inMemoryCookieStoreRef = new WeakReference<InMemoryCookieStore>(inMemoryCookieStore);
        }

        public void run() {
            WeakReference<InMemoryCookieStore> ref = this.inMemoryCookieStoreRef;
            if (ref != null) {
                InMemoryCookieStore inMemoryCookieStore = (InMemoryCookieStore)ref.get();
                if (inMemoryCookieStore == null) {
                    this.close();
                } else {
                    inMemoryCookieStore.clean();
                }
            }
        }

        public void close() {
            this.cancel();
            this.inMemoryCookieStoreRef = null;
        }
    }
}

