/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.analytics.api;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class AnalyticsEvent {
    private final String type;
    private final long timestamp;
    private final UUID traceId;
    private final Map<String, Object> properties;

    public AnalyticsEvent(String type) {
        this.type = type;
        this.timestamp = Instant.now().toEpochMilli();
        this.traceId = UUID.randomUUID();
        this.properties = new HashMap<String, Object>();
        this.properties.put("source", "graph-desktop");
    }

    public AnalyticsEvent(String type, Property ... properties) {
        this(type);
        if (properties != null) {
            for (Property p : properties) {
                this.properties.put(p.key, p.value);
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public UUID getTraceId() {
        return this.traceId;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public static class Property {
        private final String key;
        private final Object value;

        private Property(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public static Property of(String key, Object value) {
            return new Property(key, value);
        }
    }
}

