/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.ProductRestrictionsErrorDisplayer;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.BrowseToUrl;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class DefaultProductRestrictionsErrorDisplayer
extends ProductRestrictionsErrorDisplayer {
    AtomicBoolean showDialog = new AtomicBoolean(false);
    private static final String PRODUCT_RESTRICTION_TITLE = "Capability Not Allowed";

    public void show(String message) {
        if (this.showDialog.get()) {
            return;
        }
        Runnable asyncDialog = () -> this.asyncDialog(PRODUCT_RESTRICTION_TITLE, message);
        SwingUtilities.invokeLater(asyncDialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncDialog(String title, String message) {
        LicenseManager licMan = LicenseManager.A();
        A licenseMode = licMan.A(false);
        boolean licensed = licenseMode.B() || licenseMode.W();
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
        nd.setMessageType(1);
        nd.setTitle(title);
        String upgradeOption = licensed ? "Upgrade" : "Buy";
        String cancelOption = "Cancel";
        Object[] options = new String[]{upgradeOption, cancelOption};
        nd.setOptions(options);
        try {
            this.showDialog.set(true);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (upgradeOption.equals(result)) {
                String licenseKey;
                String string = licenseKey = licenseMode.B() ? licMan.C() : null;
                if (licensed) {
                    BrowseToUrl.upgradePlan(licenseKey);
                } else {
                    BrowseToUrl.buyPlan(licenseKey);
                }
            }
        }
        finally {
            this.showDialog.set(false);
        }
    }
}

