/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui;

import com.paterva.maltego.crypto.MaltegoClientCryptographer;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.monitor.B;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.Version;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;

public class BrowseToUrl {
    public static void compareProducts(String licenseKey) {
        BrowseToUrl.go(MaltegoUrl.getCurrent().getGotoProducts(), null, licenseKey, false);
    }

    public static void buyPlan(String licenseKey) {
        BrowseToUrl.go(MaltegoUrl.getCurrent().getGotoPurchase(), "GatewayMaltegoID", licenseKey, false);
    }

    public static void upgradePlan(String licenseKey) {
        BrowseToUrl.go(MaltegoUrl.getCurrent().getGotoUpgrade(), "GatewayMaltegoID", licenseKey, true);
    }

    public static void renew(String licenseKey) {
        BrowseToUrl.go(MaltegoUrl.getCurrent().getGotoRenew(), null, licenseKey, true);
    }

    public static void go(String urlStr, String product, String licenseKey, boolean startLicensePolling) {
        try {
            URL url;
            if (startLicensePolling) {
                B.F();
            }
            StringBuilder sb = new StringBuilder(urlStr);
            String licenseEncrypted = null;
            if (!StringUtilities.isNullOrEmpty((String)licenseKey)) {
                long time = System.currentTimeMillis();
                String licensePart = licenseKey + "#" + time;
                licenseEncrypted = MaltegoClientCryptographer.getInstance().encryptAsymmetricToString(licensePart);
            }
            Version ver = Version.getCurrent();
            LicenseManager licMan = LicenseManager.A();
            A licenseMode = licMan.A(false);
            String branding = licMan.B();
            if (licenseMode.W()) {
                String pricingPlan = MaltegoIdProductRestrictions.getProductPlanPricingPlan((A)licenseMode);
                String productPlanId = MaltegoIdProductRestrictions.getProductPlanTextId((A)licenseMode);
                ver.appendToUrl(sb, branding, pricingPlan, productPlanId);
            } else {
                ver.appendToUrl(sb, branding);
            }
            String osName = System.getProperty("os.name");
            String java = System.getProperty("java.version");
            sb.append("&os=").append(BrowseToUrl.encode(osName));
            sb.append("&java=").append(BrowseToUrl.encode(java));
            if (!StringUtilities.isNullOrEmpty((String)product)) {
                sb.append("&product=").append(BrowseToUrl.encode(product));
            }
            if (!StringUtilities.isNullOrEmpty((String)licenseEncrypted)) {
                sb.append("&license=").append(BrowseToUrl.encode(licenseEncrypted));
            }
            if (!FileUtilities.isRemoteFileURL((URL)(url = new URL(sb.toString())))) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void go(String urlStr) {
        try {
            URL url = new URL(urlStr);
            if (!FileUtilities.isRemoteFileURL((URL)url)) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static String encode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, StandardCharsets.UTF_8.name());
    }
}

