/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.rest;

import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.certificates.rest.CountingOutputStream;
import com.paterva.maltego.certificates.rest.MultipartFile;
import com.paterva.maltego.certificates.rest.MultipartFileContent;
import com.paterva.maltego.certificates.rest.MultipartPart;
import com.paterva.maltego.certificates.rest.MultipartText;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;

public class MultipartWriter
implements AutoCloseable {
    private static final String CRLF = "\r\n";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final long CRLF_BYTES = "\r\n".getBytes(CHARSET).length;
    private static final String BOUNDARY = UUID.randomUUID().toString();
    private static final String MULTIPART_END = "--" + BOUNDARY + "--" + "\r\n";
    private static final long MULTIPART_END_BYTES = MULTIPART_END.getBytes(CHARSET).length;
    private final List<MultipartPart> parts = new ArrayList<MultipartPart>();
    private final HttpAgent httpAgent;
    private OutputStream output;
    private PrintWriter writer;
    private Consumer<Long> bytesWritten;

    public MultipartWriter(URL url) throws IOException {
        this.httpAgent = new HttpAgent(url);
    }

    public HttpAgent getHttpAgent() {
        return this.httpAgent;
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public void queueGraph(String partName, String filename, String json) {
        String header = this.createPartHeader(partName, filename, "application/json", json.length());
        this.parts.add(new MultipartText(header, json, CHARSET));
    }

    public void queueJson(String partName, String json) {
        String header = this.createPartHeader(partName, null, "application/json");
        this.parts.add(new MultipartText(header, json, CHARSET));
    }

    public void queueText(String partName, String text) {
        String header = this.createPartHeader(partName, null, "text/plain; charset=" + CHARSET);
        this.parts.add(new MultipartText(header, text, CHARSET));
    }

    public void queueFileContent(String partName, String partFilename, byte[] content) {
        String contentType = URLConnection.guessContentTypeFromName(partFilename);
        String header = this.createPartHeader(partName, partFilename, contentType);
        this.parts.add(new MultipartFileContent(header, content));
    }

    public void queueFile(String partName, String partFilename, Path file) {
        String contentType = URLConnection.guessContentTypeFromName(partFilename);
        String header = this.createPartHeader(partName, partFilename, contentType);
        this.parts.add(new MultipartFile(header, file));
    }

    public long getTotalBytesToWrite() {
        long bytes = this.parts.stream().mapToLong(this::getBytesToWrite).sum();
        return bytes += MULTIPART_END_BYTES;
    }

    public void setBytesWrittenCallback(Consumer<Long> bytesWrittenCallback) {
        this.bytesWritten = bytesWrittenCallback;
    }

    public HttpAgent send(boolean post) throws IOException {
        String contentType = "multipart/form-data; boundary=" + BOUNDARY;
        this.output = post ? this.httpAgent.doPost(contentType) : this.httpAgent.doPut(contentType);
        if (this.bytesWritten != null) {
            this.output = new CountingOutputStream(this.output, this.bytesWritten);
        }
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.output, CHARSET), true);
        this.parts.forEach(this::write);
        this.writer.append(MULTIPART_END);
        this.writer.flush();
        this.writer.close();
        return this.httpAgent;
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.output != null) {
            this.output.close();
        }
        this.httpAgent.disconnect();
    }

    private String createPartHeader(String name, String filename, String contentType) {
        return this.createPartHeader(name, filename, contentType, -1);
    }

    private String createPartHeader(String name, String filename, String contentType, int contentLength) {
        StringBuilder sb = new StringBuilder();
        sb.append("--").append(BOUNDARY).append(CRLF);
        sb.append("Content-Disposition: form-data; name=\"").append(name);
        if (filename != null) {
            sb.append("\"; filename=\"").append(filename);
        }
        sb.append("\"").append(CRLF);
        sb.append("Content-Type: ").append(contentType).append(CRLF);
        if (contentLength >= 0) {
            sb.append("Content-Length: ").append(contentLength).append(CRLF);
        }
        return sb.toString();
    }

    private void write(MultipartPart part) {
        String header = part.getHeader();
        this.writer.append(header);
        this.writer.append(CRLF).flush();
        if (part instanceof MultipartText) {
            this.writeText((MultipartText)part);
        } else if (part instanceof MultipartFile) {
            this.writeFile((MultipartFile)part);
        } else if (part instanceof MultipartFileContent) {
            this.writeFileContent((MultipartFileContent)part);
        } else {
            throw new RuntimeException("Unknown multi-part type: " + part.getClass().getSimpleName());
        }
        this.writer.append(CRLF).flush();
    }

    private void writeText(MultipartText textPart) {
        String text = textPart.getText();
        this.writer.append(text);
    }

    private void writeFile(MultipartFile filePart) {
        try {
            Path file = filePart.getFile();
            Files.copy(file, this.output);
            this.output.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeFileContent(MultipartFileContent fileContentPart) {
        try {
            this.output.write(fileContentPart.getContent());
            this.output.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private long getBytesToWrite(MultipartPart part) {
        long bytes = 2L * CRLF_BYTES;
        String header = part.getHeader();
        bytes += (long)header.getBytes(CHARSET).length;
        return bytes += part.getSize();
    }
}

