/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.sets;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.util.ListSet;
import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;

public class AddToSetAction
extends NodeAction
implements Presenter.Popup {
    Node[] _selectedNodes = new Node[0];

    protected void performAction(Node[] nodes) {
    }

    protected boolean enable(Node[] nodes) {
        this._selectedNodes = nodes;
        return nodes.length > 0;
    }

    public String getName() {
        return "Add to set";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu menu = new JMenu(this.getName());
        menu.setEnabled(this.enable(this._selectedNodes));
        AddToSetAction.populateSets(menu, this._selectedNodes);
        return menu;
    }

    private static void populateSets(JMenu menu, Node[] nodes) {
        Set<TransformSet> sets = AddToSetAction.getSets(nodes);
        for (TransformSet set : sets) {
            JMenuItem setItem = new JMenuItem(new SetAction(set, nodes));
            menu.add(setItem);
        }
    }

    private static Set<TransformSet> getSets(Node[] nodes) {
        ListSet transforms = new ListSet();
        for (Node node : nodes) {
            TransformDefinition transform = (TransformDefinition)node.getLookup().lookup(TransformDefinition.class);
            if (transform == null) continue;
            transforms.add(transform);
        }
        Set allSets = TransformSetRepository.getDefault().allSets();
        TreeSet<TransformSet> resultSets = new TreeSet<TransformSet>();
        for (TransformSet set : allSets) {
            boolean addSet = true;
            for (TransformDefinition transform : transforms) {
                if (!set.getAllTransforms().contains(transform.getName())) continue;
                addSet = false;
                break;
            }
            if (!addSet) continue;
            resultSets.add(set);
        }
        return resultSets;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static class SetAction
    extends AbstractAction {
        private TransformSet _set;
        private Node[] _nodes;

        public SetAction(TransformSet set, Node[] nodes) {
            super(set.getName());
            this._set = set;
            this._nodes = nodes;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Node node : this._nodes) {
                TransformDefinition transform = (TransformDefinition)node.getLookup().lookup(TransformDefinition.class);
                if (transform == null) continue;
                this._set.addTransform(transform.getName());
            }
        }
    }
}

