/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelException;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AuthenticationFlowResolver {
    public static AuthenticationFlowModel resolveBrowserFlow(AuthenticationSessionModel authSession) {
        AuthenticationFlowModel flow = null;
        ClientModel client = authSession.getClient();
        String clientFlow = client.getAuthenticationFlowBindingOverride("browser");
        if (clientFlow != null) {
            flow = authSession.getRealm().getAuthenticationFlowById(clientFlow);
            if (flow == null) {
                throw new ModelException("Client " + client.getClientId() + " has browser flow override, but this flow does not exist");
            }
            return flow;
        }
        return authSession.getRealm().getBrowserFlow();
    }

    public static AuthenticationFlowModel resolveDirectGrantFlow(AuthenticationSessionModel authSession) {
        AuthenticationFlowModel flow = null;
        ClientModel client = authSession.getClient();
        String clientFlow = client.getAuthenticationFlowBindingOverride("direct_grant");
        if (clientFlow != null) {
            flow = authSession.getRealm().getAuthenticationFlowById(clientFlow);
            if (flow == null) {
                throw new ModelException("Client " + client.getClientId() + " has direct grant flow override, but this flow does not exist");
            }
            return flow;
        }
        return authSession.getRealm().getDirectGrantFlow();
    }
}

