---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, polices bitmap, polices matricielles
---

# Comment acquérir des polices matricielles ?

Alors que le CTAN était encore jeune, la plupart des gens commençaient à utiliser TeX 
avec des imprimantes laser de 300 points par pouce (ppp). 
De fait, des jeux de polices matricielles (aussi dites *bitmap*) *Computer Modern* 
pour cette résolution sont disponibles sur CTAN. Il existe d'ailleurs des jeux distincts 
pour les imprimantes à écriture noire et à écriture blanche, 
ainsi que des jeux à 120 ppp et 240 ppp.

Il y a eu des demandes régulières pour que le CTAN propose une gamme plus large de résolutions, 
mais elles ont été rejetées pour deux raisons :

- la nécessité de décider pour quelles imprimantes générer des polices de caractères. 
  L'approche générale adoptée pour les imprimantes 300 dpi était (plus ou moins) 
  justifiée à l'époque, compte tenu de la prédominance de la prédominance 
  de certains "moteurs" d'imprimantes. Mais aujourd'hui, de telles suppositions ne
  sont plus réalistes.

- compte tenu de ce qui précède, il a été pratiquement impossible de justifier 
  l'espace qu'occuperait un vaste ensemble de polices matricielles.

Heureusement, la technologie de distribution de (La)TeX a mis fin à ces arguments : 
la plupart (sinon toutes) des distributions actuelles génèrent des polices matricielles 
en fonction des besoins, et les mettent en cache pour une réutilisation ultérieure. 
L'utilisateur déterminé à ce que toutes les polices matricielles 
soient créées une fois pour toutes, peut être aidé par des scripts tels que `allcm` 
(distribué au moins avec TeX Live) ou consulter la question 
"[](/5_fichiers/formats/fontes/utiliser_metafont)".

Si vos travaux sont destinés à un appareil compatible PostScript, ou à être convertie en PDF, 
vous devriez passer à l'utilisation des versions Type 1 des polices *Computer Modern*. 
Deux jeux gratuits sont disponibles : le plus ancien (<ctanpkg:bakoma>) 
est un peu moins bien produit que les polices `bluesky`, 
qui étaient à l'origine produites et vendues par des professionnels, 
mais qui ont ensuite été mises à la disposition du grand public par leurs créateurs, 
Y&Y et Bluesky Research, en association avec l'AMS et d'autres éditeurs scientifiques 
(elles sont aujourd'hui disponibles sous la licence Open Fonts du SIL). 
Les deux ensembles contiennent des gammes de polices légèrement différentes, 
mais il est conseillé d'utiliser l'ensemble `bluesky` sauf si <ctanpkg:bakoma> est, 
pour une raison ou une autre, absolument inévitable. Ces dernières années, 
plusieurs autres polices MetaFont ont été converties au format Type 1.
Il est désormais peu courant d'avoir à générer des polices matricielles à d'autres fins 
que la prévisualisation (voir la question 
"[](/5_fichiers/formats/fontes/previsualiser_des_fichiers_utilisant_des_fontes_t1)").

Des polices plus modernes peuvent être utilisées à la place de l'ensemble *Computer Modern*.
Les polices *[European Computer](/5_fichiers/formats/fontes/que_sont_les_fontes_ec)* 
et les polices *[Latin Modern](/5_fichiers/formats/fontes/utiliser_les_fontes_latin_modern)* 
sont toutes deux proches avec des gammes de glyphes plus étendues.


:::{sources}
[Acquiring bitmap fonts](faquk:FAQ-getbitmap)
:::