//--------------------------------------------------------------------------
// Copyright (C) 2025-2025 Cisco and/or its affiliates. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License Version 2 as published
// by the Free Software Foundation.  You may not use, modify or distribute
// this program under any other version of the GNU General Public License.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//--------------------------------------------------------------------------

// opcua_msg_service.h author Daniil Kolomiiets <dkolomii@cisco.com>

#ifndef OPCUA_MSG_SERVICE_H
#define OPCUA_MSG_SERVICE_H

// Node Service IDs obtained from
// github.com/OPCFoundation/UA-Nodeset/blob/UA-1.05.04-2024-12-01/Schema/NodeIds.csv
enum OpcuaMsgServiceType
{
    OPCUA_MSG_SERVICE_UNDEFINED = 0,
    OPCUA_MSG_SERVICE_DATA_TYPE_DEFINITION = 121,
    OPCUA_MSG_SERVICE_STRUCTURE_DEFINITION = 122,
    OPCUA_MSG_SERVICE_ENUM_DEFINITION = 123,
    OPCUA_MSG_SERVICE_DATA_SET_META_DATA_TYPE = 124,
    OPCUA_MSG_SERVICE_DATA_TYPE_DESCRIPTION = 125,
    OPCUA_MSG_SERVICE_STRUCTURE_DESCRIPTION = 126,
    OPCUA_MSG_SERVICE_ENUM_DESCRIPTION = 127,
    OPCUA_MSG_SERVICE_ROLE_PERMISSION_TYPE = 128,
    OPCUA_MSG_SERVICE_NODE = 260,
    OPCUA_MSG_SERVICE_OBJECT_NODE = 263,
    OPCUA_MSG_SERVICE_OBJECT_TYPE_NODE = 266,
    OPCUA_MSG_SERVICE_VARIABLE_NODE = 269,
    OPCUA_MSG_SERVICE_VARIABLE_TYPE_NODE = 272,
    OPCUA_MSG_SERVICE_REFERENCE_TYPE_NODE = 275,
    OPCUA_MSG_SERVICE_METHOD_NODE = 278,
    OPCUA_MSG_SERVICE_VIEW_NODE = 281,
    OPCUA_MSG_SERVICE_DATA_TYPE_NODE = 284,
    OPCUA_MSG_SERVICE_REFERENCE_NODE = 287,
    OPCUA_MSG_SERVICE_ARGUMENT = 298,
    OPCUA_MSG_SERVICE_STATUS_RESULT = 301,
    OPCUA_MSG_SERVICE_USER_TOKEN_POLICY = 306,
    OPCUA_MSG_SERVICE_APPLICATION_DESCRIPTION = 310,
    OPCUA_MSG_SERVICE_ENDPOINT_DESCRIPTION = 314,
    OPCUA_MSG_SERVICE_USER_IDENTITY_TOKEN = 318,
    OPCUA_MSG_SERVICE_ANONYMOUS_IDENTITY_TOKEN = 321,
    OPCUA_MSG_SERVICE_USER_NAME_IDENTITY_TOKEN = 324,
    OPCUA_MSG_SERVICE_X509_IDENTITY_TOKEN = 327,
    OPCUA_MSG_SERVICE_ENDPOINT_CONFIGURATION = 333,
    OPCUA_MSG_SERVICE_BUILD_INFO = 340,
    OPCUA_MSG_SERVICE_SIGNED_SOFTWARE_CERTIFICATE = 346,
    OPCUA_MSG_SERVICE_NODE_ATTRIBUTES = 351,
    OPCUA_MSG_SERVICE_OBJECT_ATTRIBUTES = 354,
    OPCUA_MSG_SERVICE_VARIABLE_ATTRIBUTES = 357,
    OPCUA_MSG_SERVICE_METHOD_ATTRIBUTES = 360,
    OPCUA_MSG_SERVICE_OBJECT_TYPE_ATTRIBUTES = 363,
    OPCUA_MSG_SERVICE_VARIABLE_TYPE_ATTRIBUTES = 366,
    OPCUA_MSG_SERVICE_REFERENCE_TYPE_ATTRIBUTES = 369,
    OPCUA_MSG_SERVICE_DATA_TYPE_ATTRIBUTES = 372,
    OPCUA_MSG_SERVICE_VIEW_ATTRIBUTES = 375,
    OPCUA_MSG_SERVICE_ADD_NODES_ITEM = 378,
    OPCUA_MSG_SERVICE_ADD_REFERENCES_ITEM = 381,
    OPCUA_MSG_SERVICE_DELETE_NODES_ITEM = 384,
    OPCUA_MSG_SERVICE_DELETE_REFERENCES_ITEM = 387,
    OPCUA_MSG_SERVICE_REQUEST_HEADER = 391,
    OPCUA_MSG_SERVICE_RESPONSE_HEADER = 394,
    OPCUA_MSG_SERVICE_SERVICE_FAULT = 397,
    OPCUA_MSG_SERVICE_FIND_SERVERS_REQUEST = 422,
    OPCUA_MSG_SERVICE_FIND_SERVERS_RESPONSE = 425,
    OPCUA_MSG_SERVICE_GET_ENDPOINTS_REQUEST = 428,
    OPCUA_MSG_SERVICE_GET_ENDPOINTS_RESPONSE = 431,
    OPCUA_MSG_SERVICE_REGISTERED_SERVER = 434,
    OPCUA_MSG_SERVICE_REGISTER_SERVER_REQUEST = 437,
    OPCUA_MSG_SERVICE_REGISTER_SERVER_RESPONSE = 440,
    OPCUA_MSG_SERVICE_CHANNEL_SECURITY_TOKEN = 443,
    OPCUA_MSG_SERVICE_OPEN_SECURE_CHANNEL_REQUEST = 446,
    OPCUA_MSG_SERVICE_OPEN_SECURE_CHANNEL_RESPONSE = 449,
    OPCUA_MSG_SERVICE_CLOSE_SECURE_CHANNEL_REQUEST = 452,
    OPCUA_MSG_SERVICE_CLOSE_SECURE_CHANNEL_RESPONSE = 455,
    OPCUA_MSG_SERVICE_SIGNATURE_DATA = 458,
    OPCUA_MSG_SERVICE_CREATE_SESSION_REQUEST = 461,
    OPCUA_MSG_SERVICE_CREATE_SESSION_RESPONSE = 464,
    OPCUA_MSG_SERVICE_ACTIVATE_SESSION_REQUEST = 467,
    OPCUA_MSG_SERVICE_ACTIVATE_SESSION_RESPONSE = 470,
    OPCUA_MSG_SERVICE_CLOSE_SESSION_REQUEST = 473,
    OPCUA_MSG_SERVICE_CLOSE_SESSION_RESPONSE = 476,
    OPCUA_MSG_SERVICE_CANCEL_REQUEST = 479,
    OPCUA_MSG_SERVICE_CANCEL_RESPONSE = 482,
    OPCUA_MSG_SERVICE_ADD_NODES_RESULT = 485,
    OPCUA_MSG_SERVICE_ADD_NODES_REQUEST = 488,
    OPCUA_MSG_SERVICE_ADD_NODES_RESPONSE = 491,
    OPCUA_MSG_SERVICE_ADD_REFERENCES_REQUEST = 494,
    OPCUA_MSG_SERVICE_ADD_REFERENCES_RESPONSE = 497,
    OPCUA_MSG_SERVICE_DELETE_NODES_REQUEST = 500,
    OPCUA_MSG_SERVICE_DELETE_NODES_RESPONSE = 503,
    OPCUA_MSG_SERVICE_DELETE_REFERENCES_REQUEST = 506,
    OPCUA_MSG_SERVICE_DELETE_REFERENCES_RESPONSE = 509,
    OPCUA_MSG_SERVICE_VIEW_DESCRIPTION = 513,
    OPCUA_MSG_SERVICE_BROWSE_DESCRIPTION = 516,
    OPCUA_MSG_SERVICE_REFERENCE_DESCRIPTION = 520,
    OPCUA_MSG_SERVICE_BROWSE_RESULT = 524,
    OPCUA_MSG_SERVICE_BROWSE_REQUEST = 527,
    OPCUA_MSG_SERVICE_BROWSE_RESPONSE = 530,
    OPCUA_MSG_SERVICE_BROWSE_NEXT_REQUEST = 533,
    OPCUA_MSG_SERVICE_BROWSE_NEXT_RESPONSE = 536,
    OPCUA_MSG_SERVICE_RELATIVE_PATH_ELEMENT = 539,
    OPCUA_MSG_SERVICE_RELATIVE_PATH = 542,
    OPCUA_MSG_SERVICE_BROWSE_PATH = 545,
    OPCUA_MSG_SERVICE_BROWSE_PATH_TARGET = 548,
    OPCUA_MSG_SERVICE_BROWSE_PATH_RESULT = 551,
    OPCUA_MSG_SERVICE_TRANSLATE_BROWSE_PATHS_TO_NODE_IDS_REQUEST = 554,
    OPCUA_MSG_SERVICE_TRANSLATE_BROWSE_PATHS_TO_NODE_IDS_RESPONSE = 557,
    OPCUA_MSG_SERVICE_REGISTER_NODES_REQUEST = 560,
    OPCUA_MSG_SERVICE_REGISTER_NODES_RESPONSE = 563,
    OPCUA_MSG_SERVICE_UNREGISTER_NODES_REQUEST = 566,
    OPCUA_MSG_SERVICE_UNREGISTER_NODES_RESPONSE = 569,
    OPCUA_MSG_SERVICE_QUERY_DATA_DESCRIPTION = 572,
    OPCUA_MSG_SERVICE_NODE_TYPE_DESCRIPTION = 575,
    OPCUA_MSG_SERVICE_QUERY_DATA_SET = 579,
    OPCUA_MSG_SERVICE_NODE_REFERENCE = 582,
    OPCUA_MSG_SERVICE_CONTENT_FILTER_ELEMENT = 585,
    OPCUA_MSG_SERVICE_CONTENT_FILTER = 588,
    OPCUA_MSG_SERVICE_FILTER_OPERAND = 591,
    OPCUA_MSG_SERVICE_ELEMENT_OPERAND = 594,
    OPCUA_MSG_SERVICE_LITERAL_OPERAND = 597,
    OPCUA_MSG_SERVICE_ATTRIBUTE_OPERAND = 600,
    OPCUA_MSG_SERVICE_SIMPLE_ATTRIBUTE_OPERAND = 603,
    OPCUA_MSG_SERVICE_CONTENT_FILTER_ELEMENT_RESULT = 606,
    OPCUA_MSG_SERVICE_CONTENT_FILTER_RESULT = 609,
    OPCUA_MSG_SERVICE_PARSING_RESULT = 612,
    OPCUA_MSG_SERVICE_QUERY_FIRST_REQUEST = 615,
    OPCUA_MSG_SERVICE_QUERY_FIRST_RESPONSE = 618,
    OPCUA_MSG_SERVICE_QUERY_NEXT_REQUEST = 621,
    OPCUA_MSG_SERVICE_QUERY_NEXT_RESPONSE = 624,
    OPCUA_MSG_SERVICE_READ_VALUE_ID = 628,
    OPCUA_MSG_SERVICE_READ_REQUEST = 631,
    OPCUA_MSG_SERVICE_READ_RESPONSE = 634,
    OPCUA_MSG_SERVICE_HISTORY_READ_VALUE_ID = 637,
    OPCUA_MSG_SERVICE_HISTORY_READ_RESULT = 640,
    OPCUA_MSG_SERVICE_HISTORY_READ_DETAILS = 643,
    OPCUA_MSG_SERVICE_READ_EVENT_DETAILS = 646,
    OPCUA_MSG_SERVICE_READ_RAW_MODIFIED_DETAILS = 649,
    OPCUA_MSG_SERVICE_READ_PROCESSED_DETAILS = 652,
    OPCUA_MSG_SERVICE_READ_AT_TIME_DETAILS = 655,
    OPCUA_MSG_SERVICE_HISTORY_DATA = 658,
    OPCUA_MSG_SERVICE_HISTORY_EVENT = 661,
    OPCUA_MSG_SERVICE_HISTORY_READ_REQUEST = 664,
    OPCUA_MSG_SERVICE_HISTORY_READ_RESPONSE = 667,
    OPCUA_MSG_SERVICE_WRITE_VALUE = 670,
    OPCUA_MSG_SERVICE_WRITE_REQUEST = 673,
    OPCUA_MSG_SERVICE_WRITE_RESPONSE = 676,
    OPCUA_MSG_SERVICE_HISTORY_UPDATE_DETAILS = 679,
    OPCUA_MSG_SERVICE_UPDATE_DATA_DETAILS = 682,
    OPCUA_MSG_SERVICE_UPDATE_EVENT_DETAILS = 685,
    OPCUA_MSG_SERVICE_DELETE_RAW_MODIFIED_DETAILS = 688,
    OPCUA_MSG_SERVICE_DELETE_AT_TIME_DETAILS = 691,
    OPCUA_MSG_SERVICE_DELETE_EVENT_DETAILS = 694,
    OPCUA_MSG_SERVICE_HISTORY_UPDATE_RESULT = 697,
    OPCUA_MSG_SERVICE_HISTORY_UPDATE_REQUEST = 700,
    OPCUA_MSG_SERVICE_HISTORY_UPDATE_RESPONSE = 703,
    OPCUA_MSG_SERVICE_CALL_METHOD_REQUEST = 706,
    OPCUA_MSG_SERVICE_CALL_METHOD_RESULT = 709,
    OPCUA_MSG_SERVICE_CALL_REQUEST = 712,
    OPCUA_MSG_SERVICE_CALL_RESPONSE = 715,
    OPCUA_MSG_SERVICE_MONITORING_FILTER = 721,
    OPCUA_MSG_SERVICE_DATA_CHANGE_FILTER = 724,
    OPCUA_MSG_SERVICE_EVENT_FILTER = 727,
    OPCUA_MSG_SERVICE_AGGREGATE_FILTER = 730,
    OPCUA_MSG_SERVICE_MONITORING_FILTER_RESULT = 733,
    OPCUA_MSG_SERVICE_EVENT_FILTER_RESULT = 736,
    OPCUA_MSG_SERVICE_AGGREGATE_FILTER_RESULT = 739,
    OPCUA_MSG_SERVICE_MONITORING_PARAMETERS = 742,
    OPCUA_MSG_SERVICE_MONITORED_ITEM_CREATE_REQUEST = 745,
    OPCUA_MSG_SERVICE_MONITORED_ITEM_CREATE_RESULT = 748,
    OPCUA_MSG_SERVICE_CREATE_MONITORED_ITEMS_REQUEST = 751,
    OPCUA_MSG_SERVICE_CREATE_MONITORED_ITEMS_RESPONSE = 754,
    OPCUA_MSG_SERVICE_MONITORED_ITEM_MODIFY_REQUEST = 757,
    OPCUA_MSG_SERVICE_MONITORED_ITEM_MODIFY_RESULT = 760,
    OPCUA_MSG_SERVICE_MODIFY_MONITORED_ITEMS_REQUEST = 763,
    OPCUA_MSG_SERVICE_MODIFY_MONITORED_ITEMS_RESPONSE = 766,
    OPCUA_MSG_SERVICE_SET_MONITORING_MODE_REQUEST = 769,
    OPCUA_MSG_SERVICE_SET_MONITORING_MODE_RESPONSE = 772,
    OPCUA_MSG_SERVICE_SET_TRIGGERING_REQUEST = 775,
    OPCUA_MSG_SERVICE_SET_TRIGGERING_RESPONSE = 778,
    OPCUA_MSG_SERVICE_DELETE_MONITORED_ITEMS_REQUEST = 781,
    OPCUA_MSG_SERVICE_DELETE_MONITORED_ITEMS_RESPONSE = 784,
    OPCUA_MSG_SERVICE_CREATE_SUBSCRIPTION_REQUEST = 787,
    OPCUA_MSG_SERVICE_CREATE_SUBSCRIPTION_RESPONSE = 790,
    OPCUA_MSG_SERVICE_MODIFY_SUBSCRIPTION_REQUEST = 793,
    OPCUA_MSG_SERVICE_MODIFY_SUBSCRIPTION_RESPONSE = 796,
    OPCUA_MSG_SERVICE_SET_PUBLISHING_MODE_REQUEST = 799,
    OPCUA_MSG_SERVICE_SET_PUBLISHING_MODE_RESPONSE = 802,
    OPCUA_MSG_SERVICE_NOTIFICATION_MESSAGE = 805,
    OPCUA_MSG_SERVICE_MONITORED_ITEM_NOTIFICATION = 808,
    OPCUA_MSG_SERVICE_DATA_CHANGE_NOTIFICATION = 811,
    OPCUA_MSG_SERVICE_STATUS_CHANGE_NOTIFICATION = 820,
    OPCUA_MSG_SERVICE_SUBSCRIPTION_ACKNOWLEDGEMENT = 823,
    OPCUA_MSG_SERVICE_PUBLISH_REQUEST = 826,
    OPCUA_MSG_SERVICE_PUBLISH_RESPONSE = 829,
    OPCUA_MSG_SERVICE_REPUBLISH_REQUEST = 832,
    OPCUA_MSG_SERVICE_REPUBLISH_RESPONSE = 835,
    OPCUA_MSG_SERVICE_TRANSFER_RESULT = 838,
    OPCUA_MSG_SERVICE_TRANSFER_SUBSCRIPTIONS_REQUEST = 841,
    OPCUA_MSG_SERVICE_TRANSFER_SUBSCRIPTIONS_RESPONSE = 844,
    OPCUA_MSG_SERVICE_DELETE_SUBSCRIPTIONS_REQUEST = 847,
    OPCUA_MSG_SERVICE_DELETE_SUBSCRIPTIONS_RESPONSE = 850,
    OPCUA_MSG_SERVICE_REDUNDANT_SERVER_DATA_TYPE = 855,
    OPCUA_MSG_SERVICE_SAMPLING_INTERVAL_DIAGNOSTICS_DATA_TYPE = 858,
    OPCUA_MSG_SERVICE_SERVER_DIAGNOSTICS_SUMMARY_DATA_TYPE = 861,
    OPCUA_MSG_SERVICE_SERVER_STATUS_DATA_TYPE = 864,
    OPCUA_MSG_SERVICE_SESSION_DIAGNOSTICS_DATA_TYPE = 867,
    OPCUA_MSG_SERVICE_SESSION_SECURITY_DIAGNOSTICS_DATA_TYPE = 870,
    OPCUA_MSG_SERVICE_SERVICE_COUNTER_DATA_TYPE = 873,
    OPCUA_MSG_SERVICE_SUBSCRIPTION_DIAGNOSTICS_DATA_TYPE = 876,
    OPCUA_MSG_SERVICE_MODEL_CHANGE_STRUCTURE_DATA_TYPE = 879,
    OPCUA_MSG_SERVICE_RANGE = 886,
    OPCUA_MSG_SERVICE_E_U_INFORMATION = 889,
    OPCUA_MSG_SERVICE_ANNOTATION = 893,
    OPCUA_MSG_SERVICE_PROGRAM_DIAGNOSTIC_DATA_TYPE = 896,
    OPCUA_MSG_SERVICE_SEMANTIC_CHANGE_STRUCTURE_DATA_TYPE = 899,
    OPCUA_MSG_SERVICE_EVENT_NOTIFICATION_LIST = 916,
    OPCUA_MSG_SERVICE_EVENT_FIELD_LIST = 919,
    OPCUA_MSG_SERVICE_HISTORY_EVENT_FIELD_LIST = 922,
    OPCUA_MSG_SERVICE_ISSUED_IDENTITY_TOKEN = 940,
    OPCUA_MSG_SERVICE_NOTIFICATION_DATA = 947,
    OPCUA_MSG_SERVICE_AGGREGATE_CONFIGURATION = 950,
    OPCUA_MSG_SERVICE_ENUM_VALUE_TYPE = 8251,
    OPCUA_MSG_SERVICE_TIME_ZONE_DATA_TYPE = 8917,
    OPCUA_MSG_SERVICE_MODIFICATION_INFO = 11226,
    OPCUA_MSG_SERVICE_HISTORY_MODIFIED_DATA = 11227,
    OPCUA_MSG_SERVICE_UPDATE_STRUCTURE_DATA_DETAILS = 11300,
    OPCUA_MSG_SERVICE_INSTANCE_NODE = 11889,
    OPCUA_MSG_SERVICE_TYPE_NODE = 11890,
    OPCUA_MSG_SERVICE_ENDPOINT_URL_LIST_DATA_TYPE = 11957,
    OPCUA_MSG_SERVICE_NETWORK_GROUP_DATA_TYPE = 11958,
    OPCUA_MSG_SERVICE_AXIS_INFORMATION = 12089,
    OPCUA_MSG_SERVICE_X_V_TYPE = 12090,
    OPCUA_MSG_SERVICE_COMPLEX_NUMBER_TYPE = 12181,
    OPCUA_MSG_SERVICE_DOUBLE_COMPLEX_NUMBER_TYPE = 12182,
    OPCUA_MSG_SERVICE_SERVER_ON_NETWORK = 12207,
    OPCUA_MSG_SERVICE_FIND_SERVERS_ON_NETWORK_REQUEST = 12208,
    OPCUA_MSG_SERVICE_FIND_SERVERS_ON_NETWORK_RESPONSE = 12209,
    OPCUA_MSG_SERVICE_REGISTER_SERVER2_REQUEST = 12211,
    OPCUA_MSG_SERVICE_REGISTER_SERVER2_RESPONSE = 12212,
    OPCUA_MSG_SERVICE_TRUST_LIST_DATA_TYPE = 12680,
    OPCUA_MSG_SERVICE_OPTION_SET = 12765,
    OPCUA_MSG_SERVICE_UNION = 12766,
    OPCUA_MSG_SERVICE_DISCOVERY_CONFIGURATION = 12900,
    OPCUA_MSG_SERVICE_MDNS_DISCOVERY_CONFIGURATION = 12901,
    OPCUA_MSG_SERVICE_PUBLISHED_VARIABLE_DATA_TYPE = 14323,
    OPCUA_MSG_SERVICE_FIELD_META_DATA = 14839,
    OPCUA_MSG_SERVICE_STRUCTURE_FIELD = 14844,
    OPCUA_MSG_SERVICE_ENUM_FIELD = 14845,
    OPCUA_MSG_SERVICE_KEY_VALUE_PAIR = 14846,
    OPCUA_MSG_SERVICE_CONFIGURATION_VERSION_DATA_TYPE = 14847,
    OPCUA_MSG_SERVICE_FIELD_TARGET_DATA_TYPE = 14848,
    OPCUA_MSG_SERVICE_TEST_SCALAR_STRUCTURE = 15024,
    OPCUA_MSG_SERVICE_TEST_ARRAY_STRUCTURE = 15025,
    OPCUA_MSG_SERVICE_TEST_STRUCTURE = 15026,
    OPCUA_MSG_SERVICE_TEST_ABSTRACT_STRUCTURE = 15401,
    OPCUA_MSG_SERVICE_TEST_CONCRETE_STRUCTURE = 15402,
    OPCUA_MSG_SERVICE_SIMPLE_TYPE_DESCRIPTION = 15421,
    OPCUA_MSG_SERVICE_U_A_BINARY_FILE_DATA_TYPE = 15422,
    OPCUA_MSG_SERVICE_BROKER_CONNECTION_TRANSPORT_DATA_TYPE = 15479,
    OPCUA_MSG_SERVICE_ENDPOINT_TYPE = 15671,
    OPCUA_MSG_SERVICE_DATA_TYPE_SCHEMA_HEADER = 15676,
    OPCUA_MSG_SERVICE_PUBLISHED_DATA_SET_DATA_TYPE = 15677,
    OPCUA_MSG_SERVICE_PUBLISHED_DATA_SET_SOURCE_DATA_TYPE = 15678,
    OPCUA_MSG_SERVICE_PUBLISHED_DATA_ITEMS_DATA_TYPE = 15679,
    OPCUA_MSG_SERVICE_PUBLISHED_EVENTS_DATA_TYPE = 15681,
    OPCUA_MSG_SERVICE_DATA_SET_WRITER_DATA_TYPE = 15682,
    OPCUA_MSG_SERVICE_DATA_SET_WRITER_TRANSPORT_DATA_TYPE = 15683,
    OPCUA_MSG_SERVICE_DATA_SET_WRITER_MESSAGE_DATA_TYPE = 15688,
    OPCUA_MSG_SERVICE_PUB_SUB_GROUP_DATA_TYPE = 15689,
    OPCUA_MSG_SERVICE_WRITER_GROUP_TRANSPORT_DATA_TYPE = 15691,
    OPCUA_MSG_SERVICE_WRITER_GROUP_MESSAGE_DATA_TYPE = 15693,
    OPCUA_MSG_SERVICE_PUB_SUB_CONNECTION_DATA_TYPE = 15694,
    OPCUA_MSG_SERVICE_CONNECTION_TRANSPORT_DATA_TYPE = 15695,
    OPCUA_MSG_SERVICE_READER_GROUP_TRANSPORT_DATA_TYPE = 15701,
    OPCUA_MSG_SERVICE_READER_GROUP_MESSAGE_DATA_TYPE = 15702,
    OPCUA_MSG_SERVICE_DATA_SET_READER_DATA_TYPE = 15703,
    OPCUA_MSG_SERVICE_DATA_SET_READER_TRANSPORT_DATA_TYPE = 15705,
    OPCUA_MSG_SERVICE_DATA_SET_READER_MESSAGE_DATA_TYPE = 15706,
    OPCUA_MSG_SERVICE_SUBSCRIBED_DATA_SET_DATA_TYPE = 15707,
    OPCUA_MSG_SERVICE_TARGET_VARIABLES_DATA_TYPE = 15712,
    OPCUA_MSG_SERVICE_SUBSCRIBED_DATA_SET_MIRROR_DATA_TYPE = 15713,
    OPCUA_MSG_SERVICE_UADP_WRITER_GROUP_MESSAGE_DATA_TYPE = 15715,
    OPCUA_MSG_SERVICE_UADP_DATA_SET_WRITER_MESSAGE_DATA_TYPE = 15717,
    OPCUA_MSG_SERVICE_UADP_DATA_SET_READER_MESSAGE_DATA_TYPE = 15718,
    OPCUA_MSG_SERVICE_JSON_WRITER_GROUP_MESSAGE_DATA_TYPE = 15719,
    OPCUA_MSG_SERVICE_JSON_DATA_SET_WRITER_MESSAGE_DATA_TYPE = 15724,
    OPCUA_MSG_SERVICE_JSON_DATA_SET_READER_MESSAGE_DATA_TYPE = 15725,
    OPCUA_MSG_SERVICE_BROKER_WRITER_GROUP_TRANSPORT_DATA_TYPE = 15727,
    OPCUA_MSG_SERVICE_BROKER_DATA_SET_WRITER_TRANSPORT_DATA_TYPE = 15729,
    OPCUA_MSG_SERVICE_BROKER_DATA_SET_READER_TRANSPORT_DATA_TYPE = 15733,
    OPCUA_MSG_SERVICE_IDENTITY_MAPPING_RULE_TYPE = 15736,
    OPCUA_MSG_SERVICE_SESSIONLESS_INVOKE_REQUEST_TYPE = 15903,
    OPCUA_MSG_SERVICE_DATAGRAM_CONNECTION_TRANSPORT_DATA_TYPE = 17468,
    OPCUA_MSG_SERVICE_ADDITIONAL_PARAMETERS_TYPE = 17537,
    OPCUA_MSG_SERVICE_EPHEMERAL_KEY_TYPE = 17549,
    OPCUA_MSG_SERVICE_GENERIC_ATTRIBUTE_VALUE = 17610,
    OPCUA_MSG_SERVICE_GENERIC_ATTRIBUTES = 17611,
    OPCUA_MSG_SERVICE_DECIMAL_DATA_TYPE = 17863,
    OPCUA_MSG_SERVICE_ACTION_TARGET_DATA_TYPE = 18598,
    OPCUA_MSG_SERVICE_PUBLISHED_ACTION_DATA_TYPE = 18599,
    OPCUA_MSG_SERVICE_ACTION_METHOD_DATA_TYPE = 18600,
    OPCUA_MSG_SERVICE_SORT_RULE_ELEMENT = 18650,
    OPCUA_MSG_SERVICE_READ_EVENT_DETAILS_SORTED = 18651,
    OPCUA_MSG_SERVICE_PUBLISHED_ACTION_METHOD_DATA_TYPE = 18795,
    OPCUA_MSG_SERVICE_RATIONAL_NUMBER = 18815,
    OPCUA_MSG_SERVICE_VECTOR = 18816,
    OPCUA_MSG_SERVICE_THREE_D_VECTOR = 18817,
    OPCUA_MSG_SERVICE_CARTESIAN_COORDINATES = 18818,
    OPCUA_MSG_SERVICE_THREE_D_CARTESIAN_COORDINATES = 18819,
    OPCUA_MSG_SERVICE_ORIENTATION = 18820,
    OPCUA_MSG_SERVICE_THREE_D_ORIENTATION = 18821,
    OPCUA_MSG_SERVICE_FRAME = 18822,
    OPCUA_MSG_SERVICE_THREE_D_FRAME = 18823,
    OPCUA_MSG_SERVICE_DTLS_PUB_SUB_CONNECTION_DATA_TYPE = 18930,
    OPCUA_MSG_SERVICE_LLDP_MANAGEMENT_ADDRESS_TX_PORT_TYPE = 19079,
    OPCUA_MSG_SERVICE_LLDP_MANAGEMENT_ADDRESS_TYPE = 19080,
    OPCUA_MSG_SERVICE_LLDP_TLV_TYPE = 19081,
    OPCUA_MSG_SERVICE_TEST_UNION = 19435,
    OPCUA_MSG_SERVICE_TEST_OPTIONAL_FIELDS = 19436,
    OPCUA_MSG_SERVICE_SESSIONLESS_INVOKE_RESPONSE_TYPE = 21001,
    OPCUA_MSG_SERVICE_WRITER_GROUP_DATA_TYPE = 21150,
    OPCUA_MSG_SERVICE_NETWORK_ADDRESS_DATA_TYPE = 21151,
    OPCUA_MSG_SERVICE_NETWORK_ADDRESS_URL_DATA_TYPE = 21152,
    OPCUA_MSG_SERVICE_READER_GROUP_DATA_TYPE = 21153,
    OPCUA_MSG_SERVICE_PUB_SUB_CONFIGURATION_DATA_TYPE = 21154,
    OPCUA_MSG_SERVICE_DATAGRAM_WRITER_GROUP_TRANSPORT_DATA_TYPE = 21155,
    OPCUA_MSG_SERVICE_ALIAS_NAME_DATA_TYPE = 23499,
    OPCUA_MSG_SERVICE_READ_ANNOTATION_DATA_DETAILS = 23500,
    OPCUA_MSG_SERVICE_CURRENCY_UNIT_TYPE = 23507,
    OPCUA_MSG_SERVICE_STANDALONE_SUBSCRIBED_DATA_SET_REF_DATA_TYPE = 23851,
    OPCUA_MSG_SERVICE_STANDALONE_SUBSCRIBED_DATA_SET_DATA_TYPE = 23852,
    OPCUA_MSG_SERVICE_SECURITY_GROUP_DATA_TYPE = 23853,
    OPCUA_MSG_SERVICE_PUB_SUB_CONFIGURATION2_DATA_TYPE = 23854,
    OPCUA_MSG_SERVICE_QOS_DATA_TYPE = 23855,
    OPCUA_MSG_SERVICE_TRANSMIT_QOS_DATA_TYPE = 23856,
    OPCUA_MSG_SERVICE_TRANSMIT_QOS_PRIORITY_DATA_TYPE = 23857,
    OPCUA_MSG_SERVICE_RECEIVE_QOS_DATA_TYPE = 23860,
    OPCUA_MSG_SERVICE_RECEIVE_QOS_PRIORITY_DATA_TYPE = 23861,
    OPCUA_MSG_SERVICE_DATAGRAM_CONNECTION_TRANSPORT2_DATA_TYPE = 23864,
    OPCUA_MSG_SERVICE_DATAGRAM_WRITER_GROUP_TRANSPORT2_DATA_TYPE = 23865,
    OPCUA_MSG_SERVICE_DATAGRAM_DATA_SET_READER_TRANSPORT_DATA_TYPE = 23866,
    OPCUA_MSG_SERVICE_PROGRAM_DIAGNOSTIC2_DATA_TYPE = 24034,
    OPCUA_MSG_SERVICE_PORTABLE_QUALIFIED_NAME = 24108,
    OPCUA_MSG_SERVICE_PORTABLE_NODE_ID = 24109,
    OPCUA_MSG_SERVICE_UNSIGNED_RATIONAL_NUMBER = 24110,
    OPCUA_MSG_SERVICE_USER_MANAGEMENT_DATA_TYPE = 24292,
    OPCUA_MSG_SERVICE_PRIORITY_MAPPING_ENTRY_TYPE = 25239,
    OPCUA_MSG_SERVICE_PUBLISHED_DATA_SET_CUSTOM_SOURCE_DATA_TYPE = 25529,
    OPCUA_MSG_SERVICE_PUB_SUB_KEY_PUSH_TARGET_DATA_TYPE = 25530,
    OPCUA_MSG_SERVICE_PUB_SUB_CONFIGURATION_REF_DATA_TYPE = 25531,
    OPCUA_MSG_SERVICE_PUB_SUB_CONFIGURATION_VALUE_DATA_TYPE = 25532,
    OPCUA_MSG_SERVICE_TRANSACTION_ERROR_TYPE = 32382,
    OPCUA_MSG_SERVICE_BIT_FIELD_DEFINITION = 32422,
    OPCUA_MSG_SERVICE_ANNOTATION_DATA_TYPE = 32560,
    OPCUA_MSG_SERVICE_LINEAR_CONVERSION_DATA_TYPE = 32561,
    OPCUA_MSG_SERVICE_QUANTITY_DIMENSION = 32562,
    OPCUA_MSG_SERVICE_REFERENCE_DESCRIPTION_DATA_TYPE = 32661,
    OPCUA_MSG_SERVICE_REFERENCE_LIST_ENTRY_DATA_TYPE = 32662,
    OPCUA_MSG_SERVICE_READ_EVENT_DETAILS2 = 32800,
    OPCUA_MSG_SERVICE_HISTORY_MODIFIED_EVENT = 32825,
};

#endif
