/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the UserStatement type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &UserStatement{}

// UserStatement struct for UserStatement
type UserStatement struct {
	// User statement ID.
	Id int32 `json:"id"`
	// User ID.
	UserId NullableInt32 `json:"userId"`
	// User statement date.
	Date time.Time `json:"date"`
	Balance NullableFloat64 `json:"balance"`
	// Balance change amount.
	Delta NullableFloat32 `json:"delta"`
	// Type of statement (what you have been charged for): *   **sms** - for sending SMS *   **number** - for renewing a dedicated number; *   **schedule** - for scheduling text messages; *   **topup** - for adding credits to your account. 
	Type string `json:"type"`
	// Value differs by **type**: *   for **sms**, it is the sent messages amount; *   for **number**, it is a dedicated phone number; *   for **schedule**, it is a scheduled messages amount; *   for **top-up**, it is an invoice ID. 
	Value NullableString `json:"value"`
	// Optional comment.
	Comment NullableString `json:"comment"`
}

type _UserStatement UserStatement

// NewUserStatement instantiates a new UserStatement object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUserStatement(id int32, userId NullableInt32, date time.Time, balance NullableFloat64, delta NullableFloat32, type_ string, value NullableString, comment NullableString) *UserStatement {
	this := UserStatement{}
	this.Id = id
	this.UserId = userId
	this.Date = date
	this.Balance = balance
	this.Delta = delta
	this.Type = type_
	this.Value = value
	this.Comment = comment
	return &this
}

// NewUserStatementWithDefaults instantiates a new UserStatement object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUserStatementWithDefaults() *UserStatement {
	this := UserStatement{}
	return &this
}

// GetId returns the Id field value
func (o *UserStatement) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *UserStatement) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *UserStatement) SetId(v int32) {
	o.Id = v
}

// GetUserId returns the UserId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *UserStatement) GetUserId() int32 {
	if o == nil || o.UserId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.UserId.Get()
}

// GetUserIdOk returns a tuple with the UserId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UserStatement) GetUserIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.UserId.Get(), o.UserId.IsSet()
}

// SetUserId sets field value
func (o *UserStatement) SetUserId(v int32) {
	o.UserId.Set(&v)
}

// GetDate returns the Date field value
func (o *UserStatement) GetDate() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.Date
}

// GetDateOk returns a tuple with the Date field value
// and a boolean to check if the value has been set.
func (o *UserStatement) GetDateOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Date, true
}

// SetDate sets field value
func (o *UserStatement) SetDate(v time.Time) {
	o.Date = v
}

// GetBalance returns the Balance field value
// If the value is explicit nil, the zero value for float64 will be returned
func (o *UserStatement) GetBalance() float64 {
	if o == nil || o.Balance.Get() == nil {
		var ret float64
		return ret
	}

	return *o.Balance.Get()
}

// GetBalanceOk returns a tuple with the Balance field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UserStatement) GetBalanceOk() (*float64, bool) {
	if o == nil {
		return nil, false
	}
	return o.Balance.Get(), o.Balance.IsSet()
}

// SetBalance sets field value
func (o *UserStatement) SetBalance(v float64) {
	o.Balance.Set(&v)
}

// GetDelta returns the Delta field value
// If the value is explicit nil, the zero value for float32 will be returned
func (o *UserStatement) GetDelta() float32 {
	if o == nil || o.Delta.Get() == nil {
		var ret float32
		return ret
	}

	return *o.Delta.Get()
}

// GetDeltaOk returns a tuple with the Delta field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UserStatement) GetDeltaOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Delta.Get(), o.Delta.IsSet()
}

// SetDelta sets field value
func (o *UserStatement) SetDelta(v float32) {
	o.Delta.Set(&v)
}

// GetType returns the Type field value
func (o *UserStatement) GetType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Type
}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
func (o *UserStatement) GetTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Type, true
}

// SetType sets field value
func (o *UserStatement) SetType(v string) {
	o.Type = v
}

// GetValue returns the Value field value
// If the value is explicit nil, the zero value for string will be returned
func (o *UserStatement) GetValue() string {
	if o == nil || o.Value.Get() == nil {
		var ret string
		return ret
	}

	return *o.Value.Get()
}

// GetValueOk returns a tuple with the Value field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UserStatement) GetValueOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Value.Get(), o.Value.IsSet()
}

// SetValue sets field value
func (o *UserStatement) SetValue(v string) {
	o.Value.Set(&v)
}

// GetComment returns the Comment field value
// If the value is explicit nil, the zero value for string will be returned
func (o *UserStatement) GetComment() string {
	if o == nil || o.Comment.Get() == nil {
		var ret string
		return ret
	}

	return *o.Comment.Get()
}

// GetCommentOk returns a tuple with the Comment field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UserStatement) GetCommentOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Comment.Get(), o.Comment.IsSet()
}

// SetComment sets field value
func (o *UserStatement) SetComment(v string) {
	o.Comment.Set(&v)
}

func (o UserStatement) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o UserStatement) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["userId"] = o.UserId.Get()
	toSerialize["date"] = o.Date
	toSerialize["balance"] = o.Balance.Get()
	toSerialize["delta"] = o.Delta.Get()
	toSerialize["type"] = o.Type
	toSerialize["value"] = o.Value.Get()
	toSerialize["comment"] = o.Comment.Get()
	return toSerialize, nil
}

func (o *UserStatement) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"userId",
		"date",
		"balance",
		"delta",
		"type",
		"value",
		"comment",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varUserStatement := _UserStatement{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varUserStatement)

	if err != nil {
		return err
	}

	*o = UserStatement(varUserStatement)

	return err
}

type NullableUserStatement struct {
	value *UserStatement
	isSet bool
}

func (v NullableUserStatement) Get() *UserStatement {
	return v.value
}

func (v *NullableUserStatement) Set(val *UserStatement) {
	v.value = val
	v.isSet = true
}

func (v NullableUserStatement) IsSet() bool {
	return v.isSet
}

func (v *NullableUserStatement) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUserStatement(val *UserStatement) *NullableUserStatement {
	return &NullableUserStatement{value: val, isSet: true}
}

func (v NullableUserStatement) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUserStatement) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


