/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the MessageSession type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &MessageSession{}

// MessageSession struct for MessageSession
type MessageSession struct {
	// Session ID.
	Id int32 `json:"id"`
	// Session creation time.
	StartTime NullableString `json:"startTime"`
	// Session text. If a template was used for the session text (see [Messages: Send](https://docs.textmagic.com/#tag/Outbound-Messages) for details), it may contain template tags. 
	Text NullableString `json:"text"`
	// *   **O** – for Textmagic Online; *   **A** – for API; *   **M** – for Textmagic Messenger; *   **E** – for [Email to SMS](https://docs.textmagic.com/#tag/Send-Email-to-SMS); *   **X** – for [Distribution Lists](https://docs.textmagic.com/#tag/Distribution-Lists). 
	Source NullableString `json:"source"`
	// Custom reference ID (see [Messages: Send](https://docs.textmagic.com/#tag/Send-Email-to-SMS) for details). 
	ReferenceId NullableString `json:"referenceId"`
	// Session cost (in account currency).
	Price NullableFloat32 `json:"price"`
	// Session recipient count.
	NumbersCount NullableInt32 `json:"numbersCount"`
	// Destination type of a Message Session: * **t** – text SMS; * **s** – text-to-speech; * **v** – voice broadcast. 
	Destination NullableString `json:"destination"`
	// Initiator ID.
	InitiatorId NullableInt32 `json:"initiatorId"`
	Title NullableString `json:"title"`
}

type _MessageSession MessageSession

// NewMessageSession instantiates a new MessageSession object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewMessageSession(id int32, startTime NullableString, text NullableString, source NullableString, referenceId NullableString, price NullableFloat32, numbersCount NullableInt32, destination NullableString, initiatorId NullableInt32, title NullableString) *MessageSession {
	this := MessageSession{}
	this.Id = id
	this.StartTime = startTime
	this.Text = text
	this.Source = source
	this.ReferenceId = referenceId
	this.Price = price
	this.NumbersCount = numbersCount
	this.Destination = destination
	this.InitiatorId = initiatorId
	this.Title = title
	return &this
}

// NewMessageSessionWithDefaults instantiates a new MessageSession object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewMessageSessionWithDefaults() *MessageSession {
	this := MessageSession{}
	return &this
}

// GetId returns the Id field value
func (o *MessageSession) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *MessageSession) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *MessageSession) SetId(v int32) {
	o.Id = v
}

// GetStartTime returns the StartTime field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageSession) GetStartTime() string {
	if o == nil || o.StartTime.Get() == nil {
		var ret string
		return ret
	}

	return *o.StartTime.Get()
}

// GetStartTimeOk returns a tuple with the StartTime field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageSession) GetStartTimeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.StartTime.Get(), o.StartTime.IsSet()
}

// SetStartTime sets field value
func (o *MessageSession) SetStartTime(v string) {
	o.StartTime.Set(&v)
}

// GetText returns the Text field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageSession) GetText() string {
	if o == nil || o.Text.Get() == nil {
		var ret string
		return ret
	}

	return *o.Text.Get()
}

// GetTextOk returns a tuple with the Text field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageSession) GetTextOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Text.Get(), o.Text.IsSet()
}

// SetText sets field value
func (o *MessageSession) SetText(v string) {
	o.Text.Set(&v)
}

// GetSource returns the Source field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageSession) GetSource() string {
	if o == nil || o.Source.Get() == nil {
		var ret string
		return ret
	}

	return *o.Source.Get()
}

// GetSourceOk returns a tuple with the Source field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageSession) GetSourceOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Source.Get(), o.Source.IsSet()
}

// SetSource sets field value
func (o *MessageSession) SetSource(v string) {
	o.Source.Set(&v)
}

// GetReferenceId returns the ReferenceId field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageSession) GetReferenceId() string {
	if o == nil || o.ReferenceId.Get() == nil {
		var ret string
		return ret
	}

	return *o.ReferenceId.Get()
}

// GetReferenceIdOk returns a tuple with the ReferenceId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageSession) GetReferenceIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ReferenceId.Get(), o.ReferenceId.IsSet()
}

// SetReferenceId sets field value
func (o *MessageSession) SetReferenceId(v string) {
	o.ReferenceId.Set(&v)
}

// GetPrice returns the Price field value
// If the value is explicit nil, the zero value for float32 will be returned
func (o *MessageSession) GetPrice() float32 {
	if o == nil || o.Price.Get() == nil {
		var ret float32
		return ret
	}

	return *o.Price.Get()
}

// GetPriceOk returns a tuple with the Price field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageSession) GetPriceOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Price.Get(), o.Price.IsSet()
}

// SetPrice sets field value
func (o *MessageSession) SetPrice(v float32) {
	o.Price.Set(&v)
}

// GetNumbersCount returns the NumbersCount field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *MessageSession) GetNumbersCount() int32 {
	if o == nil || o.NumbersCount.Get() == nil {
		var ret int32
		return ret
	}

	return *o.NumbersCount.Get()
}

// GetNumbersCountOk returns a tuple with the NumbersCount field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageSession) GetNumbersCountOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.NumbersCount.Get(), o.NumbersCount.IsSet()
}

// SetNumbersCount sets field value
func (o *MessageSession) SetNumbersCount(v int32) {
	o.NumbersCount.Set(&v)
}

// GetDestination returns the Destination field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageSession) GetDestination() string {
	if o == nil || o.Destination.Get() == nil {
		var ret string
		return ret
	}

	return *o.Destination.Get()
}

// GetDestinationOk returns a tuple with the Destination field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageSession) GetDestinationOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Destination.Get(), o.Destination.IsSet()
}

// SetDestination sets field value
func (o *MessageSession) SetDestination(v string) {
	o.Destination.Set(&v)
}

// GetInitiatorId returns the InitiatorId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *MessageSession) GetInitiatorId() int32 {
	if o == nil || o.InitiatorId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.InitiatorId.Get()
}

// GetInitiatorIdOk returns a tuple with the InitiatorId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageSession) GetInitiatorIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.InitiatorId.Get(), o.InitiatorId.IsSet()
}

// SetInitiatorId sets field value
func (o *MessageSession) SetInitiatorId(v int32) {
	o.InitiatorId.Set(&v)
}

// GetTitle returns the Title field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageSession) GetTitle() string {
	if o == nil || o.Title.Get() == nil {
		var ret string
		return ret
	}

	return *o.Title.Get()
}

// GetTitleOk returns a tuple with the Title field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageSession) GetTitleOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Title.Get(), o.Title.IsSet()
}

// SetTitle sets field value
func (o *MessageSession) SetTitle(v string) {
	o.Title.Set(&v)
}

func (o MessageSession) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o MessageSession) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["startTime"] = o.StartTime.Get()
	toSerialize["text"] = o.Text.Get()
	toSerialize["source"] = o.Source.Get()
	toSerialize["referenceId"] = o.ReferenceId.Get()
	toSerialize["price"] = o.Price.Get()
	toSerialize["numbersCount"] = o.NumbersCount.Get()
	toSerialize["destination"] = o.Destination.Get()
	toSerialize["initiatorId"] = o.InitiatorId.Get()
	toSerialize["title"] = o.Title.Get()
	return toSerialize, nil
}

func (o *MessageSession) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"startTime",
		"text",
		"source",
		"referenceId",
		"price",
		"numbersCount",
		"destination",
		"initiatorId",
		"title",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varMessageSession := _MessageSession{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varMessageSession)

	if err != nil {
		return err
	}

	*o = MessageSession(varMessageSession)

	return err
}

type NullableMessageSession struct {
	value *MessageSession
	isSet bool
}

func (v NullableMessageSession) Get() *MessageSession {
	return v.value
}

func (v *NullableMessageSession) Set(val *MessageSession) {
	v.value = val
	v.isSet = true
}

func (v NullableMessageSession) IsSet() bool {
	return v.isSet
}

func (v *NullableMessageSession) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableMessageSession(val *MessageSession) *NullableMessageSession {
	return &NullableMessageSession{value: val, isSet: true}
}

func (v NullableMessageSession) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableMessageSession) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


