/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the BulkSession type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &BulkSession{}

// BulkSession struct for BulkSession
type BulkSession struct {
	// Bulk Session ID.
	Id int32 `json:"id"`
	// * **n** – bulk session is just created * **w** - work in progress * **f** - failed * **c** - completed with success * **s** - suspended 
	Status string `json:"status"`
	// Amount of messages already processed.
	ItemsProcessed NullableInt32 `json:"itemsProcessed"`
	// Total amount of messages to be processed.
	ItemsTotal NullableInt32 `json:"itemsTotal"`
	// Creation date and time of a Bulk Session.
	CreatedAt time.Time `json:"createdAt"`
	Session NullableMessageSession `json:"session"`
	// Message text of a Bulk Session.
	Text NullableString `json:"text"`
}

type _BulkSession BulkSession

// NewBulkSession instantiates a new BulkSession object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBulkSession(id int32, status string, itemsProcessed NullableInt32, itemsTotal NullableInt32, createdAt time.Time, session NullableMessageSession, text NullableString) *BulkSession {
	this := BulkSession{}
	this.Id = id
	this.Status = status
	this.ItemsProcessed = itemsProcessed
	this.ItemsTotal = itemsTotal
	this.CreatedAt = createdAt
	this.Session = session
	this.Text = text
	return &this
}

// NewBulkSessionWithDefaults instantiates a new BulkSession object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBulkSessionWithDefaults() *BulkSession {
	this := BulkSession{}
	return &this
}

// GetId returns the Id field value
func (o *BulkSession) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *BulkSession) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *BulkSession) SetId(v int32) {
	o.Id = v
}

// GetStatus returns the Status field value
func (o *BulkSession) GetStatus() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Status
}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
func (o *BulkSession) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Status, true
}

// SetStatus sets field value
func (o *BulkSession) SetStatus(v string) {
	o.Status = v
}

// GetItemsProcessed returns the ItemsProcessed field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *BulkSession) GetItemsProcessed() int32 {
	if o == nil || o.ItemsProcessed.Get() == nil {
		var ret int32
		return ret
	}

	return *o.ItemsProcessed.Get()
}

// GetItemsProcessedOk returns a tuple with the ItemsProcessed field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *BulkSession) GetItemsProcessedOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.ItemsProcessed.Get(), o.ItemsProcessed.IsSet()
}

// SetItemsProcessed sets field value
func (o *BulkSession) SetItemsProcessed(v int32) {
	o.ItemsProcessed.Set(&v)
}

// GetItemsTotal returns the ItemsTotal field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *BulkSession) GetItemsTotal() int32 {
	if o == nil || o.ItemsTotal.Get() == nil {
		var ret int32
		return ret
	}

	return *o.ItemsTotal.Get()
}

// GetItemsTotalOk returns a tuple with the ItemsTotal field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *BulkSession) GetItemsTotalOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.ItemsTotal.Get(), o.ItemsTotal.IsSet()
}

// SetItemsTotal sets field value
func (o *BulkSession) SetItemsTotal(v int32) {
	o.ItemsTotal.Set(&v)
}

// GetCreatedAt returns the CreatedAt field value
func (o *BulkSession) GetCreatedAt() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.CreatedAt
}

// GetCreatedAtOk returns a tuple with the CreatedAt field value
// and a boolean to check if the value has been set.
func (o *BulkSession) GetCreatedAtOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.CreatedAt, true
}

// SetCreatedAt sets field value
func (o *BulkSession) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetSession returns the Session field value
// If the value is explicit nil, the zero value for MessageSession will be returned
func (o *BulkSession) GetSession() MessageSession {
	if o == nil || o.Session.Get() == nil {
		var ret MessageSession
		return ret
	}

	return *o.Session.Get()
}

// GetSessionOk returns a tuple with the Session field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *BulkSession) GetSessionOk() (*MessageSession, bool) {
	if o == nil {
		return nil, false
	}
	return o.Session.Get(), o.Session.IsSet()
}

// SetSession sets field value
func (o *BulkSession) SetSession(v MessageSession) {
	o.Session.Set(&v)
}

// GetText returns the Text field value
// If the value is explicit nil, the zero value for string will be returned
func (o *BulkSession) GetText() string {
	if o == nil || o.Text.Get() == nil {
		var ret string
		return ret
	}

	return *o.Text.Get()
}

// GetTextOk returns a tuple with the Text field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *BulkSession) GetTextOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Text.Get(), o.Text.IsSet()
}

// SetText sets field value
func (o *BulkSession) SetText(v string) {
	o.Text.Set(&v)
}

func (o BulkSession) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o BulkSession) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["status"] = o.Status
	toSerialize["itemsProcessed"] = o.ItemsProcessed.Get()
	toSerialize["itemsTotal"] = o.ItemsTotal.Get()
	toSerialize["createdAt"] = o.CreatedAt
	toSerialize["session"] = o.Session.Get()
	toSerialize["text"] = o.Text.Get()
	return toSerialize, nil
}

func (o *BulkSession) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"status",
		"itemsProcessed",
		"itemsTotal",
		"createdAt",
		"session",
		"text",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varBulkSession := _BulkSession{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varBulkSession)

	if err != nil {
		return err
	}

	*o = BulkSession(varBulkSession)

	return err
}

type NullableBulkSession struct {
	value *BulkSession
	isSet bool
}

func (v NullableBulkSession) Get() *BulkSession {
	return v.value
}

func (v *NullableBulkSession) Set(val *BulkSession) {
	v.value = val
	v.isSet = true
}

func (v NullableBulkSession) IsSet() bool {
	return v.isSet
}

func (v *NullableBulkSession) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBulkSession(val *BulkSession) *NullableBulkSession {
	return &NullableBulkSession{value: val, isSet: true}
}

func (v NullableBulkSession) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBulkSession) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


