package keymap

import "github.com/reeflective/readline/inputrc"

// viinsKeys are the default keymaps in Vim Insert mode.
var viinsKeys = map[string]inputrc.Bind{
	unescape(`\M-`):    {Action: "vi-movement-mode"},
	unescape(`\C-M`):   {Action: "accept-line"},
	unescape(`\C-L`):   {Action: "clear-screen"},
	unescape(`\C-Y`):   {Action: "yank"},
	unescape(`\C-A`):   {Action: "beginning-of-line"},
	unescape(`\C-B`):   {Action: "backward-char"},
	unescape(`\C-F`):   {Action: "forward-char"},
	unescape(`\C-K`):   {Action: "kill-line"},
	unescape(`\C-N`):   {Action: "down-line-or-history"},
	unescape(`\C-O`):   {Action: "operate-and-get-next"},
	unescape(`\C-Q`):   {Action: "accept-and-infer-next-history"},
	unescape(`\C-P`):   {Action: "up-line-or-history"},
	unescape(`\C-_`):   {Action: "undo"},
	unescape(`\M-q`):   {Action: "macro-toggle-record"},
	unescape(`\M-r`):   {Action: "vi-registers-complete"},
	unescape(`\M-[3~`): {Action: "delete-char"},
	unescape(`\M-[H`):  {Action: "beginning-of-line"},
	unescape(`\M-[F`):  {Action: "end-of-line"},
	unescape(`\M-[A`):  {Action: "up-line-or-search"},
	unescape(`\M-[B`):  {Action: "down-line-or-search"},
	unescape(`\M-@`):   {Action: "macro-run"},
}

// viinsKeymaps are the default keymaps in Vim Command mode.
var vicmdKeys = map[string]inputrc.Bind{
	unescape(`\M-`):     {Action: "vi-movement-mode"},
	unescape(`\C-A`):    {Action: "switch-keyword"},
	unescape(`\C-L`):    {Action: "clear-screen"},
	unescape(`\C-M`):    {Action: "accept-line"},
	unescape(`\C-N`):    {Action: "next-history"},
	unescape(`\C-P`):    {Action: "previous-history"},
	unescape(`\C-X`):    {Action: "switch-keyword"},
	unescape(`\M-<`):    {Action: "beginning-of-buffer-or-history"},
	unescape(`\M->`):    {Action: "end-of-buffer-or-history"},
	unescape(`\M-'`):    {Action: "quote-line"},
	unescape(`\e[3~`):   {Action: "delete-char"},
	unescape(`\e[6~`):   {Action: "down-line-or-history"},
	unescape(`\e[5~`):   {Action: "up-line-or-history"},
	unescape(`\e[H`):    {Action: "beginning-of-line"},
	unescape(`\e[F`):    {Action: "end-of-line"},
	unescape(`\e[A`):    {Action: "history-search-backward"},
	unescape(`\e[B`):    {Action: "menu-select"},
	unescape(`\e[C`):    {Action: "vi-forward-char"},
	unescape(`\e[D`):    {Action: "vi-backward-char"},
	unescape(`\e[3;5~`): {Action: "kill-word"},
	unescape(`\e[1;5C`): {Action: "forward-word"},
	unescape(`\e[1;5D`): {Action: "backward-word"},
	unescape(" "):       {Action: "vi-forward-char"},
	unescape("$"):       {Action: "vi-end-of-line"},
	unescape("%"):       {Action: "vi-match"},
	unescape("\""):      {Action: "vi-set-buffer"},
	unescape("0"):       {Action: "beginning-of-line"},
	unescape("B"):       {Action: "vi-backward-bigword"},
	unescape("e"):       {Action: "vi-end-word"},
	unescape("E"):       {Action: "vi-end-bigword"},
	unescape("gg"):      {Action: "beginning-of-buffer-or-history"},
	unescape("ge"):      {Action: "vi-backward-end-word"},
	unescape("gE"):      {Action: "vi-backward-end-bigword"},
	unescape("gu"):      {Action: "vi-down-case"},
	unescape("gU"):      {Action: "vi-up-case"},
	unescape("f"):       {Action: "vi-find-next-char"},
	unescape("t"):       {Action: "vi-find-next-char-skip"},
	unescape("i"):       {Action: "vi-insertion-mode"},
	unescape("I"):       {Action: "vi-insert-beg"},
	unescape("h"):       {Action: "vi-backward-char"},
	unescape("l"):       {Action: "vi-forward-char"},
	unescape("j"):       {Action: "down-line-or-history"},
	unescape("k"):       {Action: "up-line-or-history"},
	unescape("n"):       {Action: "vi-search-again"},
	unescape("N"):       {Action: "vi-search-again"},
	unescape("O"):       {Action: "vi-open-line-above"},
	unescape("o"):       {Action: "vi-open-line-below"},
	unescape("p"):       {Action: "vi-put-after"},
	unescape("P"):       {Action: "vi-put-before"},
	unescape("q"):       {Action: "macro-toggle-record"},
	unescape("r"):       {Action: "vi-change-char"},
	unescape("R"):       {Action: "vi-replace"},
	unescape("F"):       {Action: "vi-find-prev-char"},
	unescape("T"):       {Action: "vi-find-prev-char-skip"},
	unescape("s"):       {Action: "vi-subst"},
	unescape("u"):       {Action: "vi-undo"},
	unescape("v"):       {Action: "vi-visual-mode"},
	unescape("V"):       {Action: "vi-visual-line-mode"},
	unescape("w"):       {Action: "vi-forward-word"},
	unescape("W"):       {Action: "vi-forward-bigword"},
	unescape("x"):       {Action: "vi-delete"},
	unescape("X"):       {Action: "vi-backward-delete-char"},
	unescape("y"):       {Action: "vi-yank-to"},
	unescape("Y"):       {Action: "vi-yank-whole-line"},
	unescape("|"):       {Action: "vi-column"},
	unescape("~"):       {Action: "vi-change-case"},
	unescape("@"):       {Action: "macro-run"},
}

// vioppKeys are the default keymaps in Vim Operating Pending mode.
var vioppKeys = map[string]inputrc.Bind{
	unescape(`\M-`): {Action: "vi-movement-mode"},
	unescape("a"):   {Action: "vi-select-inside"},
	unescape("aW"):  {Action: "select-a-blank-word"},
	unescape("aa"):  {Action: "select-a-shell-word"},
	unescape("aw"):  {Action: "select-a-word"},
	unescape("i"):   {Action: "vi-select-inside"},
	unescape("iW"):  {Action: "select-in-blank-word"},
	unescape("ia"):  {Action: "select-in-shell-word"},
	unescape("iw"):  {Action: "select-in-word"},
	unescape("s"):   {Action: "vi-select-surround"},
	unescape("j"):   {Action: "down-line"},
	unescape("k"):   {Action: "up-line"},
}

// visualKeys are the default keymaps in Vim Visual mode.
var visualKeys = map[string]inputrc.Bind{
	unescape(`\M-`): {Action: "vi-movement-mode"},
	unescape("aW"):  {Action: "select-a-blank-word"},
	unescape("aa"):  {Action: "select-a-shell-word"},
	unescape("aw"):  {Action: "select-a-word"},
	unescape("iW"):  {Action: "select-in-blank-word"},
	unescape("ia"):  {Action: "select-in-shell-word"},
	unescape("iw"):  {Action: "select-in-word"},
	unescape("a"):   {Action: "vi-select-inside"},
	unescape("c"):   {Action: "vi-change-to"},
	unescape("d"):   {Action: "vi-delete-to"},
	unescape("i"):   {Action: "vi-select-inside"},
	unescape("j"):   {Action: "next-screen-line"},
	unescape("k"):   {Action: "previous-screen-line"},
	unescape("s"):   {Action: "vi-subst"},
	unescape("S"):   {Action: "vi-add-surround"},
	unescape("u"):   {Action: "vi-down-case"},
	unescape("v"):   {Action: "vi-edit-command-line"},
	unescape("x"):   {Action: "vi-delete-to"},
	unescape("y"):   {Action: "vi-yank-to"},
	unescape("~"):   {Action: "vi-swap-case"},
}
