// Package inboxready provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.4.2-0.20250511101814-8ea9351bbd3e DO NOT EDIT.
package inboxready

import (
	"time"

	openapi_types "github.com/oapi-codegen/runtime/types"
)

const (
	BasicAuthScopes = "basicAuth.Scopes"
)

// InboxReadyGithubComMailgunInboxreadyAPIAddDomainResponse defines model for Inbox_Ready_github.com-mailgun-inboxready-api-AddDomainResponse.
type InboxReadyGithubComMailgunInboxreadyAPIAddDomainResponse struct {
	Domain  InboxReadyGithubComMailgunInboxreadyModelDomain `json:"domain"`
	Message string                                          `json:"message"`
}

// InboxReadyGithubComMailgunInboxreadyAPICreateIPAddressReq defines model for Inbox_Ready_github.com-mailgun-inboxready-api-CreateIPAddressReq.
type InboxReadyGithubComMailgunInboxreadyAPICreateIPAddressReq struct {
	Description string `json:"description"`
	IP          string `json:"ip"`
	IPPool      string `json:"ip_pool"`
}

// InboxReadyGithubComMailgunInboxreadyAPIDeleteDomainResponse defines model for Inbox_Ready_github.com-mailgun-inboxready-api-DeleteDomainResponse.
type InboxReadyGithubComMailgunInboxreadyAPIDeleteDomainResponse struct {
	Message string `json:"message"`
}

// InboxReadyGithubComMailgunInboxreadyAPIDomainListResponse defines model for Inbox_Ready_github.com-mailgun-inboxready-api-DomainListResponse.
type InboxReadyGithubComMailgunInboxreadyAPIDomainListResponse struct {
	Items  []InboxReadyGithubComMailgunInboxreadyModelDomain              `json:"items"`
	Paging *InboxReadyGithubComMailgunScaffoldHttpapiPagingPagingResponse `json:"paging,omitempty"`
}

// InboxReadyGithubComMailgunInboxreadyAPIInboxReadyVerifyDomainResponse defines model for Inbox_Ready_github.com-mailgun-inboxready-api-InboxReadyVerifyDomainResponse.
type InboxReadyGithubComMailgunInboxreadyAPIInboxReadyVerifyDomainResponse struct {
	Message string `json:"message"`
}

// InboxReadyGithubComMailgunInboxreadyAPIListIPAddressesResp defines model for Inbox_Ready_github.com-mailgun-inboxready-api-ListIPAddressesResp.
type InboxReadyGithubComMailgunInboxreadyAPIListIPAddressesResp struct {
	Items []InboxReadyGithubComMailgunInboxreadyClientsMedicIPAddress `json:"items"`
}

// InboxReadyGithubComMailgunInboxreadyAPIUpdateIPAddressReq defines model for Inbox_Ready_github.com-mailgun-inboxready-api-UpdateIPAddressReq.
type InboxReadyGithubComMailgunInboxreadyAPIUpdateIPAddressReq struct {
	Description string `json:"description"`
	IPPool      string `json:"ip_pool"`
}

// InboxReadyGithubComMailgunInboxreadyClientsMedicBlacklist defines model for Inbox_Ready_github.com-mailgun-inboxready-clients-medic-Blacklist.
type InboxReadyGithubComMailgunInboxreadyClientsMedicBlacklist struct {
	Comments          []string   `json:"comments"`
	DelistRequestedAt time.Time  `json:"delist_requested_at"`
	FirstSeen         *time.Time `json:"first_seen,omitempty"`
	LastSeen          time.Time  `json:"last_seen"`
	List              string     `json:"list"`
	Name              *string    `json:"name,omitempty"`
}

// InboxReadyGithubComMailgunInboxreadyClientsMedicIPAddress defines model for Inbox_Ready_github.com-mailgun-inboxready-clients-medic-IPAddress.
type InboxReadyGithubComMailgunInboxreadyClientsMedicIPAddress struct {
	Description string                                                      `json:"description"`
	IP          string                                                      `json:"ip"`
	IPPool      string                                                      `json:"ip_pool"`
	Listed      []InboxReadyGithubComMailgunInboxreadyClientsMedicBlacklist `json:"listed"`
	State       string                                                      `json:"state"`
}

// InboxReadyGithubComMailgunInboxreadyModelDomain defines model for Inbox_Ready_github.com-mailgun-inboxready-model-Domain.
type InboxReadyGithubComMailgunInboxreadyModelDomain struct {
	CreatedAt int64                                             `json:"created_at"`
	Name      string                                            `json:"name"`
	Services  map[string]bool                                   `json:"services"`
	TxtRecord string                                            `json:"txt_record"`
	Verified  InboxReadyGithubComMailgunInboxreadyModelVerified `json:"verified"`
}

// InboxReadyGithubComMailgunInboxreadyModelVerified defines model for Inbox_Ready_github.com-mailgun-inboxready-model-Verified.
type InboxReadyGithubComMailgunInboxreadyModelVerified struct {
	Status     string `json:"status"`
	VerifiedAt int64  `json:"verified_at"`
}

// InboxReadyGithubComMailgunScaffoldHttpapiGenericAPIError defines model for Inbox_Ready_github.com-mailgun-scaffold-httpapi-GenericAPIError.
type InboxReadyGithubComMailgunScaffoldHttpapiGenericAPIError struct {
	Reason string `json:"Reason"`
}

// InboxReadyGithubComMailgunScaffoldHttpapiGenericResponse defines model for Inbox_Ready_github.com-mailgun-scaffold-httpapi-GenericResponse.
type InboxReadyGithubComMailgunScaffoldHttpapiGenericResponse struct {
	Message string `json:"message"`
}

// InboxReadyGithubComMailgunScaffoldHttpapiPagingPagingResponse defines model for Inbox_Ready_github.com-mailgun-scaffold-httpapi-paging-PagingResponse.
type InboxReadyGithubComMailgunScaffoldHttpapiPagingPagingResponse struct {
	First    string `json:"first"`
	Last     string `json:"last"`
	Next     string `json:"next"`
	Previous string `json:"previous"`
}

// GithubComMailgunAlertsInternalAPIListAlertsEventsResp defines model for github.com-mailgun-alerts-internal-api-ListAlertsEventsResp.
type GithubComMailgunAlertsInternalAPIListAlertsEventsResp struct {
	Events []string `json:"events"`
}

// GithubComMailgunAlertsInternalAPIListSlackChannelsResp defines model for github.com-mailgun-alerts-internal-api-ListSlackChannelsResp.
type GithubComMailgunAlertsInternalAPIListSlackChannelsResp struct {
	Items []GithubComMailgunAlertsInternalAPISlackChannel `json:"items"`
}

// GithubComMailgunAlertsInternalAPIResetWebhooksSigningKeyResp defines model for github.com-mailgun-alerts-internal-api-ResetWebhooksSigningKeyResp.
type GithubComMailgunAlertsInternalAPIResetWebhooksSigningKeyResp struct {
	SigningKey string `json:"signing_key"`
}

// GithubComMailgunAlertsInternalAPISettingsResponse defines model for github.com-mailgun-alerts-internal-api-SettingsResponse.
type GithubComMailgunAlertsInternalAPISettingsResponse struct {
	Events   []GithubComMailgunAlertsInternalSettingsEventSettings `json:"events"`
	Slack    GithubComMailgunAlertsInternalSettingsSlack           `json:"slack"`
	Webhooks GithubComMailgunAlertsInternalSettingsWebhooks        `json:"webhooks"`
}

// GithubComMailgunAlertsInternalAPISlackChannel defines model for github.com-mailgun-alerts-internal-api-SlackChannel.
type GithubComMailgunAlertsInternalAPISlackChannel struct {
	ID         string `json:"id"`
	IsArchived bool   `json:"is_archived"`
	Name       string `json:"name"`
}

// GithubComMailgunAlertsInternalAPITestEmailRequest defines model for github.com-mailgun-alerts-internal-api-TestEmailRequest.
type GithubComMailgunAlertsInternalAPITestEmailRequest struct {
	Emails    []string `json:"emails"`
	EventType string   `json:"event_type"`
}

// GithubComMailgunAlertsInternalAPITestSlackRequest defines model for github.com-mailgun-alerts-internal-api-TestSlackRequest.
type GithubComMailgunAlertsInternalAPITestSlackRequest struct {
	// ChannelIDs If omitted would be taken from the event settings
	ChannelIDs []string `json:"channel_ids,omitempty"`
	EventType  string   `json:"event_type"`
}

// GithubComMailgunAlertsInternalAPITestWebhookRequest defines model for github.com-mailgun-alerts-internal-api-TestWebhookRequest.
type GithubComMailgunAlertsInternalAPITestWebhookRequest struct {
	EventType string `json:"event_type"`
	URL       string `json:"url"`
}

// GithubComMailgunAlertsInternalAPIMutateEventSettingReq defines model for github.com-mailgun-alerts-internal-api-mutateEventSettingReq.
type GithubComMailgunAlertsInternalAPIMutateEventSettingReq struct {
	// Channel The delivery method for the alert. Supported values include 'webhook'
	Channel string `json:"channel"`

	// EventType The type of event for which you would like to receive alerts.
	EventType string `json:"event_type"`

	// Settings The details pertaining to the specified channel. Please note that the contents of this object differ per channel type.
	Settings GithubComMailgunAlertsInternalSettingsChannelSettings `json:"settings"`
}

// GithubComMailgunAlertsInternalSettingsChannelSettings defines model for github.com-mailgun-alerts-internal-settings-ChannelSettings.
type GithubComMailgunAlertsInternalSettingsChannelSettings struct {
	// ChannelIDs For slack channel
	ChannelIDs []string `json:"channel_ids,omitempty"`

	// Emails For email channel
	Emails []string `json:"emails,omitempty"`

	// URL For webhook channel.
	URL *string `json:"url,omitempty"`
}

// GithubComMailgunAlertsInternalSettingsEventSettings defines model for github.com-mailgun-alerts-internal-settings-EventSettings.
type GithubComMailgunAlertsInternalSettingsEventSettings struct {
	// Channel The delivery channel for the alert.
	Channel string `json:"channel"`

	// DisabledAt Read only. When present
	DisabledAt *time.Time `json:"disabled_at"`

	// EventType The event type that is alerted on.
	EventType string `json:"event_type"`

	// ID The unique identifier for the alert settings record.
	ID *openapi_types.UUID `json:"id,omitempty"`

	// Settings This object contains channel-specific settings.
	Settings GithubComMailgunAlertsInternalSettingsChannelSettings `json:"settings"`
}

// GithubComMailgunAlertsInternalSettingsSlack defines model for github.com-mailgun-alerts-internal-settings-Slack.
type GithubComMailgunAlertsInternalSettingsSlack struct {
	Scope    *string `json:"scope"`
	TeamID   *string `json:"team_id"`
	TeamName *string `json:"team_name"`
	Token    string  `json:"token"`
}

// GithubComMailgunAlertsInternalSettingsWebhooks defines model for github.com-mailgun-alerts-internal-settings-Webhooks.
type GithubComMailgunAlertsInternalSettingsWebhooks struct {
	SigningKey string `json:"signing_key"`
}

// GithubComMailgunScaffoldHttpapiGenericResponse defines model for github.com-mailgun-scaffold-httpapi-GenericResponse.
type GithubComMailgunScaffoldHttpapiGenericResponse struct {
	Message string `json:"message"`
}

// DELETEV1InboxreadyDomainsParams defines parameters for DELETEV1InboxreadyDomains.
type DELETEV1InboxreadyDomainsParams struct {
	// Domain Domain name
	Domain string `form:"domain" json:"domain"`
}

// GETV1InboxreadyDomainsParams defines parameters for GETV1InboxreadyDomains.
type GETV1InboxreadyDomainsParams struct {
	// Limit Limit
	Limit *int `form:"limit,omitempty" json:"limit,omitempty"`

	// Domain Domain name
	Domain *string `form:"domain,omitempty" json:"domain,omitempty"`
}

// POSTV1InboxreadyDomainsParams defines parameters for POSTV1InboxreadyDomains.
type POSTV1InboxreadyDomainsParams struct {
	// Domain Domain name
	Domain string `form:"domain" json:"domain"`
}

// PUTV1InboxreadyDomainsVerifyParams defines parameters for PUTV1InboxreadyDomainsVerify.
type PUTV1InboxreadyDomainsVerifyParams struct {
	// Domain Domain name
	Domain string `form:"domain" json:"domain"`
}

// GETV1InboxreadyIPAddressesParams defines parameters for GETV1InboxreadyIPAddresses.
type GETV1InboxreadyIPAddressesParams struct {
	// Limit Limit
	Limit *int `form:"limit,omitempty" json:"limit,omitempty"`
}

// POSTV1AlertsEmailTestJSONRequestBody defines body for POSTV1AlertsEmailTest for application/json ContentType.
type POSTV1AlertsEmailTestJSONRequestBody = GithubComMailgunAlertsInternalAPITestEmailRequest

// POSTV1AlertsSettingsEventsJSONRequestBody defines body for POSTV1AlertsSettingsEvents for application/json ContentType.
type POSTV1AlertsSettingsEventsJSONRequestBody = GithubComMailgunAlertsInternalAPIMutateEventSettingReq

// PUTV1AlertsSettingsEventsIDJSONRequestBody defines body for PUTV1AlertsSettingsEventsID for application/json ContentType.
type PUTV1AlertsSettingsEventsIDJSONRequestBody = GithubComMailgunAlertsInternalAPIMutateEventSettingReq

// PUTV1AlertsSettingsSlackJSONRequestBody defines body for PUTV1AlertsSettingsSlack for application/json ContentType.
type PUTV1AlertsSettingsSlackJSONRequestBody = GithubComMailgunAlertsInternalSettingsSlack

// POSTV1AlertsSlackTestJSONRequestBody defines body for POSTV1AlertsSlackTest for application/json ContentType.
type POSTV1AlertsSlackTestJSONRequestBody = GithubComMailgunAlertsInternalAPITestSlackRequest

// POSTV1AlertsWebhooksTestJSONRequestBody defines body for POSTV1AlertsWebhooksTest for application/json ContentType.
type POSTV1AlertsWebhooksTestJSONRequestBody = GithubComMailgunAlertsInternalAPITestWebhookRequest

// POSTV1InboxreadyIPAddressesJSONRequestBody defines body for POSTV1InboxreadyIPAddresses for application/json ContentType.
type POSTV1InboxreadyIPAddressesJSONRequestBody = InboxReadyGithubComMailgunInboxreadyAPICreateIPAddressReq

// PUTV1InboxreadyIPAddressesIPJSONRequestBody defines body for PUTV1InboxreadyIPAddressesIP for application/json ContentType.
type PUTV1InboxreadyIPAddressesIPJSONRequestBody = InboxReadyGithubComMailgunInboxreadyAPIUpdateIPAddressReq
