% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_logarithmic.R
\name{dist_logarithmic}
\alias{dist_logarithmic}
\title{The Logarithmic distribution}
\usage{
dist_logarithmic(prob)
}
\arguments{
\item{prob}{parameter. \code{0 <= prob < 1}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The Logarithmic distribution is a discrete probability distribution
derived from the logarithmic series. It is useful in modeling the
abundance of species and other phenomena where the frequency of
an event follows a logarithmic pattern.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_logarithmic.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_logarithmic.html}

In the following, let \eqn{X} be a Logarithmic random variable with
parameter \code{prob} = \eqn{p}.

\strong{Support}: \eqn{\{1, 2, 3, ...\}}{{1, 2, 3, ...}}

\strong{Mean}: \eqn{\frac{-1}{\log(1-p)} \cdot \frac{p}{1-p}}{-1/log(1-p) * p/(1-p)}

\strong{Variance}: \eqn{\frac{-(p^2 + p\log(1-p))}{[(1-p)\log(1-p)]^2}}{-(p^2 + p*log(1-p))/((1-p)*log(1-p))^2}

\strong{Probability mass function (p.m.f)}:

\deqn{
    P(X = k) = \frac{-1}{\log(1-p)} \cdot \frac{p^k}{k}
  }{
    P(X = k) = -1/log(1-p) * p^k/k
  }

for \eqn{k = 1, 2, 3, \ldots}{k = 1, 2, 3, ...}

\strong{Cumulative distribution function (c.d.f)}:

The c.d.f. does not have a simple closed form. It is computed
using the recurrence relationship
\eqn{P(X = k+1) = \frac{p \cdot k}{k+1} \cdot P(X = k)}{P(X = k+1) = (p*k)/(k+1) * P(X = k)}
starting from \eqn{P(X = 1) = \frac{-p}{\log(1-p)}}{P(X = 1) = -p/log(1-p)}.

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \frac{\log(1 - pe^t)}{\log(1-p)}
  }{
    E(e^(tX)) = log(1 - p*e^t)/log(1-p)
  }

for \eqn{pe^t < 1}{p*e^t < 1}
}
\examples{
dist <- dist_logarithmic(prob = c(0.33, 0.66, 0.99))
dist

\dontshow{if (requireNamespace("actuar", quietly = TRUE)) withAutoprint(\{ # examplesIf}
mean(dist)
variance(dist)
support(dist)
generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)
\dontshow{\}) # examplesIf}
}
\seealso{
\link[actuar:Logarithmic]{actuar::Logarithmic}
}
