# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterDefenderForStorageOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_defender_for_storage_get(self, resource_group):
        response = await self.client.defender_for_storage.get(
            resource_id="str",
            setting_name="str",
            api_version="2025-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_defender_for_storage_create(self, resource_group):
        response = await self.client.defender_for_storage.create(
            resource_id="str",
            setting_name="str",
            defender_for_storage_setting={
                "id": "str",
                "name": "str",
                "properties": {
                    "isEnabled": bool,
                    "malwareScanning": {
                        "blobScanResultsOptions": "str",
                        "onUpload": {
                            "capGBPerMonth": 0,
                            "filters": {
                                "excludeBlobsLargerThan": {},
                                "excludeBlobsWithPrefix": ["str"],
                                "excludeBlobsWithSuffix": ["str"],
                            },
                            "isEnabled": bool,
                        },
                        "operationStatus": {"code": "str", "message": "str"},
                        "scanResultsEventGridTopicResourceId": "str",
                    },
                    "overrideSubscriptionLevelSettings": bool,
                    "sensitiveDataDiscovery": {"isEnabled": bool, "operationStatus": {"code": "str", "message": "str"}},
                },
                "type": "str",
            },
            api_version="2025-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_defender_for_storage_start_malware_scan(self, resource_group):
        response = await self.client.defender_for_storage.start_malware_scan(
            resource_id="str",
            setting_name="str",
            api_version="2025-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_defender_for_storage_cancel_malware_scan(self, resource_group):
        response = await self.client.defender_for_storage.cancel_malware_scan(
            resource_id="str",
            setting_name="str",
            scan_id="str",
            api_version="2025-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_defender_for_storage_get_malware_scan(self, resource_group):
        response = await self.client.defender_for_storage.get_malware_scan(
            resource_id="str",
            setting_name="str",
            scan_id="str",
            api_version="2025-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...
