from pathlib import Path
from setuptools import find_packages, setup

README_PATH = Path(__file__).parent / "README.md"

with README_PATH.open(encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="pyexploitdb",
    version="0.3.11",
    author="Shane William Scott",
    author_email="shane@shanewilliamscott.com",
    description="""An optimized Python3 library to fetch the most recent exploit-database,
                   create searchable indexes for CVE->EDBID and EDBID -> CVE, and provide
                   methods to perform searches.""",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/Hackman238/pyExploitDb",
    project_urls={
        "Source": "https://github.com/Hackman238/pyExploitDb",
        "Issue Tracker": "https://github.com/Hackman238/pyExploitDb/issues",
    },
    license="GPL-3.0-only",
    packages=find_packages(exclude=("tests", "tests.*")),
    package_data={"pyexploitdb": ["*.json"]},
    install_requires=["GitPython>=3.1", "requests>=2.28"],
    python_requires=">=3.10",
    zip_safe=False,
    classifiers=(
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Operating System :: OS Independent",
    ),
)
