/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.turbine.util.Log;
import org.chefproject.core.Event;
import org.chefproject.core.UserEdit;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.util.Cache;
import org.chefproject.util.CacheRefresher;
import org.chefproject.util.StringUtil;

public class UmiacClient
implements CacheRefresher {
    public static final boolean TEST = false;
    protected int m_port;
    protected String m_host;
    protected Cache m_callCache = null;
    protected Hashtable m_userNames = new Hashtable();
    protected Hashtable m_userSortNames = new Hashtable();
    protected static UmiacClient M_instance;

    public static UmiacClient getInstance() {
        if (M_instance == null) {
            new UmiacClient();
        }
        return M_instance;
    }

    protected UmiacClient() {
        this("umiac-cluster1.ns.itd.umich.edu", 8888);
    }

    protected UmiacClient(String host, int port) {
        this.m_host = host;
        this.m_port = port;
        this.m_callCache = new Cache((CacheRefresher)this, 900L);
        if (M_instance == null) {
            M_instance = this;
        }
    }

    protected void finalize() {
        if (this == M_instance) {
            M_instance = null;
        }
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setUserNames(UserEdit edit) throws IdUnusedException {
        if (!this.userExists(edit.getId())) {
            throw new IdUnusedException(edit.getId());
        }
        String name = (String)this.m_userNames.get(edit.getId());
        String[] parts = StringUtil.split(name, " ");
        edit.setLastName(parts[parts.length - 1]);
        if (parts.length >= 2) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < parts.length - 2) {
                buf.append(parts[i]);
                buf.append(" ");
                ++i;
            }
            buf.append(parts[parts.length - 2]);
            edit.setFirstName(buf.toString());
        }
    }

    public boolean userExists(String id) {
        String name = (String)this.m_userNames.get(id);
        if (name == null) {
            String command = "getUserInfo," + id;
            Vector result = this.makeCall(command);
            if (result == null || result.size() != 1 || ((String)result.elementAt(0)).indexOf("|") == -1) {
                return false;
            }
            String[] res = StringUtil.split((String)result.elementAt(0), "|");
            name = res[1];
            this.m_userNames.put(id, name);
        }
        return true;
    }

    public String getGroupName(String id) throws IdUnusedException {
        String command = "getClassInfo," + id;
        Vector result = this.makeCall(command);
        if (result == null || result.size() < 1 || ((String)result.elementAt(0)).indexOf("|") == -1) {
            throw new IdUnusedException(id);
        }
        String[] res = StringUtil.split((String)result.elementAt(0), "|");
        String name = res[2];
        return name;
    }

    public Map getGroupRoles(String id) throws IdUnusedException {
        String command = "getClasslist," + id;
        Vector result = this.makeCall(command);
        if (result == null || result.size() < 1 || ((String)result.elementAt(0)).indexOf("|") == -1) {
            throw new IdUnusedException(id);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < result.size()) {
            String[] res = StringUtil.split((String)result.elementAt(i), "|");
            String uid = res[1].toLowerCase();
            String role = res[5];
            map.put(uid, role);
            ++i;
        }
        return map;
    }

    public Map getGroupRoles(String[] id) throws IdUnusedException {
        StringBuffer command = new StringBuffer();
        command.append("getGroupMemberships");
        int i = 0;
        while (i < id.length) {
            command.append(",");
            String[] parts = StringUtil.split(id[i], ",");
            command.append(parts[0]);
            int p = 1;
            while (p < parts.length) {
                command.append("|");
                command.append(parts[p]);
                ++p;
            }
            ++i;
        }
        Vector result = this.makeCall(command.toString());
        if (result == null || result.size() < 1 || ((String)result.elementAt(0)).indexOf("|") == -1) {
            throw new IdUnusedException(id[0]);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int i2 = 0;
        while (i2 < result.size()) {
            String[] res = StringUtil.split((String)result.elementAt(i2), "|");
            String uid = res[3].toLowerCase();
            String role = res[6];
            this.m_userNames.put(uid, res[1]);
            this.m_userSortNames.put(uid, res[2]);
            String roleAlready = (String)map.get(uid);
            if (roleAlready == null || roleAlready.equals("Student") && role.equals("Instructor")) {
                map.put(uid, role);
            }
            ++i2;
        }
        return map;
    }

    public Vector getClassList(String year, String term, String campus, String subject, String course, String section) throws IdUnusedException {
        String command = "getClasslist," + year + "," + term + "," + campus + "," + subject + "," + course + "," + section + "\n\n";
        Vector result = this.makeCall(command);
        if (result == null || result.size() < 1) {
            throw new IdUnusedException(year + "," + term + "," + campus + "," + subject + "," + course + "," + section);
        }
        Vector<String[]> rv = new Vector<String[]>();
        int i = 0;
        while (i < result.size()) {
            String[] res = StringUtil.split((String)result.elementAt(i), "|");
            rv.add(res);
            ++i;
        }
        return rv;
    }

    public Vector getInstructorSections(String id, String term_year, String term) throws IdUnusedException {
        String command = "getInstructorSections," + id + "," + term_year + "," + term + "\n\n";
        Vector result = this.makeCall(command);
        if (result == null || result.size() < 1) {
            throw new IdUnusedException(id);
        }
        Vector<String[]> rv = new Vector<String[]>();
        int i = 0;
        while (i < result.size()) {
            String[] res = StringUtil.split((String)result.elementAt(i), "|");
            rv.add(res);
            ++i;
        }
        return rv;
    }

    public Vector getInstructorClassess(String id, String term_year, String term) throws IdUnusedException {
        String command = "getInstructorClasses," + id + "," + term_year + "," + term + "\n\n";
        Vector result = this.makeCall(command);
        if (result == null || result.size() < 1) {
            throw new IdUnusedException(id);
        }
        Vector<String[]> rv = new Vector<String[]>();
        int i = 0;
        while (i < result.size()) {
            String[] res = StringUtil.split((String)result.elementAt(i), "|");
            rv.add(res);
            ++i;
        }
        return rv;
    }

    public Vector makeCall(String umiacCommand) {
        if (this.m_callCache != null && this.m_callCache.containsKeyExpiredOrNot(umiacCommand)) {
            return (Vector)this.m_callCache.getExpiredOrNot(umiacCommand);
        }
        Vector v = this.makeRawCall(umiacCommand);
        if (this.m_callCache != null) {
            this.m_callCache.put(umiacCommand, v, 3600);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Vector makeRawCall(String umiacCommand) {
        block20: {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".makeCall: " + umiacCommand);
            }
            out = null;
            in = null;
            socket = null;
            v = new Vector<String>();
            socket = new Socket(this.m_host, this.m_port);
            out = new PrintWriter(socket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.println(umiacCommand);
            inString = in.readLine();
            if (true) ** GOTO lbl19
            do {
                v.add(inString);
                inString = in.readLine();
lbl19:
                // 2 sources

                if (inString == null) break;
            } while (!inString.equalsIgnoreCase("EOT"));
            var8_8 = null;
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                if (socket != null) {
                    socket.close();
                }
                break block20;
            }
            catch (Exception ignore) {}
            break block20;
            {
                catch (IOException e) {
                    var8_9 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                        if (socket != null) {
                            socket.close();
                        }
                        break block20;
                    }
                    catch (Exception ignore) {}
                }
            }
            catch (Throwable var7_14) {
                var8_10 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw var7_14;
            }
        }
        return v;
    }

    public Object refresh(Object key, Object oldValue, Event event) {
        return this.makeRawCall((String)key);
    }

    static {
        TEST = false;
        M_instance = null;
    }
}

