module ExploitDataProxy

  def report_exploit_attempt(host, opts)
    begin
      self.data_service_operation do |data_service|
        data_service.report_exploit_attempt(host, opts)
      end
    rescue => e
      self.log_error(e, "Problem reporting exploit attempt")
    end
  end

  def report_exploit_failure(opts)
    begin
      self.data_service_operation do |data_service|
        add_opts_workspace(opts)
        data_service.report_exploit_failure(opts)
      end
    rescue => e
      self.log_error(e, "Problem reporting exploit failure")
    end
  end

  def report_exploit_success(opts)
    begin
      self.data_service_operation do |data_service|
        add_opts_workspace(opts)
        data_service.report_exploit_success(opts)
      end
    rescue => e
      self.log_error(e, "Problem reporting exploit success")
    end
  end
end