/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.tree.CellEditorNode;
import com.jsql.view.swing.tree.CellRendererNode;
import com.jsql.view.swing.tree.TreeDatabase;
import com.jsql.view.swing.tree.model.AbstractNodeModel;
import com.jsql.view.swing.tree.model.NodeModelEmpty;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManagerDatabase
extends JPanel {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final TreeDatabase tree;

    public ManagerDatabase() {
        super(new BorderLayout());
        NodeModelEmpty nodeModelEmpty = new NodeModelEmpty(I18nViewUtil.valueByKey("DATABASE_EMPTY"));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(nodeModelEmpty);
        I18nViewUtil.addComponentForKey("DATABASE_EMPTY", nodeModelEmpty);
        this.tree = new TreeDatabase(root);
        this.tree.setName("treeDatabases");
        MediatorHelper.register(this.tree);
        this.tree.setCellRenderer(new CellRendererNode());
        this.tree.addMouseListener(this.getTreeMouseListener());
        this.tree.addKeyListener(this.getTreeKeyListener());
        this.tree.setCellEditor(new CellEditorNode());
        this.tree.setEditable(true);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.getModel().addTreeModelListener(new TreeModelProgressListener());
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    private KeyAdapter getTreeKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AbstractNodeModel nodeModel;
                DefaultMutableTreeNode treeNode;
                if (e.getKeyCode() == 113 && (treeNode = (DefaultMutableTreeNode)ManagerDatabase.this.tree.getLastSelectedPathComponent()) != null && (nodeModel = (AbstractNodeModel)treeNode.getUserObject()) != null && nodeModel.getPanel() != null && !nodeModel.isRunning()) {
                    nodeModel.setIsEdited(true);
                }
            }
        };
    }

    private MouseAdapter getTreeMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                int selRow = ManagerDatabase.this.tree.getRowForLocation(event.getX(), event.getY());
                TreePath selPath = ManagerDatabase.this.tree.getPathForLocation(event.getX(), event.getY());
                if (selRow != -1 && event.getClickCount() == 2) {
                    try {
                        if (ManagerDatabase.this.tree.isExpanded(selPath)) {
                            ManagerDatabase.this.tree.collapsePath(selPath);
                        } else {
                            ManagerDatabase.this.tree.expandPath(selPath);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
                    }
                }
            }
        };
    }

    private class TreeModelProgressListener
    implements TreeModelListener {
        private TreeModelProgressListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent == null) {
                return;
            }
            ManagerDatabase.this.tree.firePropertyChange("rootVisible", !ManagerDatabase.this.tree.isRootVisible(), ManagerDatabase.this.tree.isRootVisible());
            ManagerDatabase.this.tree.treeDidChange();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }
    }
}

