---
created: 2020-11-30T14:59:37.000+00:00
source_url: https://www.patreon.com/posts/plugin-support-4-44478322
---

# Plugin support available in Joplin v1.4

The plugin system has been part of Joplin since the previous version, however it was still a bit unstable. In the latest version we're getting a bit closer to production-ready state. The [plugin API](https://github.com/laurent22/joplin/blob/dev/readme/api/index.md) in particular has been significantly expanded, based on the developer feedback, so that more types of plugin are possible now, and indeed a few plugin concepts have started appearing on the forums. In particular all this could be done now:

- Access notes, folders, etc. via the data API
- Add a view to display custom data using HTML/CSS/JS
- Create a dialog to display information and get input from the user
- Create a new command and associate a toolbar button or menu item with it
- Get access to the note currently being edited and modify it
- Listen to various events and run code when they happen
- Hook into the application to set additional options and customise Joplin's behaviour
- Create a module to export or import data into Joplin
- Define new settings and setting sections, and get/set them from the plugin
- Create a new Markdown plugin to render custom markup.
- Create an editor plugin to modify low-level the behaviour of the Markdown editor (CodeMirror)

**Plugin JPL format and configuration screen**

The plugin configuration screen has also been updated so that it's possible to import the new JPL (**J**oplin **PL**ugin) format and to enable/disable as well as uninstall plugins.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20201130-145937_0.png)

**What's next?**

It is now possible to create new plugins, package them into the JPL format, and to install them into the app.

The last piece missing is a way to discover and share plugins, and a way to update them easily, basically what we need is an online package manager. It is not clear yet how this is going to be done, but one idea would be to have a GitHub repository where anyone could submit or update a plugin, then the app would connect to that repository to make it easy to install new plugins. This is just an idea at this point though, and if you have any suggestion on other ways it could be done, feel free to let me know. A [discussion about it](https://discourse.joplinapp.org/t/plugin-repository/12692) has been started in the forum.