const baseConfig = require('../../jest.config.base.js');

module.exports = {
	...baseConfig,

	'moduleFileExtensions': [
		'ts',
		'tsx',
		'js',
	],

	testEnvironment: 'node',

	'transform': {
		'\\.(ts|tsx)$': 'ts-jest',
	},

	testMatch: ['**/*.test.(ts|tsx)'],

	testPathIgnorePatterns: ['<rootDir>/node_modules/'],

	slowTestThreshold: 40,

	setupFilesAfterEnv: [`${__dirname}/jest.setup.js`],
};
