//--------------------------------------------------
// ImPlot3D v0.3 WIP
// implot3d_meshes.cpp
// Date: 2024-12-07
// Author: Breno Cunha Queiroz (brenocq.com)
//
// Acknowledgments:
//  ImPlot3D is heavily inspired by ImPlot
//  (https://github.com/epezent/implot) by Evan Pezent,
//  and follows a similar code style and structure to
//  maintain consistency with ImPlot's API.
//--------------------------------------------------

// Table of Contents:
// [SECTION] Includes
// [SECTION] Cube
// [SECTION] Sphere
// [SECTION] Duck

//-----------------------------------------------------------------------------
// [SECTION] Includes
//-----------------------------------------------------------------------------

#include "implot3d.h"

//-----------------------------------------------------------------------------
// [SECTION] Cube
//-----------------------------------------------------------------------------

namespace ImPlot3D {

// clang-format off
ImPlot3DPoint cube_vtx[CUBE_VTX_COUNT] = {
    {-1.0f, -1.0f, -1.0f}, // 0: Bottom-back-left
    { 1.0f, -1.0f, -1.0f}, // 1: Bottom-back-right
    { 1.0f,  1.0f, -1.0f}, // 2: Top-back-right
    {-1.0f,  1.0f, -1.0f}, // 3: Top-back-left
    {-1.0f, -1.0f,  1.0f}, // 4: Bottom-front-left
    { 1.0f, -1.0f,  1.0f}, // 5: Bottom-front-right
    { 1.0f,  1.0f,  1.0f}, // 6: Top-front-right
    {-1.0f,  1.0f,  1.0f}, // 7: Top-front-left
};

unsigned int cube_idx[CUBE_IDX_COUNT] = {
    // Back face
    0, 1, 2,
    0, 2, 3,
    // Front face
    4, 5, 6,
    4, 6, 7,
    // Left face
    0, 3, 7,
    0, 7, 4,
    // Right face
    1, 5, 6,
    1, 6, 2,
    // Top face
    3, 2, 6,
    3, 6, 7,
    // Bottom face
    0, 1, 5,
    0, 5, 4,
};
// clang-format on

//-----------------------------------------------------------------------------
// [SECTION] Sphere
//-----------------------------------------------------------------------------

ImPlot3DPoint sphere_vtx[SPHERE_VTX_COUNT] = {
    {-0.525731f, 0.850651f, 0.000000f},   {0.525731f, 0.850651f, 0.000000f},    {-0.525731f, -0.850651f, 0.000000f},
    {0.525731f, -0.850651f, 0.000000f},   {0.000000f, -0.525731f, 0.850651f},   {0.000000f, 0.525731f, 0.850651f},
    {0.000000f, -0.525731f, -0.850651f},  {0.000000f, 0.525731f, -0.850651f},   {0.850651f, 0.000000f, -0.525731f},
    {0.850651f, 0.000000f, 0.525731f},    {-0.850651f, 0.000000f, -0.525731f},  {-0.850651f, 0.000000f, 0.525731f},
    {-0.809017f, 0.500000f, 0.309017f},   {-0.500000f, 0.309017f, 0.809017f},   {-0.309017f, 0.809017f, 0.500000f},
    {0.309017f, 0.809017f, 0.500000f},    {0.000000f, 1.000000f, 0.000000f},    {0.309017f, 0.809017f, -0.500000f},
    {-0.309017f, 0.809017f, -0.500000f},  {-0.500000f, 0.309017f, -0.809017f},  {-0.809017f, 0.500000f, -0.309017f},
    {-1.000000f, 0.000000f, 0.000000f},   {0.500000f, 0.309017f, 0.809017f},    {0.809017f, 0.500000f, 0.309017f},
    {-0.500000f, -0.309017f, 0.809017f},  {0.000000f, 0.000000f, 1.000000f},    {-0.809017f, -0.500000f, -0.309017f},
    {-0.809017f, -0.500000f, 0.309017f},  {0.000000f, 0.000000f, -1.000000f},   {-0.500000f, -0.309017f, -0.809017f},
    {0.809017f, 0.500000f, -0.309017f},   {0.500000f, 0.309017f, -0.809017f},   {0.809017f, -0.500000f, 0.309017f},
    {0.500000f, -0.309017f, 0.809017f},   {0.309017f, -0.809017f, 0.500000f},   {-0.309017f, -0.809017f, 0.500000f},
    {0.000000f, -1.000000f, 0.000000f},   {-0.309017f, -0.809017f, -0.500000f}, {0.309017f, -0.809017f, -0.500000f},
    {0.500000f, -0.309017f, -0.809017f},  {0.809017f, -0.500000f, -0.309017f},  {1.000000f, 0.000000f, 0.000000f},
    {-0.693780f, 0.702046f, 0.160622f},   {-0.587785f, 0.688191f, 0.425325f},   {-0.433889f, 0.862668f, 0.259892f},
    {-0.862668f, 0.259892f, 0.433889f},   {-0.702046f, 0.160622f, 0.693780f},   {-0.688191f, 0.425325f, 0.587785f},
    {-0.425325f, 0.587785f, 0.688191f},   {-0.259892f, 0.433889f, 0.862668f},   {-0.160622f, 0.693780f, 0.702046f},
    {-0.162460f, 0.951057f, 0.262866f},   {-0.273267f, 0.961938f, 0.000000f},   {0.160622f, 0.693780f, 0.702046f},
    {0.000000f, 0.850651f, 0.525731f},    {0.162460f, 0.951057f, 0.262866f},    {0.433889f, 0.862668f, 0.259892f},
    {0.273267f, 0.961938f, 0.000000f},    {-0.162460f, 0.951057f, -0.262866f},  {-0.433889f, 0.862668f, -0.259892f},
    {0.433889f, 0.862668f, -0.259892f},   {0.162460f, 0.951057f, -0.262866f},   {0.000000f, 0.850651f, -0.525731f},
    {0.160622f, 0.693780f, -0.702046f},   {-0.160622f, 0.693780f, -0.702046f},  {-0.587785f, 0.688191f, -0.425325f},
    {-0.693780f, 0.702046f, -0.160622f},  {-0.259892f, 0.433889f, -0.862668f},  {-0.425325f, 0.587785f, -0.688191f},
    {-0.688191f, 0.425325f, -0.587785f},  {-0.702046f, 0.160622f, -0.693780f},  {-0.862668f, 0.259892f, -0.433889f},
    {-0.850651f, 0.525731f, 0.000000f},   {-0.961938f, 0.000000f, -0.273267f},  {-0.951057f, 0.262866f, -0.162460f},
    {-0.951057f, 0.262866f, 0.162460f},   {-0.961938f, 0.000000f, 0.273267f},   {0.587785f, 0.688191f, 0.425325f},
    {0.693780f, 0.702046f, 0.160622f},    {0.259892f, 0.433889f, 0.862668f},    {0.425325f, 0.587785f, 0.688191f},
    {0.688191f, 0.425325f, 0.587785f},    {0.702046f, 0.160622f, 0.693780f},    {0.862668f, 0.259892f, 0.433889f},
    {-0.262866f, 0.162460f, 0.951057f},   {0.000000f, 0.273267f, 0.961938f},    {-0.702046f, -0.160622f, 0.693780f},
    {-0.525731f, 0.000000f, 0.850651f},   {-0.262866f, -0.162460f, 0.951057f},  {-0.259892f, -0.433889f, 0.862668f},
    {0.000000f, -0.273267f, 0.961938f},   {-0.951057f, -0.262866f, 0.162460f},  {-0.862668f, -0.259892f, 0.433889f},
    {-0.862668f, -0.259892f, -0.433889f}, {-0.951057f, -0.262866f, -0.162460f}, {-0.850651f, -0.525731f, 0.000000f},
    {-0.693780f, -0.702046f, -0.160622f}, {-0.693780f, -0.702046f, 0.160622f},  {-0.525731f, 0.000000f, -0.850651f},
    {-0.702046f, -0.160622f, -0.693780f}, {0.000000f, 0.273267f, -0.961938f},   {-0.262866f, 0.162460f, -0.951057f},
    {-0.262866f, -0.162460f, -0.951057f}, {0.000000f, -0.273267f, -0.961938f},  {-0.259892f, -0.433889f, -0.862668f},
    {0.425325f, 0.587785f, -0.688191f},   {0.259892f, 0.433889f, -0.862668f},   {0.693780f, 0.702046f, -0.160622f},
    {0.587785f, 0.688191f, -0.425325f},   {0.688191f, 0.425325f, -0.587785f},   {0.862668f, 0.259892f, -0.433889f},
    {0.702046f, 0.160622f, -0.693780f},   {0.693780f, -0.702046f, 0.160622f},   {0.587785f, -0.688191f, 0.425325f},
    {0.433889f, -0.862668f, 0.259892f},   {0.862668f, -0.259892f, 0.433889f},   {0.702046f, -0.160622f, 0.693780f},
    {0.688191f, -0.425325f, 0.587785f},   {0.425325f, -0.587785f, 0.688191f},   {0.259892f, -0.433889f, 0.862668f},
    {0.160622f, -0.693780f, 0.702046f},   {0.162460f, -0.951057f, 0.262866f},   {0.273267f, -0.961938f, 0.000000f},
    {-0.160622f, -0.693780f, 0.702046f},  {0.000000f, -0.850651f, 0.525731f},   {-0.162460f, -0.951057f, 0.262866f},
    {-0.433889f, -0.862668f, 0.259892f},  {-0.273267f, -0.961938f, 0.000000f},  {0.162460f, -0.951057f, -0.262866f},
    {0.433889f, -0.862668f, -0.259892f},  {-0.433889f, -0.862668f, -0.259892f}, {-0.162460f, -0.951057f, -0.262866f},
    {0.000000f, -0.850651f, -0.525731f},  {-0.160622f, -0.693780f, -0.702046f}, {0.160622f, -0.693780f, -0.702046f},
    {0.587785f, -0.688191f, -0.425325f},  {0.693780f, -0.702046f, -0.160622f},  {0.259892f, -0.433889f, -0.862668f},
    {0.425325f, -0.587785f, -0.688191f},  {0.688191f, -0.425325f, -0.587785f},  {0.702046f, -0.160622f, -0.693780f},
    {0.862668f, -0.259892f, -0.433889f},  {0.850651f, -0.525731f, 0.000000f},   {0.961938f, 0.000000f, -0.273267f},
    {0.951057f, -0.262866f, -0.162460f},  {0.951057f, -0.262866f, 0.162460f},   {0.961938f, 0.000000f, 0.273267f},
    {0.262866f, -0.162460f, 0.951057f},   {0.525731f, 0.000000f, 0.850651f},    {0.262866f, 0.162460f, 0.951057f},
    {-0.587785f, -0.688191f, 0.425325f},  {-0.425325f, -0.587785f, 0.688191f},  {-0.688191f, -0.425325f, 0.587785f},
    {-0.425325f, -0.587785f, -0.688191f}, {-0.587785f, -0.688191f, -0.425325f}, {-0.688191f, -0.425325f, -0.587785f},
    {0.525731f, 0.000000f, -0.850651f},   {0.262866f, -0.162460f, -0.951057f},  {0.262866f, 0.162460f, -0.951057f},
    {0.951057f, 0.262866f, 0.162460f},    {0.951057f, 0.262866f, -0.162460f},   {0.850651f, 0.525731f, 0.000000f},
};

unsigned int sphere_idx[SPHERE_IDX_COUNT] = {
    0,   42,  44,  42,  12,  43,  44,  43,  14,  42,  43,  44,  12,  45,  47,  45,  11,  46,  47,  46,  13,  45,  46,  47,  14,  48,  50,  48,  13,
    49,  50,  49,  5,   48,  49,  50,  12,  47,  43,  47,  13,  48,  43,  48,  14,  47,  48,  43,  0,   44,  52,  44,  14,  51,  52,  51,  16,  44,
    51,  52,  14,  50,  54,  50,  5,   53,  54,  53,  15,  50,  53,  54,  16,  55,  57,  55,  15,  56,  57,  56,  1,   55,  56,  57,  14,  54,  51,
    54,  15,  55,  51,  55,  16,  54,  55,  51,  0,   52,  59,  52,  16,  58,  59,  58,  18,  52,  58,  59,  16,  57,  61,  57,  1,   60,  61,  60,
    17,  57,  60,  61,  18,  62,  64,  62,  17,  63,  64,  63,  7,   62,  63,  64,  16,  61,  58,  61,  17,  62,  58,  62,  18,  61,  62,  58,  0,
    59,  66,  59,  18,  65,  66,  65,  20,  59,  65,  66,  18,  64,  68,  64,  7,   67,  68,  67,  19,  64,  67,  68,  20,  69,  71,  69,  19,  70,
    71,  70,  10,  69,  70,  71,  18,  68,  65,  68,  19,  69,  65,  69,  20,  68,  69,  65,  0,   66,  42,  66,  20,  72,  42,  72,  12,  66,  72,
    42,  20,  71,  74,  71,  10,  73,  74,  73,  21,  71,  73,  74,  12,  75,  45,  75,  21,  76,  45,  76,  11,  75,  76,  45,  20,  74,  72,  74,
    21,  75,  72,  75,  12,  74,  75,  72,  1,   56,  78,  56,  15,  77,  78,  77,  23,  56,  77,  78,  15,  53,  80,  53,  5,   79,  80,  79,  22,
    53,  79,  80,  23,  81,  83,  81,  22,  82,  83,  82,  9,   81,  82,  83,  15,  80,  77,  80,  22,  81,  77,  81,  23,  80,  81,  77,  5,   49,
    85,  49,  13,  84,  85,  84,  25,  49,  84,  85,  13,  46,  87,  46,  11,  86,  87,  86,  24,  46,  86,  87,  25,  88,  90,  88,  24,  89,  90,
    89,  4,   88,  89,  90,  13,  87,  84,  87,  24,  88,  84,  88,  25,  87,  88,  84,  11,  76,  92,  76,  21,  91,  92,  91,  27,  76,  91,  92,
    21,  73,  94,  73,  10,  93,  94,  93,  26,  73,  93,  94,  27,  95,  97,  95,  26,  96,  97,  96,  2,   95,  96,  97,  21,  94,  91,  94,  26,
    95,  91,  95,  27,  94,  95,  91,  10,  70,  99,  70,  19,  98,  99,  98,  29,  70,  98,  99,  19,  67,  101, 67,  7,   100, 101, 100, 28,  67,
    100, 101, 29,  102, 104, 102, 28,  103, 104, 103, 6,   102, 103, 104, 19,  101, 98,  101, 28,  102, 98,  102, 29,  101, 102, 98,  7,   63,  106,
    63,  17,  105, 106, 105, 31,  63,  105, 106, 17,  60,  108, 60,  1,   107, 108, 107, 30,  60,  107, 108, 31,  109, 111, 109, 30,  110, 111, 110,
    8,   109, 110, 111, 17,  108, 105, 108, 30,  109, 105, 109, 31,  108, 109, 105, 3,   112, 114, 112, 32,  113, 114, 113, 34,  112, 113, 114, 32,
    115, 117, 115, 9,   116, 117, 116, 33,  115, 116, 117, 34,  118, 120, 118, 33,  119, 120, 119, 4,   118, 119, 120, 32,  117, 113, 117, 33,  118,
    113, 118, 34,  117, 118, 113, 3,   114, 122, 114, 34,  121, 122, 121, 36,  114, 121, 122, 34,  120, 124, 120, 4,   123, 124, 123, 35,  120, 123,
    124, 36,  125, 127, 125, 35,  126, 127, 126, 2,   125, 126, 127, 34,  124, 121, 124, 35,  125, 121, 125, 36,  124, 125, 121, 3,   122, 129, 122,
    36,  128, 129, 128, 38,  122, 128, 129, 36,  127, 131, 127, 2,   130, 131, 130, 37,  127, 130, 131, 38,  132, 134, 132, 37,  133, 134, 133, 6,
    132, 133, 134, 36,  131, 128, 131, 37,  132, 128, 132, 38,  131, 132, 128, 3,   129, 136, 129, 38,  135, 136, 135, 40,  129, 135, 136, 38,  134,
    138, 134, 6,   137, 138, 137, 39,  134, 137, 138, 40,  139, 141, 139, 39,  140, 141, 140, 8,   139, 140, 141, 38,  138, 135, 138, 39,  139, 135,
    139, 40,  138, 139, 135, 3,   136, 112, 136, 40,  142, 112, 142, 32,  136, 142, 112, 40,  141, 144, 141, 8,   143, 144, 143, 41,  141, 143, 144,
    32,  145, 115, 145, 41,  146, 115, 146, 9,   145, 146, 115, 40,  144, 142, 144, 41,  145, 142, 145, 32,  144, 145, 142, 4,   119, 90,  119, 33,
    147, 90,  147, 25,  119, 147, 90,  33,  116, 148, 116, 9,   82,  148, 82,  22,  116, 82,  148, 25,  149, 85,  149, 22,  79,  85,  79,  5,   149,
    79,  85,  33,  148, 147, 148, 22,  149, 147, 149, 25,  148, 149, 147, 2,   126, 97,  126, 35,  150, 97,  150, 27,  126, 150, 97,  35,  123, 151,
    123, 4,   89,  151, 89,  24,  123, 89,  151, 27,  152, 92,  152, 24,  86,  92,  86,  11,  152, 86,  92,  35,  151, 150, 151, 24,  152, 150, 152,
    27,  151, 152, 150, 6,   133, 104, 133, 37,  153, 104, 153, 29,  133, 153, 104, 37,  130, 154, 130, 2,   96,  154, 96,  26,  130, 96,  154, 29,
    155, 99,  155, 26,  93,  99,  93,  10,  155, 93,  99,  37,  154, 153, 154, 26,  155, 153, 155, 29,  154, 155, 153, 8,   140, 111, 140, 39,  156,
    111, 156, 31,  140, 156, 111, 39,  137, 157, 137, 6,   103, 157, 103, 28,  137, 103, 157, 31,  158, 106, 158, 28,  100, 106, 100, 7,   158, 100,
    106, 39,  157, 156, 157, 28,  158, 156, 158, 31,  157, 158, 156, 9,   146, 83,  146, 41,  159, 83,  159, 23,  146, 159, 83,  41,  143, 160, 143,
    8,   110, 160, 110, 30,  143, 110, 160, 23,  161, 78,  161, 30,  107, 78,  107, 1,   161, 107, 78,  41,  160, 159, 160, 30,  161, 159, 161, 23,
    160, 161, 159};

//-----------------------------------------------------------------------------
// [SECTION] Duck
//-----------------------------------------------------------------------------
// Rubber Duck by Poly by Google [CC-BY] via Poly Pizza

ImPlot3DPoint duck_vtx[DUCK_VTX_COUNT] = {
    {0.263370f, 0.782383f, -0.488235f},   {0.358677f, -0.624396f, -0.546179f},  {0.292714f, 0.782558f, -0.125229f},
    {0.349165f, -0.579430f, -0.151545f},  {0.000000f, 0.985995f, 0.055503f},    {0.000000f, -0.771795f, -0.060755f},
    {0.000000f, 0.884807f, -0.562217f},   {0.000000f, -0.793724f, -0.609042f},  {0.000000f, -0.299071f, -0.806689f},
    {0.416629f, -0.234865f, -0.718575f},  {0.386268f, -0.264259f, -0.087117f},  {0.000000f, -0.154521f, 0.030419f},
    {0.170659f, -0.255441f, 0.007066f},   {0.180454f, -0.704124f, -0.061920f},  {0.155948f, 0.918253f, -0.001556f},
    {0.155050f, -0.228032f, 0.751753f},   {0.151757f, -0.513087f, 0.744284f},   {0.000000f, -0.182899f, 0.779477f},
    {0.000000f, -0.578330f, 0.764610f},   {0.000000f, 0.685169f, -0.739686f},   {0.371476f, 0.629238f, -0.627667f},
    {0.331315f, 0.641641f, -0.175468f},   {0.206943f, 0.597766f, -0.089039f},   {0.000000f, 0.614709f, -0.054922f},
    {0.000000f, -0.737692f, 0.299441f},   {0.283809f, -0.102660f, 0.299441f},   {0.000000f, 0.014558f, 0.299441f},
    {0.000000f, -0.736425f, 0.474106f},   {0.278490f, -0.087547f, 0.474106f},   {0.000000f, 0.025780f, 0.474106f},
    {0.164839f, 0.864781f, -0.528560f},   {0.230536f, 0.696343f, -0.704629f},   {0.220279f, -0.294500f, -0.788924f},
    {0.216836f, -0.741049f, -0.579700f},  {0.238591f, -0.660227f, 0.299441f},   {0.244763f, -0.660211f, 0.474106f},
    {0.000000f, -0.363444f, 0.812572f},   {0.163341f, -0.354552f, 0.773703f},   {0.374463f, -0.372350f, 0.474106f},
    {0.379897f, -0.380938f, 0.299441f},   {0.289253f, -0.469584f, -0.048850f},  {0.399568f, -0.463659f, -0.141744f},
    {0.416824f, -0.506064f, -0.619739f},  {0.226948f, -0.580280f, -0.719311f},  {0.000000f, -0.596101f, -0.755098f},
    {0.199617f, 0.050031f, -0.023613f},   {0.000000f, 0.056331f, -0.812572f},   {0.221169f, 0.056088f, -0.800430f},
    {0.414907f, 0.057214f, -0.741319f},   {0.383278f, 0.079881f, -0.106452f},   {0.000000f, 0.066068f, 0.011448f},
    {0.485071f, -0.225034f, -0.615697f},  {0.474322f, -0.235931f, -0.130497f},  {0.451926f, -0.378909f, -0.182230f},
    {0.464485f, -0.423127f, -0.533935f},  {0.376105f, 0.621725f, -0.201967f},   {0.458732f, 0.078611f, -0.144688f},
    {0.414064f, 0.587520f, -0.543056f},   {0.482586f, 0.065612f, -0.653211f},   {0.000000f, -0.672915f, 0.096026f},
    {0.146952f, -0.607627f, 0.096026f},   {0.261607f, -0.401487f, 0.096026f},   {0.193018f, -0.190607f, 0.096026f},
    {0.000000f, -0.095407f, 0.096026f},   {0.000000f, -0.044418f, 0.665235f},   {0.241792f, -0.132120f, 0.640095f},
    {0.312765f, -0.375473f, 0.640095f},   {0.214627f, -0.620202f, 0.640095f},   {0.000000f, -0.694664f, 0.658020f},
    {0.000000f, -0.682358f, 0.030419f},   {0.138512f, -0.610831f, 0.030419f},   {0.234026f, -0.438399f, 0.030419f},
    {0.000000f, 0.914951f, 0.077360f},    {0.160964f, 0.841809f, 0.024144f},    {0.193354f, 0.741696f, -0.037907f},
    {0.000000f, 0.800313f, 0.001882f},    {0.000000f, 0.405613f, -0.811128f},   {0.229117f, 0.399656f, -0.791482f},
    {0.409787f, 0.383452f, -0.704163f},   {0.458770f, 0.376363f, -0.605461f},   {0.385168f, 0.580561f, -0.185704f},
    {0.344420f, 0.600331f, -0.166386f},   {0.437609f, 0.339612f, -0.230592f},   {0.386172f, 0.365055f, -0.180691f},
    {0.203357f, 0.342793f, -0.082669f},   {0.000000f, 0.367574f, -0.043515f},   {0.368402f, 0.509624f, -0.189577f},
    {0.408311f, 0.494489f, -0.224777f},   {0.317982f, -0.276765f, -0.036125f},  {0.000000f, -0.705078f, 0.171934f},
    {0.194647f, -0.634647f, 0.171934f},   {0.332827f, -0.390756f, 0.171934f},   {0.252044f, -0.153800f, 0.171934f},
    {0.000000f, -0.052325f, 0.171934f},   {0.000000f, -0.845971f, -0.319676f},  {0.204859f, -0.774310f, -0.326206f},
    {0.382866f, -0.635409f, -0.351147f},  {0.437191f, -0.532057f, -0.362802f},  {0.277419f, 0.820517f, -0.362410f},
    {0.165994f, 0.946464f, -0.306175f},   {0.366520f, 0.694046f, -0.383403f},   {0.000000f, 1.000000f, -0.305615f},
    {0.554754f, 0.081200f, -0.400087f},   {0.548457f, -0.240710f, -0.371820f},  {0.496187f, -0.443697f, -0.357878f},
    {0.410754f, 0.655281f, -0.382353f},   {0.501407f, 0.340701f, -0.406753f},   {-0.263370f, 0.782383f, -0.488235f},
    {-0.358677f, -0.624396f, -0.546179f}, {-0.292714f, 0.782558f, -0.125229f},  {-0.349165f, -0.579430f, -0.151545f},
    {-0.416629f, -0.234865f, -0.718575f}, {-0.386268f, -0.264259f, -0.087117f}, {-0.170659f, -0.255441f, 0.007066f},
    {-0.180454f, -0.704124f, -0.061920f}, {-0.155948f, 0.918253f, -0.001556f},  {-0.155050f, -0.228032f, 0.751753f},
    {-0.151757f, -0.513087f, 0.744284f},  {-0.371476f, 0.629238f, -0.627667f},  {-0.331315f, 0.641641f, -0.175468f},
    {-0.206943f, 0.597766f, -0.089039f},  {-0.283809f, -0.102660f, 0.299441f},  {-0.278490f, -0.087547f, 0.474106f},
    {-0.164839f, 0.864781f, -0.528560f},  {-0.230536f, 0.696343f, -0.704629f},  {-0.220279f, -0.294500f, -0.788924f},
    {-0.216836f, -0.741049f, -0.579700f}, {-0.238591f, -0.660227f, 0.299441f},  {-0.244763f, -0.660211f, 0.474106f},
    {-0.163341f, -0.354552f, 0.773703f},  {-0.374463f, -0.372350f, 0.474106f},  {-0.379897f, -0.380938f, 0.299441f},
    {-0.289253f, -0.469584f, -0.048850f}, {-0.399568f, -0.463659f, -0.141744f}, {-0.416824f, -0.506064f, -0.619739f},
    {-0.226948f, -0.580280f, -0.719311f}, {-0.199617f, 0.050031f, -0.023613f},  {-0.221169f, 0.056088f, -0.800430f},
    {-0.414907f, 0.057214f, -0.741319f},  {-0.383278f, 0.079881f, -0.106452f},  {-0.485071f, -0.225034f, -0.615697f},
    {-0.474322f, -0.235931f, -0.130497f}, {-0.451926f, -0.378909f, -0.182230f}, {-0.464485f, -0.423127f, -0.533935f},
    {-0.376105f, 0.621725f, -0.201967f},  {-0.458732f, 0.078611f, -0.144688f},  {-0.414064f, 0.587520f, -0.543056f},
    {-0.482586f, 0.065612f, -0.653211f},  {-0.146952f, -0.607627f, 0.096026f},  {-0.261606f, -0.401487f, 0.096026f},
    {-0.193018f, -0.190607f, 0.096026f},  {-0.241792f, -0.132120f, 0.640095f},  {-0.312765f, -0.375473f, 0.640095f},
    {-0.214627f, -0.620202f, 0.640095f},  {-0.138512f, -0.610831f, 0.030419f},  {-0.234026f, -0.438399f, 0.030419f},
    {-0.160964f, 0.841809f, 0.024144f},   {-0.193354f, 0.741696f, -0.037907f},  {-0.229117f, 0.399656f, -0.791482f},
    {-0.409787f, 0.383452f, -0.704163f},  {-0.458770f, 0.376363f, -0.605461f},  {-0.385168f, 0.580561f, -0.185704f},
    {-0.344420f, 0.600331f, -0.166386f},  {-0.437609f, 0.339612f, -0.230592f},  {-0.386172f, 0.365055f, -0.180691f},
    {-0.203357f, 0.342793f, -0.082669f},  {-0.368402f, 0.509624f, -0.189577f},  {-0.408311f, 0.494489f, -0.224777f},
    {-0.317982f, -0.276765f, -0.036125f}, {-0.194647f, -0.634647f, 0.171934f},  {-0.332827f, -0.390756f, 0.171934f},
    {-0.252044f, -0.153800f, 0.171934f},  {-0.204859f, -0.774310f, -0.326206f}, {-0.382866f, -0.635409f, -0.351147f},
    {-0.437191f, -0.532057f, -0.362802f}, {-0.277419f, 0.820517f, -0.362410f},  {-0.165994f, 0.946464f, -0.306175f},
    {-0.366520f, 0.694046f, -0.383403f},  {-0.554754f, 0.081200f, -0.400087f},  {-0.548457f, -0.240710f, -0.371820f},
    {-0.496187f, -0.443697f, -0.357878f}, {-0.410754f, 0.655281f, -0.382353f},  {-0.501407f, 0.340701f, -0.406753f},
    {-0.147251f, -0.668523f, 0.330326f},  {-0.047291f, -0.930817f, 0.472716f},  {-0.224222f, -0.665336f, 0.415767f},
    {-0.075450f, -0.918607f, 0.533818f},  {-0.075797f, -0.674119f, 0.541030f},  {-0.096675f, -0.818748f, 0.395991f},
    {-0.159031f, -0.798414f, 0.462927f},  {-0.223648f, -0.656683f, 0.331961f},  {-0.072544f, -0.935279f, 0.500884f},
    {0.000000f, -0.961081f, 0.579077f},   {0.000000f, -0.726138f, 0.328549f},   {0.000000f, -0.969221f, 0.509585f},
    {-0.176269f, -0.669386f, 0.471817f},  {-0.051675f, -0.862571f, 0.538304f},  {0.000000f, -0.680106f, 0.554423f},
    {0.000000f, -0.974061f, 0.546160f},   {-0.152228f, -0.819158f, 0.418117f},  {0.000000f, -0.867770f, 0.561794f},
    {0.000000f, -0.827887f, 0.404080f},   {-0.123466f, -0.788030f, 0.489190f},  {0.147251f, -0.668523f, 0.330326f},
    {0.047291f, -0.930817f, 0.472716f},   {0.224222f, -0.665336f, 0.415767f},   {0.075450f, -0.918607f, 0.533818f},
    {0.075797f, -0.674119f, 0.541030f},   {0.096675f, -0.818748f, 0.395991f},   {0.159031f, -0.798414f, 0.462927f},
    {0.223648f, -0.656683f, 0.331961f},   {0.072544f, -0.935279f, 0.500884f},   {0.176269f, -0.669386f, 0.471817f},
    {0.051675f, -0.862571f, 0.538304f},   {0.152228f, -0.819158f, 0.418117f},   {0.123466f, -0.788030f, 0.489190f},
    {0.000000f, -0.994773f, 0.345730f},   {0.000000f, -0.647443f, 0.199203f},   {0.000000f, -0.986165f, 0.291566f},
    {0.000000f, -0.703971f, 0.341994f},   {0.000000f, -1.000000f, 0.315210f},   {0.000000f, -0.787658f, 0.226787f},
    {0.000000f, -0.961085f, 0.352303f},   {-0.133409f, -0.653443f, 0.222877f},  {-0.060090f, -0.929363f, 0.267589f},
    {-0.224222f, -0.658853f, 0.342353f},  {-0.094843f, -0.932646f, 0.343060f},  {-0.151330f, -0.675024f, 0.346911f},
    {0.000000f, -0.932532f, 0.323403f},   {-0.120579f, -0.791706f, 0.239478f},  {-0.187682f, -0.791724f, 0.341367f},
    {-0.213355f, -0.651997f, 0.277443f},  {-0.092940f, -0.939719f, 0.301090f},  {-0.176269f, -0.666860f, 0.352303f},
    {-0.130777f, -0.793601f, 0.328226f},  {-0.075297f, -0.913539f, 0.352303f},  {-0.182747f, -0.797038f, 0.284545f},
    {-0.150873f, -0.786911f, 0.352303f},  {-0.055104f, -0.898766f, 0.325273f},  {0.133409f, -0.653443f, 0.222877f},
    {0.060090f, -0.929363f, 0.267589f},   {0.224222f, -0.658853f, 0.342353f},   {0.094843f, -0.932646f, 0.343060f},
    {0.151330f, -0.675024f, 0.346911f},   {0.120579f, -0.791706f, 0.239478f},   {0.187682f, -0.791724f, 0.341367f},
    {0.213355f, -0.651997f, 0.277443f},   {0.092940f, -0.939719f, 0.301090f},   {0.176269f, -0.666860f, 0.352303f},
    {0.130777f, -0.793601f, 0.328226f},   {0.075297f, -0.913539f, 0.352303f},   {0.182747f, -0.797038f, 0.284545f},
    {0.150873f, -0.786911f, 0.352303f},   {0.055104f, -0.898766f, 0.325273f}};

unsigned int duck_idx[DUCK_IDX_COUNT] = {
    2,   73,  74,  2,   74,  21,  30,  0,   20,  30,  20,  31,  43,  42,  1,   43,  1,   33,  41,  40,  13,  41,  13,  3,   40,  71,  70,  40,  70,
    13,  48,  9,   32,  48,  32,  47,  45,  88,  10,  45,  10,  49,  39,  38,  35,  39,  35,  34,  66,  37,  16,  66,  16,  67,  6,   30,  31,  6,
    31,  19,  46,  47,  32,  46,  32,  8,   44,  43,  33,  44,  33,  7,   70,  69,  5,   70,  5,   13,  35,  27,  24,  35,  24,  34,  16,  18,  68,
    16,  68,  67,  36,  18,  16,  36,  16,  37,  64,  17,  15,  64,  15,  65,  26,  29,  28,  26,  28,  25,  50,  11,  12,  50,  12,  45,  72,  75,
    74,  72,  74,  73,  17,  36,  37,  17,  37,  15,  65,  15,  37,  65,  37,  66,  25,  28,  38,  25,  38,  39,  40,  88,  12,  40,  12,  71,  10,
    88,  40,  10,  40,  41,  32,  9,   42,  32,  42,  43,  8,   32,  43,  8,   43,  44,  85,  84,  22,  85,  22,  23,  20,  78,  77,  20,  77,  31,
    19,  31,  77,  19,  77,  76,  48,  58,  51,  48,  51,  9,   10,  52,  56,  10,  56,  49,  41,  53,  52,  41,  52,  10,  9,   51,  54,  9,   54,
    42,  81,  80,  55,  81,  55,  21,  20,  57,  79,  20,  79,  78,  90,  89,  59,  90,  59,  60,  61,  91,  90,  61,  90,  60,  62,  92,  91,  62,
    91,  61,  63,  93,  92,  63,  92,  62,  29,  64,  65,  29,  65,  28,  28,  65,  66,  28,  66,  38,  38,  66,  67,  38,  67,  35,  68,  27,  35,
    68,  35,  67,  60,  59,  69,  60,  69,  70,  71,  61,  60,  71,  60,  70,  12,  62,  61,  12,  61,  71,  11,  63,  62,  11,  62,  12,  14,  4,
    72,  14,  72,  73,  2,   14,  73,  22,  81,  21,  22,  21,  74,  75,  23,  22,  75,  22,  74,  83,  82,  87,  83,  87,  86,  76,  77,  47,  76,
    47,  46,  78,  48,  47,  78,  47,  77,  79,  58,  48,  79,  48,  78,  49,  56,  82,  49,  82,  83,  84,  45,  49,  84,  49,  83,  85,  50,  45,
    85,  45,  84,  87,  80,  81,  87,  81,  86,  22,  84,  83,  22,  83,  86,  45,  12,  88,  34,  24,  89,  34,  89,  90,  91,  39,  34,  91,  34,
    90,  92,  25,  39,  92,  39,  91,  93,  26,  25,  93,  25,  92,  0,   98,  100, 0,   100, 20,  1,   96,  95,  1,   95,  33,  30,  99,  98,  30,
    98,  0,   97,  96,  1,   97,  1,   42,  96,  3,   13,  96,  13,  95,  41,  3,   96,  41,  96,  97,  98,  2,   21,  98,  21,  100, 99,  14,  2,
    99,  2,   98,  102, 103, 51,  102, 51,  58,  56,  52,  103, 56,  103, 102, 101, 4,   14,  101, 14,  99,  6,   101, 99,  6,   99,  30,  95,  94,
    7,   95,  7,   33,  13,  5,   94,  13,  94,  95,  52,  53,  104, 52,  104, 103, 103, 104, 54,  103, 54,  51,  105, 106, 79,  105, 79,  57,  97,
    104, 53,  97,  53,  41,  42,  54,  104, 42,  104, 97,  21,  55,  105, 21,  105, 100, 100, 105, 57,  100, 57,  20,  106, 105, 87,  106, 87,  82,
    106, 102, 58,  106, 58,  79,  82,  56,  102, 82,  102, 106, 22,  86,  81,  80,  87,  105, 80,  105, 55,  109, 119, 157, 109, 157, 156, 123, 124,
    118, 123, 118, 107, 135, 126, 108, 135, 108, 134, 133, 110, 114, 133, 114, 132, 132, 114, 154, 132, 154, 155, 138, 137, 125, 138, 125, 111, 136,
    139, 112, 136, 112, 168, 131, 127, 128, 131, 128, 130, 152, 153, 117, 152, 117, 129, 6,   19,  124, 6,   124, 123, 46,  8,   125, 46,  125, 137,
    44,  7,   126, 44,  126, 135, 154, 114, 5,   154, 5,   69,  128, 127, 24,  128, 24,  27,  117, 153, 68,  117, 68,  18,  36,  129, 117, 36,  117,
    18,  64,  151, 116, 64,  116, 17,  26,  121, 122, 26,  122, 29,  50,  136, 113, 50,  113, 11,  72,  156, 157, 72,  157, 75,  17,  116, 129, 17,
    129, 36,  151, 152, 129, 151, 129, 116, 121, 131, 130, 121, 130, 122, 132, 155, 113, 132, 113, 168, 112, 133, 132, 112, 132, 168, 125, 135, 134,
    125, 134, 111, 8,   44,  135, 8,   135, 125, 85,  23,  120, 85,  120, 165, 118, 124, 158, 118, 158, 159, 19,  76,  158, 19,  158, 124, 138, 111,
    140, 138, 140, 147, 112, 139, 145, 112, 145, 141, 133, 112, 141, 133, 141, 142, 111, 134, 143, 111, 143, 140, 162, 119, 144, 162, 144, 161, 118,
    159, 160, 118, 160, 146, 169, 148, 59,  169, 59,  89,  149, 148, 169, 149, 169, 170, 150, 149, 170, 150, 170, 171, 63,  150, 171, 63,  171, 93,
    29,  122, 151, 29,  151, 64,  122, 130, 152, 122, 152, 151, 130, 128, 153, 130, 153, 152, 68,  153, 128, 68,  128, 27,  148, 154, 69,  148, 69,
    59,  155, 154, 148, 155, 148, 149, 113, 155, 149, 113, 149, 150, 11,  113, 150, 11,  150, 63,  115, 156, 72,  115, 72,  4,   109, 156, 115, 120,
    157, 119, 120, 119, 162, 75,  157, 120, 75,  120, 23,  164, 166, 167, 164, 167, 163, 76,  46,  137, 76,  137, 158, 159, 158, 137, 159, 137, 138,
    160, 159, 138, 160, 138, 147, 139, 164, 163, 139, 163, 145, 165, 164, 139, 165, 139, 136, 85,  165, 136, 85,  136, 50,  167, 166, 162, 167, 162,
    161, 120, 166, 164, 120, 164, 165, 136, 168, 113, 127, 169, 89,  127, 89,  24,  170, 169, 127, 170, 127, 131, 171, 170, 131, 171, 131, 121, 93,
    171, 121, 93,  121, 26,  107, 118, 177, 107, 177, 175, 108, 126, 172, 108, 172, 173, 123, 107, 175, 123, 175, 176, 174, 134, 108, 174, 108, 173,
    173, 172, 114, 173, 114, 110, 133, 174, 173, 133, 173, 110, 175, 177, 119, 175, 119, 109, 176, 175, 109, 176, 109, 115, 178, 147, 140, 178, 140,
    179, 145, 178, 179, 145, 179, 141, 101, 176, 115, 101, 115, 4,   6,   123, 176, 6,   176, 101, 172, 126, 7,   172, 7,   94,  114, 172, 94,  114,
    94,  5,   141, 179, 180, 141, 180, 142, 179, 140, 143, 179, 143, 180, 181, 146, 160, 181, 160, 182, 174, 133, 142, 174, 142, 180, 134, 174, 180,
    134, 180, 143, 119, 177, 181, 119, 181, 144, 177, 118, 146, 177, 146, 181, 182, 163, 167, 182, 167, 181, 182, 160, 147, 182, 147, 178, 163, 182,
    178, 163, 178, 145, 120, 162, 166, 161, 144, 181, 161, 181, 167, 189, 185, 190, 189, 190, 199, 190, 183, 188, 190, 188, 199, 197, 187, 196, 197,
    196, 200, 188, 183, 193, 188, 193, 201, 192, 186, 191, 192, 191, 198, 191, 184, 194, 191, 194, 198, 188, 184, 191, 188, 191, 199, 191, 186, 189,
    191, 189, 199, 194, 184, 188, 194, 188, 201, 196, 187, 195, 196, 195, 202, 195, 185, 189, 195, 189, 202, 189, 186, 196, 189, 196, 202, 196, 186,
    192, 196, 192, 200, 209, 214, 210, 209, 210, 205, 210, 214, 208, 210, 208, 203, 197, 200, 213, 197, 213, 207, 208, 201, 193, 208, 193, 203, 192,
    198, 211, 192, 211, 206, 211, 198, 194, 211, 194, 204, 208, 214, 211, 208, 211, 204, 211, 214, 209, 211, 209, 206, 194, 201, 208, 194, 208, 204,
    213, 215, 212, 213, 212, 207, 212, 215, 209, 212, 209, 205, 209, 215, 213, 209, 213, 206, 213, 200, 192, 213, 192, 206, 230, 225, 231, 230, 231,
    236, 231, 223, 229, 231, 229, 236, 219, 227, 234, 229, 223, 217, 229, 217, 221, 216, 226, 232, 216, 232, 220, 232, 224, 218, 232, 218, 220, 229,
    224, 232, 229, 232, 236, 232, 226, 230, 232, 230, 236, 234, 238, 228, 234, 228, 219, 218, 224, 229, 218, 229, 221, 234, 227, 233, 234, 233, 237,
    233, 225, 230, 233, 230, 237, 230, 226, 235, 230, 235, 237, 235, 238, 234, 235, 234, 237, 228, 238, 235, 228, 235, 222, 235, 226, 216, 235, 216,
    222, 245, 251, 246, 245, 246, 241, 246, 251, 244, 246, 244, 239, 219, 249, 243, 244, 221, 217, 244, 217, 239, 216, 220, 247, 216, 247, 242, 247,
    220, 218, 247, 218, 240, 244, 251, 247, 244, 247, 240, 247, 251, 245, 247, 245, 242, 249, 219, 228, 249, 228, 253, 218, 221, 244, 218, 244, 240,
    249, 252, 248, 249, 248, 243, 248, 252, 245, 248, 245, 241, 245, 252, 250, 245, 250, 242, 250, 252, 249, 250, 249, 253, 228, 222, 250, 228, 250,
    253, 250, 222, 216, 250, 216, 242};

} // namespace ImPlot3D
