/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRendererDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardUIRegistry;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class DashboardItemConfigurationDialog
extends BaseDialog {
    private final DashboardItemConfiguration itemDescriptor;
    private final boolean newItem;
    private Text idText;
    private Text nameText;
    private Text displayNameText;
    private Text descriptionText;
    private IObjectPropertyConfigurator<DashboardItemConfiguration, DashboardItemConfiguration> itemConfigurationEditor;

    public DashboardItemConfigurationDialog(Shell shell, DashboardItemConfiguration itemDescriptor, boolean isNewItem) {
        super(shell, NLS.bind((String)UIDashboardMessages.dialog_edit_dashboard_title, (Object)itemDescriptor.getName()), null);
        this.itemDescriptor = itemDescriptor;
        this.newItem = isNewItem;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected Composite createDialogArea(Composite parent) {
        int baseStyle;
        Composite composite = super.createDialogArea(parent);
        boolean readOnly = !this.itemDescriptor.isCustom();
        int n = baseStyle = !readOnly ? 0 : 8;
        if (readOnly) {
            UIUtils.createInfoLabel((Composite)composite, (String)UIDashboardMessages.dialog_edit_dashboard_infolabels_predifined_dashboard);
        }
        DashboardRendererDescriptor renderer = DashboardUIRegistry.getInstance().getViewType(this.itemDescriptor.getDashboardRenderer());
        Composite infoGroup = UIUtils.createTitledComposite((Composite)composite, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo, (int)4, (int)768);
        this.idText = UIUtils.createLabelText((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_labels_id, (String)this.itemDescriptor.getId(), (int)(0x800 | baseStyle));
        this.idText.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        if (this.newItem) {
            this.idText.addModifyListener(e -> this.updateButtons());
        } else {
            this.idText.setEditable(false);
        }
        this.nameText = UIUtils.createLabelText((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_labels_name, (String)this.itemDescriptor.getName(), (int)(0x800 | baseStyle));
        this.nameText.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this.nameText.addModifyListener(e -> this.updateButtons());
        this.displayNameText = UIUtils.createLabelText((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_labels_display_name, (String)this.itemDescriptor.getDisplayName(), (int)(0x800 | baseStyle));
        this.displayNameText.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this.descriptionText = UIUtils.createLabelText((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_labels_description, (String)CommonUtils.notEmpty((String)this.itemDescriptor.getDescription()), (int)(0xA42 | baseStyle));
        this.descriptionText.addModifyListener(e -> this.updateButtons());
        ((GridData)this.descriptionText.getLayoutData()).heightHint = 30;
        ((GridData)this.descriptionText.getLayoutData()).widthHint = 300;
        try {
            this.itemConfigurationEditor = renderer.createItemConfigurationEditor();
        }
        catch (Exception e2) {
            DBWorkbench.getPlatformUI().showError("Error creating configuration editor", null, (Throwable)e2);
        }
        if (this.itemConfigurationEditor != null) {
            Composite configComposite = UIUtils.createTitledComposite((Composite)composite, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardinfo, (int)1, (int)768);
            this.itemConfigurationEditor.createControl(configComposite, (Object)this.itemDescriptor, this::updateButtons);
            this.itemConfigurationEditor.loadSettings((Object)this.itemDescriptor);
        }
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateButtons();
        return contents;
    }

    private void updateButtons() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(this.itemDescriptor.isCustom() && !this.idText.getText().isEmpty() && !this.nameText.getText().isEmpty() && (this.itemConfigurationEditor == null || this.itemConfigurationEditor.isComplete()));
        }
    }

    private void saveSettings() {
        this.itemDescriptor.setId(this.idText.getText());
        this.itemDescriptor.setName(this.nameText.getText());
        this.itemDescriptor.setDisplayName(this.displayNameText.getText());
        this.itemDescriptor.setDescription(this.descriptionText.getText());
        if (this.itemConfigurationEditor != null) {
            this.itemConfigurationEditor.saveSettings((Object)this.itemDescriptor);
        }
    }

    protected void okPressed() {
        this.saveSettings();
        DashboardRegistry.getInstance().saveSettings();
        super.okPressed();
    }
}

