/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.processor;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tools.transfer.IDataTransferEventProcessor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;

public class FailedExportFileCleanerProcessor
implements IDataTransferEventProcessor<StreamTransferConsumer> {
    public static final String ID = "failedExportFileCleaner";
    private static final Log log = Log.getLog(FailedExportFileCleanerProcessor.class);

    @Override
    public void processEvent(@NotNull DBRProgressMonitor monitor, @NotNull IDataTransferEventProcessor.Event event, @NotNull StreamTransferConsumer consumer, @Nullable DBTTask task, @NotNull Map<String, Object> settings) {
    }

    @Override
    public void processError(@NotNull DBRProgressMonitor monitor, @NotNull Throwable error, @NotNull StreamTransferConsumer consumer, @Nullable DBTTask task, @NotNull Map<String, Object> settings) {
        if (consumer.getSettings().isUseSingleFile()) {
            return;
        }
        for (Path outputFile : consumer.getOutputFiles()) {
            try {
                Files.deleteIfExists(outputFile);
            }
            catch (IOException e) {
                log.warn((Object)("Unable to delete failed export file '" + String.valueOf(outputFile.toAbsolutePath()) + "'"), (Throwable)e);
            }
        }
    }
}

