/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DB2CurrentUserPrivileges {
    private static final Log LOG = Log.getLog(DB2CurrentUserPrivileges.class);
    private static final String SYSMON = "SYSMON";
    private static final String SYSMAINT = "SYSMAINT";
    private static final String SYSADM = "SYSADM";
    private static final String SYSCTRL = "SYSCTRL";
    private static final String DATAACCESS = "DATAACCESS";
    private static final String DBADM = "DBADM";
    private static final String SQLADM = "SQLADM";
    private static final String AUTH_APP = "T:SYSIBMADM.APPLICATIONS";
    private static final String AUTH_DBCFG = "T:SYSIBMADM.DBCFG";
    private static final String AUTH_CONTAINER = "R:SYSPROC.SNAP_GET_CONTAINER";
    private static final String SEL_AUTHORITIES;
    private static final String SEL_OBJECTS;
    private final List<String> listAuthorities = new ArrayList<String>();
    private final List<String> listObjectPrivileges;
    private final Boolean userIsAuthorisedForApplications;
    private final Boolean userIsAuthorisedForContainers;
    private final Boolean userIsAuthorisedForDBCFG;
    private final Boolean userIsAuthorisedForAdminister;

    static {
        StringBuilder sb = new StringBuilder(256);
        sb.append("SELECT AUTHORITY");
        sb.append("  FROM TABLE (SYSPROC.AUTH_LIST_AUTHORITIES_FOR_AUTHID (?, 'U')) AS T ");
        sb.append(" WHERE 'Y' IN (D_USER,D_GROUP,D_PUBLIC,ROLE_USER,ROLE_GROUP,ROLE_PUBLIC,D_ROLE)");
        sb.append(" WITH UR");
        SEL_AUTHORITIES = sb.toString();
        sb = new StringBuilder(512);
        sb.append("SELECT 'R:' || TRIM(SCHEMA) || '.' || SPECIFICNAME");
        sb.append("  FROM SYSCAT.ROUTINEAUTH");
        sb.append(" WHERE ((GRANTEETYPE = 'G' AND GRANTEE = 'PUBLIC') OR (GRANTEETYPE = 'U' AND GRANTEE = ?)) ");
        sb.append("   AND (SCHEMA = 'SYSPROC' AND SPECIFICNAME = 'SNAP_GET_CONTAINER' AND EXECUTEAUTH IN ('Y','G'))");
        sb.append(" UNION ALL ");
        sb.append("SELECT DISTINCT 'T:' || TRIM(TABSCHEMA) || '.' ||TABNAME");
        sb.append("  FROM SYSCAT.TABAUTH");
        sb.append(" WHERE ((GRANTEETYPE = 'G' AND GRANTEE = 'PUBLIC') OR (GRANTEETYPE = 'U' AND GRANTEE = ?))");
        sb.append("   AND (");
        sb.append("        (TABSCHEMA = 'SYSIBMADM' AND TABNAME = 'APPLICATIONS' AND 'Y' IN (CONTROLAUTH,SELECTAUTH))");
        sb.append("     OR (TABSCHEMA = 'SYSIBMADM' AND TABNAME = 'DBCFG' AND 'Y' IN (CONTROLAUTH,SELECTAUTH))");
        sb.append("       )");
        sb.append(" WITH UR");
        SEL_OBJECTS = sb.toString();
    }

    public DB2CurrentUserPrivileges(DBRProgressMonitor monitor, JDBCSession session, String currentAuthId, DB2DataSource db2DataSource) throws SQLException {
        JDBCResultSet dbResult;
        Object var9_15;
        Throwable throwable;
        JDBCPreparedStatement dbStat;
        Object var6_8;
        Throwable throwable2;
        if (db2DataSource.isAtLeastV9_5()) {
            throwable2 = null;
            var6_8 = null;
            try {
                dbStat = session.prepareStatement(SEL_AUTHORITIES);
                try {
                    dbStat.setString(1, currentAuthId);
                    throwable = null;
                    var9_15 = null;
                    try {
                        dbResult = dbStat.executeQuery();
                        try {
                            while (dbResult.next()) {
                                this.listAuthorities.add(dbResult.getString(1));
                            }
                        }
                        finally {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                finally {
                    if (dbStat != null) {
                        dbStat.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        this.listObjectPrivileges = new ArrayList<String>();
        throwable2 = null;
        var6_8 = null;
        try {
            dbStat = session.prepareStatement(SEL_OBJECTS);
            try {
                dbStat.setString(1, currentAuthId);
                dbStat.setString(2, currentAuthId);
                throwable = null;
                var9_15 = null;
                try {
                    dbResult = dbStat.executeQuery();
                    try {
                        while (dbResult.next()) {
                            this.listObjectPrivileges.add(dbResult.getString(1));
                        }
                    }
                    finally {
                        if (dbResult != null) {
                            dbResult.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            finally {
                if (dbStat != null) {
                    dbStat.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
        this.userIsAuthorisedForApplications = this.computeUserIsAuthorisedForApplications();
        this.userIsAuthorisedForDBCFG = this.computeUserIsAuthorisedForDBCFG();
        this.userIsAuthorisedForAdminister = this.userIsAuthorisedForApplications != false || this.userIsAuthorisedForDBCFG != false;
        this.userIsAuthorisedForContainers = this.computeUserIsAuthorisedForContainers();
    }

    public Boolean userIsAuthorisedForApplications() {
        return this.userIsAuthorisedForApplications;
    }

    public Boolean userIsAuthorisedForContainers() {
        return this.userIsAuthorisedForContainers;
    }

    public Boolean userIsAuthorisedForDBCFG() {
        return this.userIsAuthorisedForDBCFG;
    }

    public Boolean userIsAuthorisedForAdminister() {
        return this.userIsAuthorisedForAdminister;
    }

    private Boolean computeUserIsAuthorisedForApplications() {
        if (this.listAuthorities.contains(SYSMON) || this.listAuthorities.contains(SYSMAINT) || this.listAuthorities.contains(SYSADM) || this.listAuthorities.contains(SYSCTRL)) {
            if (this.listAuthorities.contains(DATAACCESS) || this.listAuthorities.contains(DBADM) || this.listAuthorities.contains(SQLADM)) {
                return true;
            }
            if (this.listObjectPrivileges.contains(AUTH_APP)) {
                return true;
            }
        }
        LOG.debug((Object)"Current User is not authorized to see Applications");
        return false;
    }

    private Boolean computeUserIsAuthorisedForContainers() {
        if (this.listAuthorities.contains(SYSMON) || this.listAuthorities.contains(SYSMAINT) || this.listAuthorities.contains(SYSADM) || this.listAuthorities.contains(SYSCTRL)) {
            if (this.listAuthorities.contains(DATAACCESS)) {
                return true;
            }
            if (this.listObjectPrivileges.contains(AUTH_CONTAINER)) {
                return true;
            }
        }
        LOG.debug((Object)"Current User is not authorized to see Tablespaces Containers");
        return false;
    }

    private Boolean computeUserIsAuthorisedForDBCFG() {
        if (this.listAuthorities.contains(DATAACCESS) || this.listAuthorities.contains(DBADM) || this.listAuthorities.contains(SQLADM)) {
            return true;
        }
        if (this.listObjectPrivileges.contains(AUTH_DBCFG)) {
            return true;
        }
        LOG.debug((Object)"Current User is not authorized to see DB/DBM Configuration Parameters");
        return false;
    }
}

