/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.jobs.DataSourceUpdaterJob;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;

class EndIdleTransactionsJob
extends DataSourceUpdaterJob {
    private static final Log log = Log.getLog(EndIdleTransactionsJob.class);
    private static final Object CONFIRM_SYNC = new Object();
    private final DBPDataSource dataSource;
    private final Map<DBCExecutionContext, DBCTransactionManager> txnToEnd;

    EndIdleTransactionsJob(DBPDataSource dataSource, Map<DBCExecutionContext, DBCTransactionManager> txnToEnd) {
        super("End idle transaction for (" + dataSource.getContainer().getName() + ")");
        this.setUser(false);
        this.setSystem(true);
        this.dataSource = dataSource;
        this.txnToEnd = txnToEnd;
    }

    @Override
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IStatus updateDataSource(DBRProgressMonitor monitor) {
        UIServiceConnections serviceConnections = DBWorkbench.getService(UIServiceConnections.class);
        if (serviceConnections != null) {
            Object object = CONFIRM_SYNC;
            synchronized (object) {
                if (!serviceConnections.confirmTransactionsClose(this.txnToEnd.keySet().toArray(new DBCExecutionContext[0]))) {
                    return Status.CANCEL_STATUS;
                }
            }
        }
        log.debug("End idle " + this.txnToEnd.size() + " transactions for " + this.dataSource.getContainer().getId());
        for (Map.Entry<DBCExecutionContext, DBCTransactionManager> tee : this.txnToEnd.entrySet()) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (DBCSession session = tee.getKey().openSession(monitor, DBCExecutionPurpose.UTIL, "End idle transaction");){
                    tee.getValue().rollback(session, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBException e) {
                log.error("Error ending idle transaction", e);
            }
        }
        DBeaverNotifications.showNotification(this.dataSource, "rollback.idle", "Transactions have been rolled back after long idle period (" + this.dataSource.getContainer().getName() + ")", DBPMessageType.ERROR);
        return Status.OK_STATUS;
    }
}

