/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.create.index;

import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.create.table.Index;

public class CreateIndex
implements Statement {
    private Table table;
    private Index index;
    private List<String> tailParameters;
    private boolean indexTypeBeforeOn = false;
    private boolean usingIfNotExists = false;

    public boolean isIndexTypeBeforeOn() {
        return this.indexTypeBeforeOn;
    }

    public void setIndexTypeBeforeOn(boolean indexTypeBeforeOn) {
        this.indexTypeBeforeOn = indexTypeBeforeOn;
    }

    public boolean isUsingIfNotExists() {
        return this.usingIfNotExists;
    }

    public CreateIndex setUsingIfNotExists(boolean usingIfNotExists) {
        this.usingIfNotExists = usingIfNotExists;
        return this;
    }

    @Override
    public <T, S> T accept(StatementVisitor<T> statementVisitor, S context) {
        return statementVisitor.visit(this, context);
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<String> getTailParameters() {
        return this.tailParameters;
    }

    public void setTailParameters(List<String> tailParameters) {
        this.tailParameters = tailParameters;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE ");
        if (this.index.getType() != null) {
            buffer.append(this.index.getType());
            buffer.append(" ");
        }
        buffer.append("INDEX ");
        if (this.usingIfNotExists) {
            buffer.append("IF NOT EXISTS ");
        }
        buffer.append(this.index.getName());
        if (this.index.getUsing() != null && this.isIndexTypeBeforeOn()) {
            buffer.append(" USING ");
            buffer.append(this.index.getUsing());
        }
        buffer.append(" ON ");
        buffer.append(this.table.getFullyQualifiedName());
        if (this.index.getUsing() != null && !this.isIndexTypeBeforeOn()) {
            buffer.append(" USING ");
            buffer.append(this.index.getUsing());
        }
        if (this.index.getColumnsNames() != null) {
            buffer.append(" (");
            buffer.append(this.index.getColumns().stream().map(cp -> cp.columnName + (String)(cp.getParams() != null ? " " + String.join((CharSequence)" ", cp.getParams()) : "")).collect(Collectors.joining(", ")));
            buffer.append(")");
            if (this.tailParameters != null) {
                for (String param : this.tailParameters) {
                    buffer.append(" ").append(param);
                }
            }
        }
        return buffer.toString();
    }

    public CreateIndex withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public CreateIndex withIndex(Index index) {
        this.setIndex(index);
        return this;
    }

    public CreateIndex withTailParameters(List<String> tailParameters) {
        this.setTailParameters(tailParameters);
        return this;
    }
}

