/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver;

import java.sql.SQLException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;

public class DBDatabaseException
extends DBException {
    private final DBPDataSource dataSource;
    private final boolean hasMessage;

    public DBDatabaseException(String message) {
        super(message);
        this.dataSource = null;
        this.hasMessage = true;
    }

    public DBDatabaseException(String message, Throwable cause) {
        super(message, cause);
        this.dataSource = null;
        this.hasMessage = message != null;
    }

    public DBDatabaseException(Throwable cause, DBPDataSource dataSource) {
        super(cause instanceof SQLException ? DBDatabaseException.makeMessage((SQLException)cause) : cause.getMessage(), cause);
        this.dataSource = dataSource;
        this.hasMessage = false;
    }

    public DBDatabaseException(String message, Throwable cause, DBPDataSource dataSource) {
        super(message, cause);
        this.dataSource = dataSource;
        this.hasMessage = message != null;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        Throwable cause = this.getCause();
        if (cause instanceof DBDatabaseException) {
            DBDatabaseException dbe = (DBDatabaseException)cause;
            return dbe.getDataSource();
        }
        return null;
    }

    public boolean hasMessage() {
        return this.hasMessage;
    }

    private static String makeMessage(SQLException ex) {
        StringBuilder msg = new StringBuilder(ModelMessages.common_error_sql);
        if (ex.getErrorCode() > 0) {
            msg.append(" [").append(ex.getErrorCode()).append("]");
        }
        if (!CommonUtils.isEmpty((String)ex.getSQLState())) {
            msg.append(" [").append(ex.getSQLState()).append("]");
        }
        if (!CommonUtils.isEmpty((String)ex.getMessage())) {
            msg.append(": ").append(SQLUtils.stripTransformations(ex.getMessage()));
        }
        return msg.toString();
    }
}

