-- Copyright 2026 Specter Ops, Inc.
--
-- Licensed under the Apache License, Version 2.0
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--
-- SPDX-License-Identifier: Apache-2.0
-- Code generated by Cuelang code gen. DO NOT EDIT!
-- Cuelang source: github.com/specterops/bloodhound/-/tree/main/packages/cue/schemas/
CREATE OR REPLACE FUNCTION genscript_upsert_kind(node_kind_name TEXT) RETURNS void AS $$
BEGIN
    IF NOT EXISTS (SELECT id FROM kind WHERE kind.name = node_kind_name) THEN
        INSERT INTO kind (name) VALUES (node_kind_name);
    END IF;
END $$ LANGUAGE plpgsql;
	
CREATE OR REPLACE FUNCTION genscript_upsert_source_kind(node_kind_name TEXT) RETURNS void AS $$
BEGIN
    IF NOT EXISTS (SELECT id FROM source_kinds WHERE source_kinds.name = node_kind_name) THEN
        INSERT INTO source_kinds (name) VALUES (node_kind_name);
    END IF;
END $$ LANGUAGE plpgsql;
	
CREATE OR REPLACE FUNCTION genscript_upsert_schema_node_kind(v_extension_id INT, v_kind_name VARCHAR(256), v_display_name TEXT, v_description TEXT, v_is_display_kind BOOLEAN, v_icon TEXT, v_icon_color TEXT) RETURNS void AS $$
DECLARE
	retreived_kind_id SMALLINT;
BEGIN
	SELECT id INTO retreived_kind_id FROM kind WHERE name = v_kind_name;
	IF retreived_kind_id IS NULL THEN
		RAISE EXCEPTION 'couldn''t find matching kind_id';
	END IF;
	
	IF NOT EXISTS (SELECT id FROM schema_node_kinds nk WHERE nk.kind_id = retreived_kind_id) THEN
		INSERT INTO schema_node_kinds (schema_extension_id, kind_id, display_name, description, is_display_kind, icon, icon_color) VALUES (v_extension_id, retreived_kind_id, v_display_name, v_description, v_is_display_kind, v_icon, v_icon_color);
	ELSE
		UPDATE schema_node_kinds SET display_name = v_display_name, description = v_description, is_display_kind = v_is_display_kind, icon = v_icon, icon_color = v_icon_color WHERE kind_id = retreived_kind_id;
	END IF;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION genscript_upsert_schema_relationship_kind(v_extension_id INT, v_kind_name VARCHAR(256), v_description TEXT, v_is_traversable BOOLEAN) RETURNS void AS $$
DECLARE
	retreived_kind_id SMALLINT;
BEGIN
	SELECT id INTO retreived_kind_id FROM kind WHERE name = v_kind_name;
	IF retreived_kind_id IS NULL THEN
		RAISE EXCEPTION 'couldn''t find matching kind_id';
	END IF;
	
	IF NOT EXISTS (SELECT id FROM schema_relationship_kinds ek WHERE ek.kind_id = retreived_kind_id) THEN
		INSERT INTO schema_relationship_kinds (schema_extension_id, kind_id, description, is_traversable) VALUES (v_extension_id, retreived_kind_id, v_description, v_is_traversable);
	ELSE
		UPDATE schema_relationship_kinds SET description = v_description, is_traversable = v_is_traversable WHERE kind_id = retreived_kind_id;
	END IF;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION genscript_upsert_schema_environments(v_extension_id INT, v_environment_kind_name VARCHAR(256), v_source_kind_name VARCHAR(256)) RETURNS INTEGER AS $$
DECLARE
	retreived_environment_kind_id SMALLINT;
	retreived_source_kind_id SMALLINT;
	schema_environment_id INTEGER;
BEGIN
	SELECT id INTO retreived_environment_kind_id FROM kind WHERE name = v_environment_kind_name;
	IF retreived_environment_kind_id IS NULL THEN
		RAISE EXCEPTION 'couldn''t find matching kind_id';
	END IF;

	SELECT id INTO retreived_source_kind_id FROM source_kinds WHERE name = v_source_kind_name;
	IF retreived_source_kind_id IS NULL THEN
		RAISE EXCEPTION 'couldn''t find matching kind_id';
	END IF;
	
	IF NOT EXISTS (SELECT id FROM schema_environments se WHERE se.schema_extension_id = v_extension_id) THEN
		INSERT INTO schema_environments (schema_extension_id, environment_kind_id, source_kind_id) VALUES (v_extension_id, retreived_environment_kind_id, retreived_source_kind_id) RETURNING id INTO schema_environment_id;
	ELSE
		UPDATE schema_environments SET environment_kind_id = retreived_environment_kind_id, source_kind_id = retreived_source_kind_id WHERE schema_extension_id = v_extension_id RETURNING id INTO schema_environment_id;
	END IF;

	RETURN schema_environment_id;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION genscript_upsert_schema_environments_principal_kinds(v_environment_id INT, v_principal_kind_name VARCHAR(256)) RETURNS void AS $$
DECLARE
	retreived_kind_id SMALLINT;
BEGIN
	SELECT id INTO retreived_kind_id FROM kind WHERE name = v_principal_kind_name;
	IF retreived_kind_id IS NULL THEN
		RAISE EXCEPTION 'couldn''t find matching kind_id';
	END IF;
	
	IF NOT EXISTS (SELECT 1 FROM schema_environments_principal_kinds pk WHERE pk.principal_kind = retreived_kind_id) THEN
		INSERT INTO schema_environments_principal_kinds (environment_id, principal_kind) VALUES (v_environment_id, retreived_kind_id);
	END IF;
END;
$$ LANGUAGE plpgsql;

DO $$
DECLARE
	extension_id INT;
	environment_id INT;
BEGIN
	LOCK schema_extensions, schema_node_kinds, schema_relationship_kinds, kind;

	IF NOT EXISTS (SELECT id FROM schema_extensions WHERE name = 'AZ') THEN
		INSERT INTO schema_extensions (name, display_name, version, is_builtin, namespace) VALUES ('AZ', 'Azure', 'v0.0.1', true, 'AZ') RETURNING id INTO extension_id;
	ELSE
		UPDATE schema_extensions SET display_name = 'Azure', version = 'v0.0.1', namespace = 'AZ' WHERE name = 'AZ' RETURNING id INTO extension_id;
	END IF;

	-- Insert Node Kinds
	PERFORM genscript_upsert_kind('AZBase');
	PERFORM genscript_upsert_kind('AZVMScaleSet');
	PERFORM genscript_upsert_kind('AZApp');
	PERFORM genscript_upsert_kind('AZRole');
	PERFORM genscript_upsert_kind('AZDevice');
	PERFORM genscript_upsert_kind('AZFunctionApp');
	PERFORM genscript_upsert_kind('AZGroup');
	PERFORM genscript_upsert_kind('AZKeyVault');
	PERFORM genscript_upsert_kind('AZManagementGroup');
	PERFORM genscript_upsert_kind('AZResourceGroup');
	PERFORM genscript_upsert_kind('AZServicePrincipal');
	PERFORM genscript_upsert_kind('AZSubscription');
	PERFORM genscript_upsert_kind('AZTenant');
	PERFORM genscript_upsert_kind('AZUser');
	PERFORM genscript_upsert_kind('AZVM');
	PERFORM genscript_upsert_kind('AZManagedCluster');
	PERFORM genscript_upsert_kind('AZContainerRegistry');
	PERFORM genscript_upsert_kind('AZWebApp');
	PERFORM genscript_upsert_kind('AZLogicApp');
	PERFORM genscript_upsert_kind('AZAutomationAccount');

	-- Insert Relationship Kinds
	PERFORM genscript_upsert_kind('AZAvereContributor');
	PERFORM genscript_upsert_kind('AZContains');
	PERFORM genscript_upsert_kind('AZContributor');
	PERFORM genscript_upsert_kind('AZGetCertificates');
	PERFORM genscript_upsert_kind('AZGetKeys');
	PERFORM genscript_upsert_kind('AZGetSecrets');
	PERFORM genscript_upsert_kind('AZHasRole');
	PERFORM genscript_upsert_kind('AZMemberOf');
	PERFORM genscript_upsert_kind('AZOwner');
	PERFORM genscript_upsert_kind('AZRunsAs');
	PERFORM genscript_upsert_kind('AZVMContributor');
	PERFORM genscript_upsert_kind('AZAutomationContributor');
	PERFORM genscript_upsert_kind('AZKeyVaultContributor');
	PERFORM genscript_upsert_kind('AZVMAdminLogin');
	PERFORM genscript_upsert_kind('AZAddMembers');
	PERFORM genscript_upsert_kind('AZAddSecret');
	PERFORM genscript_upsert_kind('AZExecuteCommand');
	PERFORM genscript_upsert_kind('AZGlobalAdmin');
	PERFORM genscript_upsert_kind('AZPrivilegedAuthAdmin');
	PERFORM genscript_upsert_kind('AZGrant');
	PERFORM genscript_upsert_kind('AZGrantSelf');
	PERFORM genscript_upsert_kind('AZPrivilegedRoleAdmin');
	PERFORM genscript_upsert_kind('AZResetPassword');
	PERFORM genscript_upsert_kind('AZUserAccessAdministrator');
	PERFORM genscript_upsert_kind('AZOwns');
	PERFORM genscript_upsert_kind('AZScopedTo');
	PERFORM genscript_upsert_kind('AZCloudAppAdmin');
	PERFORM genscript_upsert_kind('AZAppAdmin');
	PERFORM genscript_upsert_kind('AZAddOwner');
	PERFORM genscript_upsert_kind('AZManagedIdentity');
	PERFORM genscript_upsert_kind('AZMGApplication_ReadWrite_All');
	PERFORM genscript_upsert_kind('AZMGAppRoleAssignment_ReadWrite_All');
	PERFORM genscript_upsert_kind('AZMGDirectory_ReadWrite_All');
	PERFORM genscript_upsert_kind('AZMGGroup_ReadWrite_All');
	PERFORM genscript_upsert_kind('AZMGGroupMember_ReadWrite_All');
	PERFORM genscript_upsert_kind('AZMGRoleManagement_ReadWrite_Directory');
	PERFORM genscript_upsert_kind('AZMGServicePrincipalEndpoint_ReadWrite_All');
	PERFORM genscript_upsert_kind('AZAKSContributor');
	PERFORM genscript_upsert_kind('AZNodeResourceGroup');
	PERFORM genscript_upsert_kind('AZWebsiteContributor');
	PERFORM genscript_upsert_kind('AZLogicAppContributor');
	PERFORM genscript_upsert_kind('AZMGAddMember');
	PERFORM genscript_upsert_kind('AZMGAddOwner');
	PERFORM genscript_upsert_kind('AZMGAddSecret');
	PERFORM genscript_upsert_kind('AZMGGrantAppRoles');
	PERFORM genscript_upsert_kind('AZMGGrantRole');
	PERFORM genscript_upsert_kind('SyncedToADUser');
	PERFORM genscript_upsert_kind('AZRoleEligible');
	PERFORM genscript_upsert_kind('AZRoleApprover');

	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZBase', 'AZBase', '', false, '', '');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZVMScaleSet', 'AZVMScaleSet', '', true, 'fa-server', '#007CD0');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZApp', 'AZApp', '', true, 'fa-window-restore', '#03FC84');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZRole', 'AZRole', '', true, 'fa-clipboard-list', '#ED8537');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZDevice', 'AZDevice', '', true, 'fa-desktop', '#B18FCF');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZFunctionApp', 'AZFunctionApp', '', true, 'fa-bolt', '#F4BA44');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZGroup', 'AZGroup', '', true, 'fa-users', '#F57C9B');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZKeyVault', 'AZKeyVault', '', true, 'fa-lock', '#ED658C');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZManagementGroup', 'AZManagementGroup', '', true, 'fa-sitemap', '#BD93D8');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZResourceGroup', 'AZResourceGroup', '', true, 'fa-cube', '#89BD9E');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZServicePrincipal', 'AZServicePrincipal', '', true, 'fa-robot', '#C1D6D6');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZSubscription', 'AZSubscription', '', true, 'fa-key', '#D2CCA1');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZTenant', 'AZTenant', '', true, 'fa-cloud', '#54F2F2');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZUser', 'AZUser', '', true, 'fa-user', '#34D2EB');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZVM', 'AZVM', '', true, 'fa-desktop', '#F9ADA0');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZManagedCluster', 'AZManagedCluster', '', true, 'fa-cubes', '#326CE5');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZContainerRegistry', 'AZContainerRegistry', '', true, 'fa-box-open', '#0885D7');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZWebApp', 'AZWebApp', '', true, 'fa-object-group', '#4696E9');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZLogicApp', 'AZLogicApp', '', true, 'fa-sitemap', '#9EE047');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AZAutomationAccount', 'AZAutomationAccount', '', true, 'fa-cog', '#F4BA44');

	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZAvereContributor', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZContains', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZContributor', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZGetCertificates', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZGetKeys', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZGetSecrets', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZHasRole', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMemberOf', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZOwner', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZRunsAs', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZVMContributor', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZAutomationContributor', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZKeyVaultContributor', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZVMAdminLogin', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZAddMembers', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZAddSecret', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZExecuteCommand', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZGlobalAdmin', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZPrivilegedAuthAdmin', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZGrant', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZGrantSelf', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZPrivilegedRoleAdmin', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZResetPassword', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZUserAccessAdministrator', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZOwns', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZScopedTo', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZCloudAppAdmin', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZAppAdmin', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZAddOwner', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZManagedIdentity', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGApplication_ReadWrite_All', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGAppRoleAssignment_ReadWrite_All', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGDirectory_ReadWrite_All', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGGroup_ReadWrite_All', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGGroupMember_ReadWrite_All', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGRoleManagement_ReadWrite_Directory', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGServicePrincipalEndpoint_ReadWrite_All', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZAKSContributor', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZNodeResourceGroup', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZWebsiteContributor', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZLogicAppContributor', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGAddMember', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGAddOwner', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGAddSecret', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGGrantAppRoles', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZMGGrantRole', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'SyncedToADUser', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZRoleEligible', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AZRoleApprover', '', true);

	PERFORM genscript_upsert_source_kind('AZBase');
	PERFORM genscript_upsert_kind('Tenant');
	SELECT genscript_upsert_schema_environments(extension_id, 'Tenant', 'AZBase') INTO environment_id;
	PERFORM genscript_upsert_schema_environments_principal_kinds(environment_id, 'AZUser');
	PERFORM genscript_upsert_schema_environments_principal_kinds(environment_id, 'AZVM');
	PERFORM genscript_upsert_schema_environments_principal_kinds(environment_id, 'AZServicePrincipal');
END $$;

DROP FUNCTION IF EXISTS genscript_upsert_kind;
DROP FUNCTION IF EXISTS genscript_upsert_source_kind;
DROP FUNCTION IF EXISTS genscript_upsert_schema_node_kind;
DROP FUNCTION IF EXISTS genscript_upsert_schema_relationship_kind;
DROP FUNCTION IF EXISTS genscript_upsert_schema_environments;
DROP FUNCTION IF EXISTS genscript_upsert_schema_environments_principal_kinds;
