#
# Copyright (C) 2024 Intel Corporation
#
# Under the Apache License v2.0 with LLVM Exceptions. See LICENSE.TXT.
# SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
#

#!/bin/bash

set -e

SHM_NAME="umf_shm_example"

# port should be a number from the range <1024, 65535>
PORT=$(( 1024 + ( $$ % ( 65535 - 1024 ))))

UMF_LOG_VAL="level:debug;flush:debug;output:stderr;pid:yes"

# make sure the SHM file does not exist
rm -f /dev/shm/${SHM_NAME}

echo "Starting ipc_ipcapi_shm CONSUMER on port $PORT ..."
UMF_LOG=$UMF_LOG_VAL ./umf_example_ipc_ipcapi_consumer $PORT &

echo "Waiting 1 sec ..."
sleep 1

echo "Starting ipc_ipcapi_shm PRODUCER on port $PORT ..."
UMF_LOG=$UMF_LOG_VAL ./umf_example_ipc_ipcapi_producer $PORT $SHM_NAME

# remove the SHM file
rm -f /dev/shm/${SHM_NAME}
