"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BindFileList = BindFileList;
const tslib_1 = require("tslib");
const path = tslib_1.__importStar(require("path"));
const match_1 = require("../match");
const posixify_path_1 = tslib_1.__importDefault(require("../match/posixify-path"));
function _collectFilesFromDirStructureResult(o, a) {
    for (const key in o) {
        if (typeof o[key] === "string")
            a.push(o[key].replace(/^(\.\/)+/g, ""));
        else
            _collectFilesFromDirStructureResult(o[key], a);
    }
}
function collectFilesFromDirStructureResult(o) {
    let a = [];
    _collectFilesFromDirStructureResult(o, a);
    return a;
}
function fileListExec(options, dsg) {
    const { under: dir, pattern, transform } = options;
    const mf = pattern ? (0, match_1.PatternMatch)(pattern) : () => [];
    return async function (target) {
        const [fo] = await target.order(dsg `${dir}`);
        const files = collectFilesFromDirStructureResult(fo);
        const result = [];
        for (const _file of files) {
            const file = (0, posixify_path_1.default)(path.relative(dir, _file));
            const m = mf(file);
            if (!m)
                continue;
            if (transform)
                result.push(transform(_file, file, ...m));
            else
                result.push(_file);
        }
        return result;
    };
}
function BindFileList(dsg) {
    return function FileList(options) {
        const fn = fileListExec(options, dsg);
        return async (target) => {
            return await fn(target);
        };
    };
}
