"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.D = void 0;
var D;
(function (D) {
    class Const {
        constructor(t) {
            this.t = t;
        }
        eval() {
            return this.t;
        }
        derivative() {
            return 0;
        }
    }
    D.Const = Const;
    D.Param = {
        eval(t) {
            return t;
        },
        derivative() {
            return 1;
        }
    };
    class Add {
        constructor(a, b) {
            this.a = a;
            this.b = b;
        }
        eval(t) {
            return this.a.eval(t) + this.b.eval(t);
        }
        derivative(t) {
            return this.a.derivative(t) + this.b.derivative(t);
        }
    }
    D.Add = Add;
    class Sub {
        constructor(a, b) {
            this.a = a;
            this.b = b;
        }
        eval(t) {
            return this.a.eval(t) - this.b.eval(t);
        }
        derivative(t) {
            return this.a.derivative(t) - this.b.derivative(t);
        }
    }
    D.Sub = Sub;
    class Mul {
        constructor(a, b) {
            this.a = a;
            this.b = b;
        }
        eval(t) {
            return this.a.eval(t) * this.b.eval(t);
        }
        derivative(t) {
            return this.a.derivative(t) * this.b.eval(t) + this.b.derivative(t) * this.a.eval(t);
        }
    }
    D.Mul = Mul;
    class Div {
        constructor(a, b) {
            this.a = a;
            this.b = b;
        }
        eval(t) {
            return this.a.eval(t) / this.b.eval(t);
        }
        derivative(t) {
            const zb = this.b.eval(t);
            return (this.a.derivative(t) * zb - this.b.derivative(t) * this.a.eval(t)) / (zb * zb);
        }
    }
    D.Div = Div;
    class Co {
        constructor(a) {
            this.a = a;
        }
        eval(t) {
            return 1 - this.a.eval(t);
        }
        derivative(t) {
            return -this.a.derivative(t);
        }
    }
    D.Co = Co;
    class Nest {
        constructor(a, b) {
            this.a = a;
            this.b = b;
        }
        eval(t) {
            return this.a.eval(this.b.eval(t));
        }
        derivative(t) {
            return this.b.derivative(t) * this.a.derivative(this.b.eval(t));
        }
    }
    D.Nest = Nest;
    class Pow {
        constructor(p) {
            this.p = p;
        }
        eval(t) {
            return Math.pow(t, this.p);
        }
        derivative(t) {
            return this.p * Math.pow(t, this.p - 1);
        }
    }
    D.Pow = Pow;
    class Hermite00 {
        eval(t) {
            return 1 - t * t * (3 - 2 * t);
        }
        derivative(t) {
            return 6 * (t - 1) * t;
        }
    }
    D.Hermite00 = Hermite00;
    class Hermite01 {
        eval(t) {
            return t * t * (3 - 2 * t);
        }
        derivative(t) {
            return -6 * (t - 1) * t;
        }
    }
    D.Hermite01 = Hermite01;
    class Hermite10 {
        eval(t) {
            return t * (t * (t - 2) + 1);
        }
        derivative(t) {
            return t * (3 * t - 4) + 1;
        }
    }
    D.Hermite10 = Hermite10;
    class Hermite11 {
        eval(t) {
            return t * t * (t - 1);
        }
        derivative(t) {
            return t * (3 * t - 2);
        }
    }
    D.Hermite11 = Hermite11;
    class Slice {
        constructor(start, end) {
            this.start = start;
            this.end = end;
        }
        eval(t) {
            return this.start + (this.end - this.start) * t;
        }
        derivative(t) {
            return this.end - this.start;
        }
    }
    D.Slice = Slice;
})(D || (exports.D = D = {}));
