; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -disable-wasm-fallthrough-return-opt -wasm-keep-registers | FileCheck %s

; Test a subset of compiler-rt/libm libcalls expected to be emitted by the wasm backend

target triple = "wasm32-unknown-unknown"

declare fp128 @llvm.sin.f128(fp128)
declare fp128 @llvm.cos.f128(fp128)
declare fp128 @llvm.tan.f128(fp128)
declare fp128 @llvm.asin.f128(fp128)
declare fp128 @llvm.acos.f128(fp128)
declare fp128 @llvm.atan.f128(fp128)
declare fp128 @llvm.sinh.f128(fp128)
declare fp128 @llvm.cosh.f128(fp128)
declare fp128 @llvm.tanh.f128(fp128)
declare fp128 @llvm.atan2.f128(fp128, fp128)

declare double @llvm.sin.f64(double)
declare double @llvm.cos.f64(double)
declare double @llvm.tan.f64(double)
declare double @llvm.asin.f64(double)
declare double @llvm.acos.f64(double)
declare double @llvm.atan.f64(double)
declare double @llvm.sinh.f64(double)
declare double @llvm.cosh.f64(double)
declare double @llvm.tanh.f64(double)
declare double @llvm.atan2.f64(double, double)

declare float @llvm.sin.f32(float)
declare float @llvm.cos.f32(float)
declare float @llvm.tan.f32(float)
declare float @llvm.asin.f32(float)
declare float @llvm.acos.f32(float)
declare float @llvm.atan.f32(float)
declare float @llvm.sinh.f32(float)
declare float @llvm.cosh.f32(float)
declare float @llvm.tanh.f32(float)
declare float @llvm.atan2.f32(float, float)


define fp128 @fp128libcalls(fp128 %x) {
  ; compiler-rt call
; CHECK-LABEL: fp128libcalls:
; CHECK:         .functype fp128libcalls (i32, i64, i64) -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push20=, __stack_pointer
; CHECK-NEXT:    i32.const $push21=, 160
; CHECK-NEXT:    i32.sub  $push43=, $pop20, $pop21
; CHECK-NEXT:    local.tee $push42=, 3, $pop43
; CHECK-NEXT:    global.set __stack_pointer, $pop42
; CHECK-NEXT:    local.get $push44=, 3
; CHECK-NEXT:    i32.const $push40=, 144
; CHECK-NEXT:    i32.add  $push41=, $pop44, $pop40
; CHECK-NEXT:    local.get $push46=, 1
; CHECK-NEXT:    local.get $push45=, 2
; CHECK-NEXT:    call sinl, $pop41, $pop46, $pop45
; CHECK-NEXT:    local.get $push47=, 3
; CHECK-NEXT:    i32.const $push38=, 128
; CHECK-NEXT:    i32.add  $push39=, $pop47, $pop38
; CHECK-NEXT:    local.get $push48=, 3
; CHECK-NEXT:    i64.load $push1=, 144($pop48)
; CHECK-NEXT:    local.get $push49=, 3
; CHECK-NEXT:    i64.load $push0=, 152($pop49)
; CHECK-NEXT:    call cosl, $pop39, $pop1, $pop0
; CHECK-NEXT:    local.get $push50=, 3
; CHECK-NEXT:    i32.const $push36=, 112
; CHECK-NEXT:    i32.add  $push37=, $pop50, $pop36
; CHECK-NEXT:    local.get $push51=, 3
; CHECK-NEXT:    i64.load $push3=, 128($pop51)
; CHECK-NEXT:    local.get $push52=, 3
; CHECK-NEXT:    i64.load $push2=, 136($pop52)
; CHECK-NEXT:    call tanl, $pop37, $pop3, $pop2
; CHECK-NEXT:    local.get $push53=, 3
; CHECK-NEXT:    i32.const $push34=, 96
; CHECK-NEXT:    i32.add  $push35=, $pop53, $pop34
; CHECK-NEXT:    local.get $push54=, 3
; CHECK-NEXT:    i64.load $push5=, 112($pop54)
; CHECK-NEXT:    local.get $push55=, 3
; CHECK-NEXT:    i64.load $push4=, 120($pop55)
; CHECK-NEXT:    call asinl, $pop35, $pop5, $pop4
; CHECK-NEXT:    local.get $push56=, 3
; CHECK-NEXT:    i32.const $push32=, 80
; CHECK-NEXT:    i32.add  $push33=, $pop56, $pop32
; CHECK-NEXT:    local.get $push57=, 3
; CHECK-NEXT:    i64.load $push7=, 96($pop57)
; CHECK-NEXT:    local.get $push58=, 3
; CHECK-NEXT:    i64.load $push6=, 104($pop58)
; CHECK-NEXT:    call acosl, $pop33, $pop7, $pop6
; CHECK-NEXT:    local.get $push59=, 3
; CHECK-NEXT:    i32.const $push30=, 64
; CHECK-NEXT:    i32.add  $push31=, $pop59, $pop30
; CHECK-NEXT:    local.get $push60=, 3
; CHECK-NEXT:    i64.load $push9=, 80($pop60)
; CHECK-NEXT:    local.get $push61=, 3
; CHECK-NEXT:    i64.load $push8=, 88($pop61)
; CHECK-NEXT:    call atanl, $pop31, $pop9, $pop8
; CHECK-NEXT:    local.get $push62=, 3
; CHECK-NEXT:    i32.const $push28=, 48
; CHECK-NEXT:    i32.add  $push29=, $pop62, $pop28
; CHECK-NEXT:    local.get $push63=, 3
; CHECK-NEXT:    i64.load $push11=, 64($pop63)
; CHECK-NEXT:    local.get $push64=, 3
; CHECK-NEXT:    i64.load $push10=, 72($pop64)
; CHECK-NEXT:    call sinhl, $pop29, $pop11, $pop10
; CHECK-NEXT:    local.get $push65=, 3
; CHECK-NEXT:    i32.const $push26=, 32
; CHECK-NEXT:    i32.add  $push27=, $pop65, $pop26
; CHECK-NEXT:    local.get $push66=, 3
; CHECK-NEXT:    i64.load $push13=, 48($pop66)
; CHECK-NEXT:    local.get $push67=, 3
; CHECK-NEXT:    i64.load $push12=, 56($pop67)
; CHECK-NEXT:    call coshl, $pop27, $pop13, $pop12
; CHECK-NEXT:    local.get $push68=, 3
; CHECK-NEXT:    i32.const $push24=, 16
; CHECK-NEXT:    i32.add  $push25=, $pop68, $pop24
; CHECK-NEXT:    local.get $push69=, 3
; CHECK-NEXT:    i64.load $push15=, 32($pop69)
; CHECK-NEXT:    local.get $push70=, 3
; CHECK-NEXT:    i64.load $push14=, 40($pop70)
; CHECK-NEXT:    call tanhl, $pop25, $pop15, $pop14
; CHECK-NEXT:    local.get $push75=, 3
; CHECK-NEXT:    local.get $push74=, 1
; CHECK-NEXT:    local.get $push73=, 2
; CHECK-NEXT:    local.get $push71=, 3
; CHECK-NEXT:    i64.load $push17=, 16($pop71)
; CHECK-NEXT:    local.get $push72=, 3
; CHECK-NEXT:    i64.load $push16=, 24($pop72)
; CHECK-NEXT:    call atan2l, $pop75, $pop74, $pop73, $pop17, $pop16
; CHECK-NEXT:    local.get $push77=, 0
; CHECK-NEXT:    local.get $push76=, 3
; CHECK-NEXT:    i64.load $push18=, 8($pop76)
; CHECK-NEXT:    i64.store 8($pop77), $pop18
; CHECK-NEXT:    local.get $push79=, 0
; CHECK-NEXT:    local.get $push78=, 3
; CHECK-NEXT:    i64.load $push19=, 0($pop78)
; CHECK-NEXT:    i64.store 0($pop79), $pop19
; CHECK-NEXT:    local.get $push80=, 3
; CHECK-NEXT:    i32.const $push22=, 160
; CHECK-NEXT:    i32.add  $push23=, $pop80, $pop22
; CHECK-NEXT:    global.set __stack_pointer, $pop23
; CHECK-NEXT:    return
  ; libm calls
  %d = call fp128 @llvm.sin.f128(fp128 %x)
  %e = call fp128 @llvm.cos.f128(fp128 %d)
  %f = call fp128 @llvm.tan.f128(fp128 %e)
  %g = call fp128 @llvm.asin.f128(fp128 %f)
  %h = call fp128 @llvm.acos.f128(fp128 %g)
  %i = call fp128 @llvm.atan.f128(fp128 %h)
  %a = call fp128 @llvm.sinh.f128(fp128 %i)
  %b = call fp128 @llvm.cosh.f128(fp128 %a)
  %c = call fp128 @llvm.tanh.f128(fp128 %b)
  %j = call fp128 @llvm.atan2.f128(fp128 %x, fp128 %c)
  ret fp128 %j
}

define double @f64libcalls(double %x) {
; CHECK-LABEL: f64libcalls:
; CHECK:         .functype f64libcalls (f64) -> (f64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get $push11=, 0
; CHECK-NEXT:    local.get $push10=, 0
; CHECK-NEXT:    call $push0=, sin, $pop10
; CHECK-NEXT:    call $push1=, cos, $pop0
; CHECK-NEXT:    call $push2=, tan, $pop1
; CHECK-NEXT:    call $push3=, asin, $pop2
; CHECK-NEXT:    call $push4=, acos, $pop3
; CHECK-NEXT:    call $push5=, atan, $pop4
; CHECK-NEXT:    call $push6=, sinh, $pop5
; CHECK-NEXT:    call $push7=, cosh, $pop6
; CHECK-NEXT:    call $push8=, tanh, $pop7
; CHECK-NEXT:    call $push9=, atan2, $pop11, $pop8
; CHECK-NEXT:    return $pop9


 %k = call double @llvm.sin.f64(double %x)
 %a = call double @llvm.cos.f64(double %k)
 %b = call double @llvm.tan.f64(double %a)
 %c = call double @llvm.asin.f64(double %b)
 %d = call double @llvm.acos.f64(double %c)
 %e = call double @llvm.atan.f64(double %d)
 %f = call double @llvm.sinh.f64(double %e)
 %g = call double @llvm.cosh.f64(double %f)
 %h = call double @llvm.tanh.f64(double %g)
 %i = call double @llvm.atan2.f64(double %x, double %h)
 ret double %i
}

define float @f32libcalls(float %x) {
; CHECK-LABEL: f32libcalls:
; CHECK:         .functype f32libcalls (f32) -> (f32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get $push11=, 0
; CHECK-NEXT:    local.get $push10=, 0
; CHECK-NEXT:    call $push0=, sinf, $pop10
; CHECK-NEXT:    call $push1=, cosf, $pop0
; CHECK-NEXT:    call $push2=, tanf, $pop1
; CHECK-NEXT:    call $push3=, asinf, $pop2
; CHECK-NEXT:    call $push4=, acosf, $pop3
; CHECK-NEXT:    call $push5=, atanf, $pop4
; CHECK-NEXT:    call $push6=, sinhf, $pop5
; CHECK-NEXT:    call $push7=, coshf, $pop6
; CHECK-NEXT:    call $push8=, tanhf, $pop7
; CHECK-NEXT:    call $push9=, atan2f, $pop11, $pop8
; CHECK-NEXT:    return $pop9


 %k = call float @llvm.sin.f32(float %x)
 %a = call float @llvm.cos.f32(float %k)
 %b = call float @llvm.tan.f32(float %a)
 %c = call float @llvm.asin.f32(float %b)
 %d = call float @llvm.acos.f32(float %c)
 %e = call float @llvm.atan.f32(float %d)
 %f = call float @llvm.sinh.f32(float %e)
 %g = call float @llvm.cosh.f32(float %f)
 %h = call float @llvm.tanh.f32(float %g)
 %i = call float @llvm.atan2.f32(float %x, float %h)
 ret float %i
}
