// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/*****************************************************************************/
#ifndef SIMD_AS_HWINTRINSIC
#error Define SIMD_AS_HWINTRINSIC before including this file
#endif

#if defined(SIMD_AS_HWINTRINSIC_ID) || defined(SIMD_AS_HWINTRINSIC_NM)
#error SIMD_AS_HWINTRINSIC_ID and SIMD_AS_HWINTRINSIC_NM should not be defined before including this file
#endif
/*****************************************************************************/

// clang-format off

#ifdef FEATURE_HW_INTRINSICS

// Defines a SimdAsHWIntrinsic where the name is implicitly taken from the id
#define SIMD_AS_HWINTRINSIC_ID(classId, id, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)                      \
    SIMD_AS_HWINTRINSIC(classId, id, #id, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)

// Defines a SimdAsHWIntrinsic where the name is explicit
#define SIMD_AS_HWINTRINSIC_NM(classId, id, name, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)                \
    SIMD_AS_HWINTRINSIC(classId, id, name, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)

/* Note
    * Each intrinsic has a unique Intrinsic ID with type of `enum NamedIntrinsic`
    * Each intrinsic has a `NumArg` for number of parameters
    * Each intrinsic has 10 `NamedIntrinsic` fields that list the HWIntrinsic that should be generated based-on the base type
        * NI_Illegal is used to represent an unsupported type
        * Using the same Intrinsic ID as the represented entry is used to indicate special handling is required
    * Each intrinsic has one or more flags with type of `enum SimdAsHWIntrinsicFlag`
*/

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                                                   Flags
//                                                                                                     {TYP_BYTE,                                      TYP_UBYTE,                                      TYP_SHORT,                                      TYP_USHORT,                                     TYP_INT,                                        TYP_UINT,                                       TYP_LONG,                                       TYP_ULONG,                                      TYP_FLOAT,                                      TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Plane Intrinsics
SIMD_AS_HWINTRINSIC_NM(Plane,       Create,                     ".ctor",                    5,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Plane_Create,                                NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_NM(Plane,       CreateFromVector3,          ".ctor",                    3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Plane_CreateFromVector3,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1 | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_NM(Plane,       CreateFromVector4,          ".ctor",                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Plane_CreateFromVector4,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1 | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_ID(Plane,       Dot,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Plane_Dot,                                   NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Plane,       op_Equality,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Plane_op_Equality,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Plane,       op_Inequality,                                          2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Plane_op_Inequality,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                                                   Flags
//                                                                                                     {TYP_BYTE,                                      TYP_UBYTE,                                      TYP_SHORT,                                      TYP_USHORT,                                     TYP_INT,                                        TYP_UINT,                                       TYP_LONG,                                       TYP_ULONG,                                      TYP_FLOAT,                                      TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Quaternion Intrinsics
SIMD_AS_HWINTRINSIC_ID(Quaternion,  Add,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_Add,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  Conjugate,                                              1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_Conjugate,                        NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Quaternion,  Create,                     ".ctor",                    5,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_Create,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_NM(Quaternion,  CreateFromVector3,          ".ctor",                    3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_CreateFromVector3,                NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1 | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  Divide,                                                 2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_Divide,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  Dot,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_Dot,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  get_Identity,                                           0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_get_Identity,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  get_Item,                                               0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_get_Item,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  get_Zero,                                               0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_get_Zero,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  GetElement,                                             2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_GetElement,                       NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  Inverse,                                                1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_Inverse,                          NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  Length,                                                 1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_Length,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  LengthSquared,                                          1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_LengthSquared,                    NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  Multiply,                                               2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_Multiply,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  Negate,                                                 1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_Negate,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  Normalize,                                              1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_Normalize,                        NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  op_Addition,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_op_Addition,                      NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  op_Equality,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_op_Equality,                      NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  op_Inequality,                                          2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_op_Inequality,                    NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  op_Multiply,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_op_Multiply,                      NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  op_Subtraction,                                         2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_op_Subtraction,                   NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  op_UnaryNegation,                                       1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_op_UnaryNegation,                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  Subtract,                                               2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_Subtract,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Quaternion,  WithElement,                                            3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Quaternion_WithElement,                      NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                                                   Flags
//                                                                                                     {TYP_BYTE,                                      TYP_UBYTE,                                      TYP_SHORT,                                      TYP_USHORT,                                     TYP_INT,                                        TYP_UINT,                                       TYP_LONG,                                       TYP_ULONG,                                      TYP_FLOAT,                                      TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector2 Intrinsics
SIMD_AS_HWINTRINSIC_ID(Vector2,     Abs,                                                    1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Abs,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Add,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Add,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Clamp,                                                  3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Clamp,                               NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector2,     Create,                     ".ctor",                    3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Create,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_NM(Vector2,     CreateBroadcast,            ".ctor",                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_CreateBroadcast,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Distance,                                               2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Distance,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     DistanceSquared,                                        2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_DistanceSquared,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Divide,                                                 2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Divide,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Dot,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Dot,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     get_Item,                                               0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_get_Item,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_ID(Vector2,     get_One,                                                0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_get_One,                             NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     get_UnitX,                                              0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_get_UnitX,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     get_UnitY,                                              0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_get_UnitY,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     get_Zero,                                               0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_get_Zero,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     GetElement,                                             2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_GetElement,                          NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Length,                                                 1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Length,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector2,     LengthSquared,                                          1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_LengthSquared,                       NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Lerp,                                                   3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Lerp,                                NI_Illegal},                                    SimdAsHWIntrinsicFlag::SpillSideEffectsOp1 | SimdAsHWIntrinsicFlag::SpillSideEffectsOp2)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Max,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Max,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Min,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Min,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Multiply,                                               2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Multiply,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Negate,                                                 1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Negate,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Normalize,                                              1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Normalize,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Addition,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_op_Addition,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Division,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_op_Division,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Equality,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_op_Equality,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Inequality,                                          2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_op_Inequality,                       NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Multiply,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_op_Multiply,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Subtraction,                                         2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_op_Subtraction,                      NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_UnaryNegation,                                       1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_op_UnaryNegation,                    NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector2,     Sqrt,                       "SquareRoot",               1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Sqrt,                                NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Subtract,                                               2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_Subtract,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     WithElement,                                            3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_WithElement,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                                                   Flags
//                                                                                                     {TYP_BYTE,                                      TYP_UBYTE,                                      TYP_SHORT,                                      TYP_USHORT,                                     TYP_INT,                                        TYP_UINT,                                       TYP_LONG,                                       TYP_ULONG,                                      TYP_FLOAT,                                      TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector3 Intrinsics
SIMD_AS_HWINTRINSIC_ID(Vector3,     Abs,                                                    1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Abs,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Add,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Add,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Clamp,                                                  3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Clamp,                               NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector3,     Create,                     ".ctor",                    4,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Create,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_NM(Vector3,     CreateBroadcast,            ".ctor",                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_CreateBroadcast,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_NM(Vector3,     CreateFromVector2,          ".ctor",                    3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_CreateFromVector2,                   NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1 | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Distance,                                               2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Distance,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     DistanceSquared,                                        2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_DistanceSquared,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Divide,                                                 2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Divide,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Dot,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Dot,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     get_Item,                                               0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_get_Item,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_ID(Vector3,     get_One,                                                0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_get_One,                             NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     get_UnitX,                                              0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_get_UnitX,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     get_UnitY,                                              0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_get_UnitY,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     get_UnitZ,                                              0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_get_UnitZ,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     get_Zero,                                               0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_get_Zero,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     GetElement,                                             2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_GetElement,                          NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Length,                                                 1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Length,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector3,     LengthSquared,                                          1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_LengthSquared,                       NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Lerp,                                                   3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Lerp,                                NI_Illegal},                                    SimdAsHWIntrinsicFlag::SpillSideEffectsOp1 | SimdAsHWIntrinsicFlag::SpillSideEffectsOp2)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Max,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Max,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Min,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Min,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Multiply,                                               2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Multiply,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Negate,                                                 1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Negate,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Normalize,                                              1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Normalize,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Addition,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_op_Addition,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Division,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_op_Division,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Equality,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_op_Equality,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Inequality,                                          2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_op_Inequality,                       NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Multiply,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_op_Multiply,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Subtraction,                                         2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_op_Subtraction,                      NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_UnaryNegation,                                       1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_op_UnaryNegation,                    NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector3,     Sqrt,                       "SquareRoot",               1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Sqrt,                                NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Subtract,                                               2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_Subtract,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     WithElement,                                            3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_WithElement,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                                                   Flags
//                                                                                                     {TYP_BYTE,                                      TYP_UBYTE,                                      TYP_SHORT,                                      TYP_USHORT,                                     TYP_INT,                                        TYP_UINT,                                       TYP_LONG,                                       TYP_ULONG,                                      TYP_FLOAT,                                      TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector4 Intrinsics
SIMD_AS_HWINTRINSIC_ID(Vector4,     Abs,                                                    1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Abs,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Add,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Add,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Clamp,                                                  3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Clamp,                               NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector4,     Create,                     ".ctor",                    5,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Create,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_NM(Vector4,     CreateBroadcast,            ".ctor",                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_CreateBroadcast,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_NM(Vector4,     CreateFromVector2,          ".ctor",                    4,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_CreateFromVector2,                   NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1 | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_NM(Vector4,     CreateFromVector3,          ".ctor",                    3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_CreateFromVector3,                   NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1 | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Distance,                                               2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Distance,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     DistanceSquared,                                        2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_DistanceSquared,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Divide,                                                 2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Divide,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Dot,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Dot,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     get_Item,                                               0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_get_Item,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_ID(Vector4,     get_One,                                                0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_get_One,                             NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     get_UnitX,                                              0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_get_UnitX,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     get_UnitY,                                              0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_get_UnitY,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     get_UnitZ,                                              0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_get_UnitZ,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     get_UnitW,                                              0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_get_UnitW,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     get_Zero,                                               0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_get_Zero,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     GetElement,                                             2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_GetElement,                          NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Length,                                                 1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Length,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector4,     LengthSquared,                                          1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_LengthSquared,                       NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Lerp,                                                   3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Lerp,                                NI_Illegal},                                    SimdAsHWIntrinsicFlag::SpillSideEffectsOp1 | SimdAsHWIntrinsicFlag::SpillSideEffectsOp2)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Max,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Max,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Min,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Min,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Multiply,                                               2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Multiply,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Negate,                                                 1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Negate,                              NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Normalize,                                              1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Normalize,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Addition,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_op_Addition,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Division,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_op_Division,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Equality,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_op_Equality,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Inequality,                                          2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_op_Inequality,                       NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Multiply,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_op_Multiply,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Subtraction,                                         2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_op_Subtraction,                      NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_UnaryNegation,                                       1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_op_UnaryNegation,                    NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector4,     Sqrt,                       "SquareRoot",               1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Sqrt,                                NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Subtract,                                               2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_Subtract,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     WithElement,                                            3,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_WithElement,                         NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                                                   Flags
//                                                                                                     {TYP_BYTE,                                      TYP_UBYTE,                                      TYP_SHORT,                                      TYP_USHORT,                                     TYP_INT,                                        TYP_UINT,                                       TYP_LONG,                                       TYP_ULONG,                                      TYP_FLOAT,                                      TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector<T> Intrinsics
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Abs,                                                    1,         {NI_VectorT128_Abs,                             NI_VectorT128_Abs,                              NI_VectorT128_Abs,                              NI_VectorT128_Abs,                              NI_VectorT128_Abs,                              NI_VectorT128_Abs,                              NI_VectorT128_Abs,                              NI_VectorT128_Abs,                              NI_VectorT128_Abs,                              NI_VectorT128_Abs},                             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Add,                                                    2,         {NI_VectorT128_Add,                             NI_VectorT128_Add,                              NI_VectorT128_Add,                              NI_VectorT128_Add,                              NI_VectorT128_Add,                              NI_VectorT128_Add,                              NI_VectorT128_Add,                              NI_VectorT128_Add,                              NI_VectorT128_Add,                              NI_VectorT128_Add},                             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AndNot,                                                 2,         {NI_VectorT128_AndNot,                          NI_VectorT128_AndNot,                           NI_VectorT128_AndNot,                           NI_VectorT128_AndNot,                           NI_VectorT128_AndNot,                           NI_VectorT128_AndNot,                           NI_VectorT128_AndNot,                           NI_VectorT128_AndNot,                           NI_VectorT128_AndNot,                           NI_VectorT128_AndNot},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  As,                                                     1,         {NI_VectorT128_As,                              NI_VectorT128_As,                               NI_VectorT128_As,                               NI_VectorT128_As,                               NI_VectorT128_As,                               NI_VectorT128_As,                               NI_VectorT128_As,                               NI_VectorT128_As,                               NI_VectorT128_As,                               NI_VectorT128_As},                              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorByte,                                           1,         {NI_VectorT128_AsVectorByte,                    NI_VectorT128_AsVectorByte,                     NI_VectorT128_AsVectorByte,                     NI_VectorT128_AsVectorByte,                     NI_VectorT128_AsVectorByte,                     NI_VectorT128_AsVectorByte,                     NI_VectorT128_AsVectorByte,                     NI_VectorT128_AsVectorByte,                     NI_VectorT128_AsVectorByte,                     NI_VectorT128_AsVectorByte},                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorDouble,                                         1,         {NI_VectorT128_AsVectorDouble,                  NI_VectorT128_AsVectorDouble,                   NI_VectorT128_AsVectorDouble,                   NI_VectorT128_AsVectorDouble,                   NI_VectorT128_AsVectorDouble,                   NI_VectorT128_AsVectorDouble,                   NI_VectorT128_AsVectorDouble,                   NI_VectorT128_AsVectorDouble,                   NI_VectorT128_AsVectorDouble,                   NI_VectorT128_AsVectorDouble},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorInt16,                                          1,         {NI_VectorT128_AsVectorInt16,                   NI_VectorT128_AsVectorInt16,                    NI_VectorT128_AsVectorInt16,                    NI_VectorT128_AsVectorInt16,                    NI_VectorT128_AsVectorInt16,                    NI_VectorT128_AsVectorInt16,                    NI_VectorT128_AsVectorInt16,                    NI_VectorT128_AsVectorInt16,                    NI_VectorT128_AsVectorInt16,                    NI_VectorT128_AsVectorInt16},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorInt32,                                          1,         {NI_VectorT128_AsVectorInt32,                   NI_VectorT128_AsVectorInt32,                    NI_VectorT128_AsVectorInt32,                    NI_VectorT128_AsVectorInt32,                    NI_VectorT128_AsVectorInt32,                    NI_VectorT128_AsVectorInt32,                    NI_VectorT128_AsVectorInt32,                    NI_VectorT128_AsVectorInt32,                    NI_VectorT128_AsVectorInt32,                    NI_VectorT128_AsVectorInt32},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorInt64,                                          1,         {NI_VectorT128_AsVectorInt64,                   NI_VectorT128_AsVectorInt64,                    NI_VectorT128_AsVectorInt64,                    NI_VectorT128_AsVectorInt64,                    NI_VectorT128_AsVectorInt64,                    NI_VectorT128_AsVectorInt64,                    NI_VectorT128_AsVectorInt64,                    NI_VectorT128_AsVectorInt64,                    NI_VectorT128_AsVectorInt64,                    NI_VectorT128_AsVectorInt64},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorNInt,                                           1,         {NI_VectorT128_AsVectorNInt,                    NI_VectorT128_AsVectorNInt,                     NI_VectorT128_AsVectorNInt,                     NI_VectorT128_AsVectorNInt,                     NI_VectorT128_AsVectorNInt,                     NI_VectorT128_AsVectorNInt,                     NI_VectorT128_AsVectorNInt,                     NI_VectorT128_AsVectorNInt,                     NI_VectorT128_AsVectorNInt,                     NI_VectorT128_AsVectorNInt},                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorNUInt,                                          1,         {NI_VectorT128_AsVectorNUInt,                   NI_VectorT128_AsVectorNUInt,                    NI_VectorT128_AsVectorNUInt,                    NI_VectorT128_AsVectorNUInt,                    NI_VectorT128_AsVectorNUInt,                    NI_VectorT128_AsVectorNUInt,                    NI_VectorT128_AsVectorNUInt,                    NI_VectorT128_AsVectorNUInt,                    NI_VectorT128_AsVectorNUInt,                    NI_VectorT128_AsVectorNUInt},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorSByte,                                          1,         {NI_VectorT128_AsVectorSByte,                   NI_VectorT128_AsVectorSByte,                    NI_VectorT128_AsVectorSByte,                    NI_VectorT128_AsVectorSByte,                    NI_VectorT128_AsVectorSByte,                    NI_VectorT128_AsVectorSByte,                    NI_VectorT128_AsVectorSByte,                    NI_VectorT128_AsVectorSByte,                    NI_VectorT128_AsVectorSByte,                    NI_VectorT128_AsVectorSByte},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorSingle,                                         1,         {NI_VectorT128_AsVectorSingle,                  NI_VectorT128_AsVectorSingle,                   NI_VectorT128_AsVectorSingle,                   NI_VectorT128_AsVectorSingle,                   NI_VectorT128_AsVectorSingle,                   NI_VectorT128_AsVectorSingle,                   NI_VectorT128_AsVectorSingle,                   NI_VectorT128_AsVectorSingle,                   NI_VectorT128_AsVectorSingle,                   NI_VectorT128_AsVectorSingle},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorUInt16,                                         1,         {NI_VectorT128_AsVectorUInt16,                  NI_VectorT128_AsVectorUInt16,                   NI_VectorT128_AsVectorUInt16,                   NI_VectorT128_AsVectorUInt16,                   NI_VectorT128_AsVectorUInt16,                   NI_VectorT128_AsVectorUInt16,                   NI_VectorT128_AsVectorUInt16,                   NI_VectorT128_AsVectorUInt16,                   NI_VectorT128_AsVectorUInt16,                   NI_VectorT128_AsVectorUInt16},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorUInt32,                                         1,         {NI_VectorT128_AsVectorUInt32,                  NI_VectorT128_AsVectorUInt32,                   NI_VectorT128_AsVectorUInt32,                   NI_VectorT128_AsVectorUInt32,                   NI_VectorT128_AsVectorUInt32,                   NI_VectorT128_AsVectorUInt32,                   NI_VectorT128_AsVectorUInt32,                   NI_VectorT128_AsVectorUInt32,                   NI_VectorT128_AsVectorUInt32,                   NI_VectorT128_AsVectorUInt32},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AsVectorUInt64,                                         1,         {NI_VectorT128_AsVectorUInt64,                  NI_VectorT128_AsVectorUInt64,                   NI_VectorT128_AsVectorUInt64,                   NI_VectorT128_AsVectorUInt64,                   NI_VectorT128_AsVectorUInt64,                   NI_VectorT128_AsVectorUInt64,                   NI_VectorT128_AsVectorUInt64,                   NI_VectorT128_AsVectorUInt64,                   NI_VectorT128_AsVectorUInt64,                   NI_VectorT128_AsVectorUInt64},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  BitwiseAnd,                                             2,         {NI_VectorT128_BitwiseAnd,                      NI_VectorT128_BitwiseAnd,                       NI_VectorT128_BitwiseAnd,                       NI_VectorT128_BitwiseAnd,                       NI_VectorT128_BitwiseAnd,                       NI_VectorT128_BitwiseAnd,                       NI_VectorT128_BitwiseAnd,                       NI_VectorT128_BitwiseAnd,                       NI_VectorT128_BitwiseAnd,                       NI_VectorT128_BitwiseAnd},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  BitwiseOr,                                              2,         {NI_VectorT128_BitwiseOr,                       NI_VectorT128_BitwiseOr,                        NI_VectorT128_BitwiseOr,                        NI_VectorT128_BitwiseOr,                        NI_VectorT128_BitwiseOr,                        NI_VectorT128_BitwiseOr,                        NI_VectorT128_BitwiseOr,                        NI_VectorT128_BitwiseOr,                        NI_VectorT128_BitwiseOr,                        NI_VectorT128_BitwiseOr},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Ceiling,                                                1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_Ceiling,                          NI_VectorT128_Ceiling},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConditionalSelect,                                      3,         {NI_VectorT128_ConditionalSelect,               NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect},               SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToDouble,                                        1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_ConvertToDouble,                  NI_VectorT128_ConvertToDouble,                  NI_Illegal,                                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToInt32,                                         1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_ConvertToInt32,                   NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToInt64,                                         1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_ConvertToInt64},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToSingle,                                        1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_ConvertToSingle,                  NI_VectorT128_ConvertToSingle,                  NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToUInt32,                                        1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_ConvertToUInt32,                  NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToUInt64,                                        1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_ConvertToUInt64},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(VectorT128,  CreateBroadcast,            ".ctor",                    2,         {NI_VectorT128_CreateBroadcast,                 NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast},                 SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Divide,                                                 2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_Divide,                           NI_VectorT128_Divide},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Dot,                                                    2,         {NI_VectorT128_Dot,                             NI_VectorT128_Dot,                              NI_VectorT128_Dot,                              NI_VectorT128_Dot,                              NI_VectorT128_Dot,                              NI_VectorT128_Dot,                              NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_Dot,                              NI_VectorT128_Dot},                             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Equals,                                                 2,         {NI_VectorT128_Equals,                          NI_VectorT128_Equals,                           NI_VectorT128_Equals,                           NI_VectorT128_Equals,                           NI_VectorT128_Equals,                           NI_VectorT128_Equals,                           NI_VectorT128_Equals,                           NI_VectorT128_Equals,                           NI_VectorT128_Equals,                           NI_VectorT128_Equals},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  EqualsAll,                                              2,         {NI_VectorT128_EqualsAll,                       NI_VectorT128_EqualsAll,                        NI_VectorT128_EqualsAll,                        NI_VectorT128_EqualsAll,                        NI_VectorT128_EqualsAll,                        NI_VectorT128_EqualsAll,                        NI_VectorT128_EqualsAll,                        NI_VectorT128_EqualsAll,                        NI_VectorT128_EqualsAll,                        NI_VectorT128_EqualsAll},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  EqualsAny,                                              2,         {NI_VectorT128_EqualsAny,                       NI_VectorT128_EqualsAny,                        NI_VectorT128_EqualsAny,                        NI_VectorT128_EqualsAny,                        NI_VectorT128_EqualsAny,                        NI_VectorT128_EqualsAny,                        NI_VectorT128_EqualsAny,                        NI_VectorT128_EqualsAny,                        NI_VectorT128_EqualsAny,                        NI_VectorT128_EqualsAny},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Floor,                                                  1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_Floor,                            NI_VectorT128_Floor},                           SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_AllBitsSet,                                         0,         {NI_VectorT128_get_AllBitsSet,                  NI_VectorT128_get_AllBitsSet,                   NI_VectorT128_get_AllBitsSet,                   NI_VectorT128_get_AllBitsSet,                   NI_VectorT128_get_AllBitsSet,                   NI_VectorT128_get_AllBitsSet,                   NI_VectorT128_get_AllBitsSet,                   NI_VectorT128_get_AllBitsSet,                   NI_VectorT128_get_AllBitsSet,                   NI_VectorT128_get_AllBitsSet},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_Item,                                               2,         {NI_VectorT128_get_Item,                        NI_VectorT128_get_Item,                         NI_VectorT128_get_Item,                         NI_VectorT128_get_Item,                         NI_VectorT128_get_Item,                         NI_VectorT128_get_Item,                         NI_VectorT128_get_Item,                         NI_VectorT128_get_Item,                         NI_VectorT128_get_Item,                         NI_VectorT128_get_Item},                        SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_One,                                                0,         {NI_VectorT128_get_One,                         NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_Zero,                                               0,         {NI_VectorT128_get_Zero,                        NI_VectorT128_get_Zero,                         NI_VectorT128_get_Zero,                         NI_VectorT128_get_Zero,                         NI_VectorT128_get_Zero,                         NI_VectorT128_get_Zero,                         NI_VectorT128_get_Zero,                         NI_VectorT128_get_Zero,                         NI_VectorT128_get_Zero,                         NI_VectorT128_get_Zero},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  GetElement,                                             2,         {NI_VectorT128_GetElement,                      NI_VectorT128_GetElement,                       NI_VectorT128_GetElement,                       NI_VectorT128_GetElement,                       NI_VectorT128_GetElement,                       NI_VectorT128_GetElement,                       NI_VectorT128_GetElement,                       NI_VectorT128_GetElement,                       NI_VectorT128_GetElement,                       NI_VectorT128_GetElement},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  GreaterThan,                                            2,         {NI_VectorT128_GreaterThan,                     NI_VectorT128_GreaterThan,                      NI_VectorT128_GreaterThan,                      NI_VectorT128_GreaterThan,                      NI_VectorT128_GreaterThan,                      NI_VectorT128_GreaterThan,                      NI_VectorT128_GreaterThan,                      NI_VectorT128_GreaterThan,                      NI_VectorT128_GreaterThan,                      NI_VectorT128_GreaterThan},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  GreaterThanAll,                                         2,         {NI_VectorT128_GreaterThanAll,                  NI_VectorT128_GreaterThanAll,                   NI_VectorT128_GreaterThanAll,                   NI_VectorT128_GreaterThanAll,                   NI_VectorT128_GreaterThanAll,                   NI_VectorT128_GreaterThanAll,                   NI_VectorT128_GreaterThanAll,                   NI_VectorT128_GreaterThanAll,                   NI_VectorT128_GreaterThanAll,                   NI_VectorT128_GreaterThanAll},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  GreaterThanAny,                                         2,         {NI_VectorT128_GreaterThanAny,                  NI_VectorT128_GreaterThanAny,                   NI_VectorT128_GreaterThanAny,                   NI_VectorT128_GreaterThanAny,                   NI_VectorT128_GreaterThanAny,                   NI_VectorT128_GreaterThanAny,                   NI_VectorT128_GreaterThanAny,                   NI_VectorT128_GreaterThanAny,                   NI_VectorT128_GreaterThanAny,                   NI_VectorT128_GreaterThanAny},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  GreaterThanOrEqual,                                     2,         {NI_VectorT128_GreaterThanOrEqual,              NI_VectorT128_GreaterThanOrEqual,               NI_VectorT128_GreaterThanOrEqual,               NI_VectorT128_GreaterThanOrEqual,               NI_VectorT128_GreaterThanOrEqual,               NI_VectorT128_GreaterThanOrEqual,               NI_VectorT128_GreaterThanOrEqual,               NI_VectorT128_GreaterThanOrEqual,               NI_VectorT128_GreaterThanOrEqual,               NI_VectorT128_GreaterThanOrEqual},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  GreaterThanOrEqualAll,                                  2,         {NI_VectorT128_GreaterThanOrEqualAll,           NI_VectorT128_GreaterThanOrEqualAll,            NI_VectorT128_GreaterThanOrEqualAll,            NI_VectorT128_GreaterThanOrEqualAll,            NI_VectorT128_GreaterThanOrEqualAll,            NI_VectorT128_GreaterThanOrEqualAll,            NI_VectorT128_GreaterThanOrEqualAll,            NI_VectorT128_GreaterThanOrEqualAll,            NI_VectorT128_GreaterThanOrEqualAll,            NI_VectorT128_GreaterThanOrEqualAll},           SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  GreaterThanOrEqualAny,                                  2,         {NI_VectorT128_GreaterThanOrEqualAny,           NI_VectorT128_GreaterThanOrEqualAny,            NI_VectorT128_GreaterThanOrEqualAny,            NI_VectorT128_GreaterThanOrEqualAny,            NI_VectorT128_GreaterThanOrEqualAny,            NI_VectorT128_GreaterThanOrEqualAny,            NI_VectorT128_GreaterThanOrEqualAny,            NI_VectorT128_GreaterThanOrEqualAny,            NI_VectorT128_GreaterThanOrEqualAny,            NI_VectorT128_GreaterThanOrEqualAny},           SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LessThan,                                               2,         {NI_VectorT128_LessThan,                        NI_VectorT128_LessThan,                         NI_VectorT128_LessThan,                         NI_VectorT128_LessThan,                         NI_VectorT128_LessThan,                         NI_VectorT128_LessThan,                         NI_VectorT128_LessThan,                         NI_VectorT128_LessThan,                         NI_VectorT128_LessThan,                         NI_VectorT128_LessThan},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LessThanAll,                                            2,         {NI_VectorT128_LessThanAll,                     NI_VectorT128_LessThanAll,                      NI_VectorT128_LessThanAll,                      NI_VectorT128_LessThanAll,                      NI_VectorT128_LessThanAll,                      NI_VectorT128_LessThanAll,                      NI_VectorT128_LessThanAll,                      NI_VectorT128_LessThanAll,                      NI_VectorT128_LessThanAll,                      NI_VectorT128_LessThanAll},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LessThanAny,                                            2,         {NI_VectorT128_LessThanAny,                     NI_VectorT128_LessThanAny,                      NI_VectorT128_LessThanAny,                      NI_VectorT128_LessThanAny,                      NI_VectorT128_LessThanAny,                      NI_VectorT128_LessThanAny,                      NI_VectorT128_LessThanAny,                      NI_VectorT128_LessThanAny,                      NI_VectorT128_LessThanAny,                      NI_VectorT128_LessThanAny},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LessThanOrEqual,                                        2,         {NI_VectorT128_LessThanOrEqual,                 NI_VectorT128_LessThanOrEqual,                  NI_VectorT128_LessThanOrEqual,                  NI_VectorT128_LessThanOrEqual,                  NI_VectorT128_LessThanOrEqual,                  NI_VectorT128_LessThanOrEqual,                  NI_VectorT128_LessThanOrEqual,                  NI_VectorT128_LessThanOrEqual,                  NI_VectorT128_LessThanOrEqual,                  NI_VectorT128_LessThanOrEqual},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LessThanOrEqualAll,                                     2,         {NI_VectorT128_LessThanOrEqualAll,              NI_VectorT128_LessThanOrEqualAll,               NI_VectorT128_LessThanOrEqualAll,               NI_VectorT128_LessThanOrEqualAll,               NI_VectorT128_LessThanOrEqualAll,               NI_VectorT128_LessThanOrEqualAll,               NI_VectorT128_LessThanOrEqualAll,               NI_VectorT128_LessThanOrEqualAll,               NI_VectorT128_LessThanOrEqualAll,               NI_VectorT128_LessThanOrEqualAll},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LessThanOrEqualAny,                                     2,         {NI_VectorT128_LessThanOrEqualAny,              NI_VectorT128_LessThanOrEqualAny,               NI_VectorT128_LessThanOrEqualAny,               NI_VectorT128_LessThanOrEqualAny,               NI_VectorT128_LessThanOrEqualAny,               NI_VectorT128_LessThanOrEqualAny,               NI_VectorT128_LessThanOrEqualAny,               NI_VectorT128_LessThanOrEqualAny,               NI_VectorT128_LessThanOrEqualAny,               NI_VectorT128_LessThanOrEqualAny},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Load,                                                   1,         {NI_VectorT128_Load,                            NI_VectorT128_Load,                             NI_VectorT128_Load,                             NI_VectorT128_Load,                             NI_VectorT128_Load,                             NI_VectorT128_Load,                             NI_VectorT128_Load,                             NI_VectorT128_Load,                             NI_VectorT128_Load,                             NI_VectorT128_Load},                            SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LoadAligned,                                            1,         {NI_VectorT128_LoadAligned,                     NI_VectorT128_LoadAligned,                      NI_VectorT128_LoadAligned,                      NI_VectorT128_LoadAligned,                      NI_VectorT128_LoadAligned,                      NI_VectorT128_LoadAligned,                      NI_VectorT128_LoadAligned,                      NI_VectorT128_LoadAligned,                      NI_VectorT128_LoadAligned,                      NI_VectorT128_LoadAligned},                     SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LoadAlignedNonTemporal,                                 1,         {NI_VectorT128_LoadAlignedNonTemporal,          NI_VectorT128_LoadAlignedNonTemporal,           NI_VectorT128_LoadAlignedNonTemporal,           NI_VectorT128_LoadAlignedNonTemporal,           NI_VectorT128_LoadAlignedNonTemporal,           NI_VectorT128_LoadAlignedNonTemporal,           NI_VectorT128_LoadAlignedNonTemporal,           NI_VectorT128_LoadAlignedNonTemporal,           NI_VectorT128_LoadAlignedNonTemporal,           NI_VectorT128_LoadAlignedNonTemporal},          SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LoadUnsafe,                                             1,         {NI_VectorT128_LoadUnsafe,                      NI_VectorT128_LoadUnsafe,                       NI_VectorT128_LoadUnsafe,                       NI_VectorT128_LoadUnsafe,                       NI_VectorT128_LoadUnsafe,                       NI_VectorT128_LoadUnsafe,                       NI_VectorT128_LoadUnsafe,                       NI_VectorT128_LoadUnsafe,                       NI_VectorT128_LoadUnsafe,                       NI_VectorT128_LoadUnsafe},                      SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_NM(VectorT128,  LoadUnsafeIndex,            "LoadUnsafe",               2,         {NI_VectorT128_LoadUnsafeIndex,                 NI_VectorT128_LoadUnsafeIndex,                  NI_VectorT128_LoadUnsafeIndex,                  NI_VectorT128_LoadUnsafeIndex,                  NI_VectorT128_LoadUnsafeIndex,                  NI_VectorT128_LoadUnsafeIndex,                  NI_VectorT128_LoadUnsafeIndex,                  NI_VectorT128_LoadUnsafeIndex,                  NI_VectorT128_LoadUnsafeIndex,                  NI_VectorT128_LoadUnsafeIndex},                 SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Max,                                                    2,         {NI_VectorT128_Max,                             NI_VectorT128_Max,                              NI_VectorT128_Max,                              NI_VectorT128_Max,                              NI_VectorT128_Max,                              NI_VectorT128_Max,                              NI_VectorT128_Max,                              NI_VectorT128_Max,                              NI_VectorT128_Max,                              NI_VectorT128_Max},                             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Min,                                                    2,         {NI_VectorT128_Min,                             NI_VectorT128_Min,                              NI_VectorT128_Min,                              NI_VectorT128_Min,                              NI_VectorT128_Min,                              NI_VectorT128_Min,                              NI_VectorT128_Min,                              NI_VectorT128_Min,                              NI_VectorT128_Min,                              NI_VectorT128_Min},                             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Multiply,                                               2,         {NI_VectorT128_Multiply,                        NI_VectorT128_Multiply,                         NI_VectorT128_Multiply,                         NI_VectorT128_Multiply,                         NI_VectorT128_Multiply,                         NI_VectorT128_Multiply,                         NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_Multiply,                         NI_VectorT128_Multiply},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Narrow,                                                 2,         {NI_VectorT128_Narrow,                          NI_VectorT128_Narrow,                           NI_VectorT128_Narrow,                           NI_VectorT128_Narrow,                           NI_VectorT128_Narrow,                           NI_VectorT128_Narrow,                           NI_VectorT128_Narrow,                           NI_VectorT128_Narrow,                           NI_VectorT128_Narrow,                           NI_VectorT128_Narrow},                          SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Negate,                                                 1,         {NI_VectorT128_Negate,                          NI_VectorT128_Negate,                           NI_VectorT128_Negate,                           NI_VectorT128_Negate,                           NI_VectorT128_Negate,                           NI_VectorT128_Negate,                           NI_VectorT128_Negate,                           NI_VectorT128_Negate,                           NI_VectorT128_Negate,                           NI_VectorT128_Negate},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  OnesComplement,                                         2,         {NI_VectorT128_OnesComplement,                  NI_VectorT128_OnesComplement,                   NI_VectorT128_OnesComplement,                   NI_VectorT128_OnesComplement,                   NI_VectorT128_OnesComplement,                   NI_VectorT128_OnesComplement,                   NI_VectorT128_OnesComplement,                   NI_VectorT128_OnesComplement,                   NI_VectorT128_OnesComplement,                   NI_VectorT128_OnesComplement},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Addition,                                            2,         {NI_VectorT128_op_Addition,                     NI_VectorT128_op_Addition,                      NI_VectorT128_op_Addition,                      NI_VectorT128_op_Addition,                      NI_VectorT128_op_Addition,                      NI_VectorT128_op_Addition,                      NI_VectorT128_op_Addition,                      NI_VectorT128_op_Addition,                      NI_VectorT128_op_Addition,                      NI_VectorT128_op_Addition},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_BitwiseAnd,                                          2,         {NI_VectorT128_op_BitwiseAnd,                   NI_VectorT128_op_BitwiseAnd,                    NI_VectorT128_op_BitwiseAnd,                    NI_VectorT128_op_BitwiseAnd,                    NI_VectorT128_op_BitwiseAnd,                    NI_VectorT128_op_BitwiseAnd,                    NI_VectorT128_op_BitwiseAnd,                    NI_VectorT128_op_BitwiseAnd,                    NI_VectorT128_op_BitwiseAnd,                    NI_VectorT128_op_BitwiseAnd},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_BitwiseOr,                                           2,         {NI_VectorT128_op_BitwiseOr,                    NI_VectorT128_op_BitwiseOr,                     NI_VectorT128_op_BitwiseOr,                     NI_VectorT128_op_BitwiseOr,                     NI_VectorT128_op_BitwiseOr,                     NI_VectorT128_op_BitwiseOr,                     NI_VectorT128_op_BitwiseOr,                     NI_VectorT128_op_BitwiseOr,                     NI_VectorT128_op_BitwiseOr,                     NI_VectorT128_op_BitwiseOr},                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Division,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_op_Division,                      NI_VectorT128_op_Division},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Equality,                                            2,         {NI_VectorT128_op_Equality,                     NI_VectorT128_op_Equality,                      NI_VectorT128_op_Equality,                      NI_VectorT128_op_Equality,                      NI_VectorT128_op_Equality,                      NI_VectorT128_op_Equality,                      NI_VectorT128_op_Equality,                      NI_VectorT128_op_Equality,                      NI_VectorT128_op_Equality,                      NI_VectorT128_op_Equality},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_ExclusiveOr,                                         2,         {NI_VectorT128_op_ExclusiveOr,                  NI_VectorT128_op_ExclusiveOr,                   NI_VectorT128_op_ExclusiveOr,                   NI_VectorT128_op_ExclusiveOr,                   NI_VectorT128_op_ExclusiveOr,                   NI_VectorT128_op_ExclusiveOr,                   NI_VectorT128_op_ExclusiveOr,                   NI_VectorT128_op_ExclusiveOr,                   NI_VectorT128_op_ExclusiveOr,                   NI_VectorT128_op_ExclusiveOr},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Explicit,                                            1,         {NI_VectorT128_op_Explicit,                     NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Inequality,                                          2,         {NI_VectorT128_op_Inequality,                   NI_VectorT128_op_Inequality,                    NI_VectorT128_op_Inequality,                    NI_VectorT128_op_Inequality,                    NI_VectorT128_op_Inequality,                    NI_VectorT128_op_Inequality,                    NI_VectorT128_op_Inequality,                    NI_VectorT128_op_Inequality,                    NI_VectorT128_op_Inequality,                    NI_VectorT128_op_Inequality},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_LeftShift,                                           2,         {NI_VectorT128_op_LeftShift,                    NI_VectorT128_op_LeftShift,                     NI_VectorT128_op_LeftShift,                     NI_VectorT128_op_LeftShift,                     NI_VectorT128_op_LeftShift,                     NI_VectorT128_op_LeftShift,                     NI_VectorT128_op_LeftShift,                     NI_VectorT128_op_LeftShift,                     NI_VectorT128_op_LeftShift,                     NI_VectorT128_op_LeftShift},                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Multiply,                                            2,         {NI_VectorT128_op_Multiply,                     NI_VectorT128_op_Multiply,                      NI_VectorT128_op_Multiply,                      NI_VectorT128_op_Multiply,                      NI_VectorT128_op_Multiply,                      NI_VectorT128_op_Multiply,                      NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_op_Multiply,                      NI_VectorT128_op_Multiply},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_OnesComplement,                                      1,         {NI_VectorT128_op_OnesComplement,               NI_VectorT128_op_OnesComplement,                NI_VectorT128_op_OnesComplement,                NI_VectorT128_op_OnesComplement,                NI_VectorT128_op_OnesComplement,                NI_VectorT128_op_OnesComplement,                NI_VectorT128_op_OnesComplement,                NI_VectorT128_op_OnesComplement,                NI_VectorT128_op_OnesComplement,                NI_VectorT128_op_OnesComplement},               SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_RightShift,                                          2,         {NI_VectorT128_op_RightShift,                   NI_VectorT128_op_RightShift,                    NI_VectorT128_op_RightShift,                    NI_VectorT128_op_RightShift,                    NI_VectorT128_op_RightShift,                    NI_VectorT128_op_RightShift,                    NI_VectorT128_op_RightShift,                    NI_VectorT128_op_RightShift,                    NI_VectorT128_op_RightShift,                    NI_VectorT128_op_RightShift},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Subtraction,                                         2,         {NI_VectorT128_op_Subtraction,                  NI_VectorT128_op_Subtraction,                   NI_VectorT128_op_Subtraction,                   NI_VectorT128_op_Subtraction,                   NI_VectorT128_op_Subtraction,                   NI_VectorT128_op_Subtraction,                   NI_VectorT128_op_Subtraction,                   NI_VectorT128_op_Subtraction,                   NI_VectorT128_op_Subtraction,                   NI_VectorT128_op_Subtraction},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_UnaryNegation,                                       1,         {NI_VectorT128_op_UnaryNegation,                NI_VectorT128_op_UnaryNegation,                 NI_VectorT128_op_UnaryNegation,                 NI_VectorT128_op_UnaryNegation,                 NI_VectorT128_op_UnaryNegation,                 NI_VectorT128_op_UnaryNegation,                 NI_VectorT128_op_UnaryNegation,                 NI_VectorT128_op_UnaryNegation,                 NI_VectorT128_op_UnaryNegation,                 NI_VectorT128_op_UnaryNegation},                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_UnaryPlus,                                           1,         {NI_VectorT128_op_UnaryPlus,                    NI_VectorT128_op_UnaryPlus,                     NI_VectorT128_op_UnaryPlus,                     NI_VectorT128_op_UnaryPlus,                     NI_VectorT128_op_UnaryPlus,                     NI_VectorT128_op_UnaryPlus,                     NI_VectorT128_op_UnaryPlus,                     NI_VectorT128_op_UnaryPlus,                     NI_VectorT128_op_UnaryPlus,                     NI_VectorT128_op_UnaryPlus},                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_UnsignedRightShift,                                  2,         {NI_VectorT128_op_UnsignedRightShift,           NI_VectorT128_op_UnsignedRightShift,            NI_VectorT128_op_UnsignedRightShift,            NI_VectorT128_op_UnsignedRightShift,            NI_VectorT128_op_UnsignedRightShift,            NI_VectorT128_op_UnsignedRightShift,            NI_VectorT128_op_UnsignedRightShift,            NI_VectorT128_op_UnsignedRightShift,            NI_VectorT128_op_UnsignedRightShift,            NI_VectorT128_op_UnsignedRightShift},           SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ShiftLeft,                                              2,         {NI_VectorT128_ShiftLeft,                       NI_VectorT128_ShiftLeft,                        NI_VectorT128_ShiftLeft,                        NI_VectorT128_ShiftLeft,                        NI_VectorT128_ShiftLeft,                        NI_VectorT128_ShiftLeft,                        NI_VectorT128_ShiftLeft,                        NI_VectorT128_ShiftLeft,                        NI_Illegal,                                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ShiftRightArithmetic,                                   2,         {NI_VectorT128_ShiftRightArithmetic,            NI_Illegal,                                     NI_VectorT128_ShiftRightArithmetic,             NI_Illegal,                                     NI_VectorT128_ShiftRightArithmetic,             NI_Illegal,                                     NI_VectorT128_ShiftRightArithmetic,             NI_Illegal,                                     NI_Illegal,                                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ShiftRightLogical,                                      2,         {NI_VectorT128_ShiftRightLogical,               NI_VectorT128_ShiftRightLogical,                NI_VectorT128_ShiftRightLogical,                NI_VectorT128_ShiftRightLogical,                NI_VectorT128_ShiftRightLogical,                NI_VectorT128_ShiftRightLogical,                NI_VectorT128_ShiftRightLogical,                NI_VectorT128_ShiftRightLogical,                NI_Illegal,                                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(VectorT128,  Sqrt,                       "SquareRoot",               1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_VectorT128_Sqrt,                             NI_VectorT128_Sqrt},                            SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Store,                                                  2,         {NI_VectorT128_Store,                           NI_VectorT128_Store,                            NI_VectorT128_Store,                            NI_VectorT128_Store,                            NI_VectorT128_Store,                            NI_VectorT128_Store,                            NI_VectorT128_Store,                            NI_VectorT128_Store,                            NI_VectorT128_Store,                            NI_VectorT128_Store},                           SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  StoreAligned,                                           2,         {NI_VectorT128_StoreAligned,                    NI_VectorT128_StoreAligned,                     NI_VectorT128_StoreAligned,                     NI_VectorT128_StoreAligned,                     NI_VectorT128_StoreAligned,                     NI_VectorT128_StoreAligned,                     NI_VectorT128_StoreAligned,                     NI_VectorT128_StoreAligned,                     NI_VectorT128_StoreAligned,                     NI_VectorT128_StoreAligned},                    SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  StoreAlignedNonTemporal,                                2,         {NI_VectorT128_StoreAlignedNonTemporal,         NI_VectorT128_StoreAlignedNonTemporal,          NI_VectorT128_StoreAlignedNonTemporal,          NI_VectorT128_StoreAlignedNonTemporal,          NI_VectorT128_StoreAlignedNonTemporal,          NI_VectorT128_StoreAlignedNonTemporal,          NI_VectorT128_StoreAlignedNonTemporal,          NI_VectorT128_StoreAlignedNonTemporal,          NI_VectorT128_StoreAlignedNonTemporal,          NI_VectorT128_StoreAlignedNonTemporal},         SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  StoreUnsafe,                                            2,         {NI_VectorT128_StoreUnsafe,                     NI_VectorT128_StoreUnsafe,                      NI_VectorT128_StoreUnsafe,                      NI_VectorT128_StoreUnsafe,                      NI_VectorT128_StoreUnsafe,                      NI_VectorT128_StoreUnsafe,                      NI_VectorT128_StoreUnsafe,                      NI_VectorT128_StoreUnsafe,                      NI_VectorT128_StoreUnsafe,                      NI_VectorT128_StoreUnsafe},                     SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_NM(VectorT128,  StoreUnsafeIndex,           "StoreUnsafe",              3,         {NI_VectorT128_StoreUnsafeIndex,                NI_VectorT128_StoreUnsafeIndex,                 NI_VectorT128_StoreUnsafeIndex,                 NI_VectorT128_StoreUnsafeIndex,                 NI_VectorT128_StoreUnsafeIndex,                 NI_VectorT128_StoreUnsafeIndex,                 NI_VectorT128_StoreUnsafeIndex,                 NI_VectorT128_StoreUnsafeIndex,                 NI_VectorT128_StoreUnsafeIndex,                 NI_VectorT128_StoreUnsafeIndex},                SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Subtract,                                               2,         {NI_VectorT128_Subtract,                        NI_VectorT128_Subtract,                         NI_VectorT128_Subtract,                         NI_VectorT128_Subtract,                         NI_VectorT128_Subtract,                         NI_VectorT128_Subtract,                         NI_VectorT128_Subtract,                         NI_VectorT128_Subtract,                         NI_VectorT128_Subtract,                         NI_VectorT128_Subtract},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Sum,                                                    1,         {NI_VectorT128_Sum,                             NI_VectorT128_Sum,                              NI_VectorT128_Sum,                              NI_VectorT128_Sum,                              NI_VectorT128_Sum,                              NI_VectorT128_Sum,                              NI_VectorT128_Sum,                              NI_VectorT128_Sum,                              NI_VectorT128_Sum,                              NI_VectorT128_Sum},                             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ToScalar,                                               1,         {NI_VectorT128_ToScalar,                        NI_VectorT128_ToScalar,                         NI_VectorT128_ToScalar,                         NI_VectorT128_ToScalar,                         NI_VectorT128_ToScalar,                         NI_VectorT128_ToScalar,                         NI_VectorT128_ToScalar,                         NI_VectorT128_ToScalar,                         NI_VectorT128_ToScalar,                         NI_VectorT128_ToScalar},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  WidenLower,                                             1,         {NI_VectorT128_WidenLower,                      NI_VectorT128_WidenLower,                       NI_VectorT128_WidenLower,                       NI_VectorT128_WidenLower,                       NI_VectorT128_WidenLower,                       NI_VectorT128_WidenLower,                       NI_VectorT128_WidenLower,                       NI_VectorT128_WidenLower,                       NI_VectorT128_WidenLower,                       NI_VectorT128_WidenLower},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  WidenUpper,                                             1,         {NI_VectorT128_WidenUpper,                      NI_VectorT128_WidenUpper,                       NI_VectorT128_WidenUpper,                       NI_VectorT128_WidenUpper,                       NI_VectorT128_WidenUpper,                       NI_VectorT128_WidenUpper,                       NI_VectorT128_WidenUpper,                       NI_VectorT128_WidenUpper,                       NI_VectorT128_WidenUpper,                       NI_VectorT128_WidenUpper},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  WithElement,                                            3,         {NI_VectorT128_WithElement,                     NI_VectorT128_WithElement,                      NI_VectorT128_WithElement,                      NI_VectorT128_WithElement,                      NI_VectorT128_WithElement,                      NI_VectorT128_WithElement,                      NI_VectorT128_WithElement,                      NI_VectorT128_WithElement,                      NI_VectorT128_WithElement,                      NI_VectorT128_WithElement},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Xor,                                                    2,         {NI_VectorT128_Xor,                             NI_VectorT128_Xor,                              NI_VectorT128_Xor,                              NI_VectorT128_Xor,                              NI_VectorT128_Xor,                              NI_VectorT128_Xor,                              NI_VectorT128_Xor,                              NI_VectorT128_Xor,                              NI_VectorT128_Xor,                              NI_VectorT128_Xor},                             SimdAsHWIntrinsicFlag::None)

#undef SIMD_AS_HWINTRINSIC_NM
#undef SIMD_AS_HWINTRINSIC_ID

#endif // FEATURE_HW_INTRINSICS

#undef SIMD_AS_HWINTRINSIC

// clang-format on
