# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class DatasetConsumptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    RUN_INPUT = "RunInput"
    REFERENCE = "Reference"

class DatasetDeliveryMechanism(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    DIRECT = "Direct"
    MOUNT = "Mount"
    DOWNLOAD = "Download"
    HDFS = "Hdfs"

class DatasetOutputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    RUN_OUTPUT = "RunOutput"
    REFERENCE = "Reference"

class ExperimentViewType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ViewType filters experiments by their archived state. Default is ActiveOnly
    """

    DEFAULT = "Default"
    ALL = "All"
    ACTIVE_ONLY = "ActiveOnly"
    ARCHIVED_ONLY = "ArchivedOnly"

class MetricValueType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    INT = "Int"
    DOUBLE = "Double"
    STRING = "String"
    BOOL = "Bool"
    ARTIFACT = "Artifact"

class RunStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets span status.
    OpenTelemetry sets it to
    https://github.com/open-telemetry/opentelemetry-dotnet/blob/master/src/OpenTelemetry.Api/Trace/Status.cs
    That status enums are not very meaningful to us, so we customize this.
    """

    NOT_STARTED = "NotStarted"
    UNAPPROVED = "Unapproved"
    PAUSING = "Pausing"
    PAUSED = "Paused"
    STARTING = "Starting"
    PREPARING = "Preparing"
    QUEUED = "Queued"
    RUNNING = "Running"
    FINALIZING = "Finalizing"
    CANCEL_REQUESTED = "CancelRequested"
    COMPLETED = "Completed"
    FAILED = "Failed"
    CANCELED = "Canceled"

class SortOrderDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    ASC = "Asc"
    DESC = "Desc"

class StoredProcedureParameterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    STRING = "String"
    INT = "Int"
    DECIMAL = "Decimal"
    GUID = "Guid"
    BOOLEAN = "Boolean"
    DATE = "Date"
